/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.core.lib.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.dosgi.repository.descriptor.Session;

public class ModelBusClientURIHandler
extends URIHandlerImpl {
    private IRepositoryHelper repoHelper;
    private Session session;

    public ModelBusClientURIHandler(IRepositoryHelper repoHelper) {
        this.repoHelper = repoHelper;
    }

    public boolean canHandle(URI uri) {
        if (uri.isPlatform()) {
            return false;
        }
        return this.exists(uri, null);
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        try {
            return this.repoHelper.exists(this.session, uri, "-1");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        try {
            return this.repoHelper.checkOutFile(this.session, uri, "-1");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        return new ByteArrayOutputStream();
    }

    public void delete(URI uri, Map<?, ?> options) {
        try {
            this.repoHelper.delete(this.session, uri, "TODO message");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }
}

