/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.repository.external.api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelbus.dosgi.repository.descriptor.RepositoryDirEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryNodeKind;
import org.modelbus.repository.external.api.ExternalRepositoryConfiguration;
import org.modelbus.repository.external.api.ExternalRepositoryConfigurationException;
import org.modelbus.repository.external.api.ExternalRepositoryException;
import org.modelbus.repository.external.api.IExternalRepository;

public abstract class AbstractExternalRepository
implements IExternalRepository {
    public static final String PROP_REPO_TYPE = "repoType";
    public static final String PROP_REPO_CLASS = "implementationClass";
    public static final String PROPERTY_NOT_AVAILABLE_LABEL = "n/a";
    public static final String PROPERTY_COMMIT_MESSAGE = "commitMessage";
    public static final String PROPERTY_LAST_AUTHOR = "lastAuthor";
    public static final String PROPERTY_REVISION = "revision";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_CREATE_DATE = "createDate";
    public static final String PROPERTY_CHANGE_DATE = "changeDate";
    private final boolean initialized = false;
    protected ExternalRepositoryConfiguration config;

    @Override
    public final void initialize(ExternalRepositoryConfiguration config) throws ExternalRepositoryConfigurationException {
        this.config = config;
    }

    protected Object getConfigurationProperty(String name) throws ExternalRepositoryConfigurationException {
        if (this.config.isPropertySet(name)) {
            return this.config.getProperty(name);
        }
        throw new ExternalRepositoryConfigurationException("Configuration property " + name + " not set.");
    }

    protected String getConfigurationStringProperty(String name) throws ExternalRepositoryConfigurationException {
        return this.getConfigurationProperty(name).toString();
    }

    protected File createTempFile(Resource model) throws IOException {
        File tempFile = File.createTempFile("temp", ".modelbus");
        tempFile.deleteOnExit();
        model.save((OutputStream)new FileOutputStream(tempFile), Collections.EMPTY_MAP);
        return tempFile;
    }

    @Override
    public RepositoryDirEntry getInfo(URI uri) throws ExternalRepositoryException {
        return this.getInfo(uri, null);
    }

    public RepositoryDirEntry getInfo(URI uri, Map<String, Object> properties) throws ExternalRepositoryException {
        RepositoryDirEntry entry = new RepositoryDirEntry();
        entry.setCommitMessage(AbstractExternalRepository.getEntryStringProperty(properties, PROPERTY_COMMIT_MESSAGE));
        entry.setKind(RepositoryNodeKind.MODEL);
        entry.setLastAuthor(AbstractExternalRepository.getEntryStringProperty(properties, PROPERTY_NAME));
        entry.setName(AbstractExternalRepository.getEntryStringProperty(properties, PROPERTY_COMMIT_MESSAGE, uri.lastSegment()));
        entry.setUri(uri.toString());
        entry.setSize(Long.valueOf(0L));
        entry.setRevision(AbstractExternalRepository.getEntryStringProperty(properties, PROPERTY_REVISION));
        entry.setCreationDate(AbstractExternalRepository.getEntryDateProperty(properties, PROPERTY_CREATE_DATE));
        entry.setChangeDate(AbstractExternalRepository.getEntryDateProperty(properties, PROPERTY_CHANGE_DATE));
        return entry;
    }

    private static XMLGregorianCalendar getEntryDateProperty(Map<String, Object> properties, String propName) {
        Object dateValue = AbstractExternalRepository.getEntryProperty(properties, propName, null);
        if (dateValue instanceof Date) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime((Date)dateValue);
            try {
                return DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
            }
            catch (DatatypeConfigurationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static String getEntryStringProperty(Map<String, Object> properties, String propName) {
        return AbstractExternalRepository.getEntryStringProperty(properties, propName, null).toString();
    }

    private static String getEntryStringProperty(Map<String, Object> properties, String propName, String defaultValue) {
        return AbstractExternalRepository.getEntryProperty(properties, propName, defaultValue).toString();
    }

    private static Object getEntryProperty(Map<String, Object> properties, String propName, String defaultValue) {
        if (properties == null || properties.containsKey(propName)) {
            if (defaultValue != null) {
                return defaultValue;
            }
            return PROPERTY_NOT_AVAILABLE_LABEL;
        }
        if (properties.get(propName) == null) {
            return PROPERTY_NOT_AVAILABLE_LABEL;
        }
        return properties.get(propName);
    }
}

