/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.repository.external.api;

import config.ExternalLocation;
import config.Filter;
import config.Location;
import config.LocationProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.modelbus.core.lib.configuration.ModelBusConfiguration;
import org.modelbus.core.lib.configuration.ModelBusException;
import org.modelbus.core.lib.util.AbstractLocationsUtil;
import org.modelbus.repository.external.api.AbstractExternalRepository;
import org.modelbus.repository.external.api.ExternalRepositoryConfiguration;
import org.modelbus.repository.external.api.ExternalRepositoryConfigurationException;

public class ExternalRepositoryFactory {
    private static final String EXTENSION_POINT_ID = "org.modelbus.externalrepository";
    protected Map<String, AbstractExternalRepository> createdRepositories = new HashMap<String, AbstractExternalRepository>();
    private static ExternalRepositoryFactory _instance;
    protected IExtension[] extensions;

    private ExternalRepositoryFactory() {
    }

    public static synchronized ExternalRepositoryFactory getInstance() {
        if (_instance == null) {
            _instance = new ExternalRepositoryFactory();
            _instance.initialize();
        }
        return _instance;
    }

    public AbstractExternalRepository[] getAllRepositories() throws ExternalRepositoryConfigurationException {
        ExternalLocation[] externalLocations;
        try {
            externalLocations = ModelBusConfiguration.getExternalLocations();
        }
        catch (ModelBusException e) {
            throw new ExternalRepositoryConfigurationException(e);
        }
        ArrayList<AbstractExternalRepository> repositories = new ArrayList<AbstractExternalRepository>();
        ExternalLocation[] externalLocationArray = externalLocations;
        int n = externalLocations.length;
        int n2 = 0;
        while (n2 < n) {
            ExternalLocation externalLocation = externalLocationArray[n2];
            AbstractExternalRepository extRepo = this.getRepositoryByLocation(externalLocation);
            if (extRepo != null) {
                repositories.add(extRepo);
            }
            ++n2;
        }
        return repositories.toArray(new AbstractExternalRepository[repositories.size()]);
    }

    private static void mapProperty(String propertyName, String configPropertyName, Location location, ExternalRepositoryConfiguration config) {
        LocationProperty property = ModelBusConfiguration.getLocationProperty((Location)location, (String)propertyName);
        if (property == null) {
            return;
        }
        String propertyValue = property.getValue();
        if (propertyValue == null || propertyValue.trim().equals("")) {
            return;
        }
        config.setProperty(configPropertyName, propertyValue);
    }

    protected AbstractExternalRepository getRepositoryByLocation(ExternalLocation externalLocation) throws ExternalRepositoryConfigurationException {
        if (externalLocation == null) {
            return null;
        }
        String serviceRootURI = AbstractLocationsUtil.getExternalLocation((String)externalLocation.getLocation());
        if (!this.createdRepositories.containsKey(serviceRootURI)) {
            LocationProperty typeProperty = ModelBusConfiguration.getLocationProperty((Location)externalLocation, (String)"type");
            if (typeProperty != null) {
                String repoType = typeProperty.getValue();
                IExtension[] iExtensionArray = this.extensions;
                int n = this.extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension element = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = element.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement c = iConfigurationElementArray[n4];
                        String currentRepoType = c.getAttribute("repoType");
                        if (currentRepoType.toLowerCase().equals(repoType.toLowerCase())) {
                            AbstractExternalRepository repo;
                            try {
                                repo = (AbstractExternalRepository)c.createExecutableExtension("implementationClass");
                            }
                            catch (CoreException e) {
                                throw new ExternalRepositoryConfigurationException(e);
                            }
                            ExternalRepositoryConfiguration config = new ExternalRepositoryConfiguration();
                            config.setProperty("rootURI", serviceRootURI);
                            ExternalRepositoryFactory.mapProperty("publicRootURI", "publicRootURI", (Location)externalLocation, config);
                            ExternalRepositoryFactory.mapProperty("rootServicesURI", "rootServicesURI", (Location)externalLocation, config);
                            ExternalRepositoryFactory.mapProperty("username", "username", (Location)externalLocation, config);
                            ExternalRepositoryFactory.mapProperty("password", "password", (Location)externalLocation, config);
                            ExternalRepositoryFactory.mapProperty("OAuthUser", "oAuthUser", (Location)externalLocation, config);
                            ExternalRepositoryFactory.mapProperty("OAuthSecret", "oAuthSecret", (Location)externalLocation, config);
                            EList filters = externalLocation.getFilter();
                            if (!filters.isEmpty()) {
                                ArrayList<ExternalRepositoryConfiguration.LocationFilter> locationFilters = new ArrayList<ExternalRepositoryConfiguration.LocationFilter>();
                                for (Filter filter : filters) {
                                    ExternalRepositoryConfiguration.FilterType type = ExternalRepositoryConfiguration.FilterType.Include;
                                    if (filter.getType().getLiteral().equals("exclude")) {
                                        type = ExternalRepositoryConfiguration.FilterType.Exclude;
                                    }
                                    ExternalRepositoryConfiguration.LocationFilter locFilter = new ExternalRepositoryConfiguration.LocationFilter(filter.getValue(), type);
                                    locationFilters.add(locFilter);
                                }
                                config.setProperty("locationFilter", locationFilters);
                            }
                            try {
                                repo.initialize(config);
                            }
                            catch (ExternalRepositoryConfigurationException e) {
                                throw new RuntimeException(e);
                            }
                            this.createdRepositories.put(serviceRootURI, repo);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            if (this.createdRepositories.containsKey(serviceRootURI)) {
                return this.createdRepositories.get(serviceRootURI);
            }
            return null;
        }
        return this.createdRepositories.get(serviceRootURI);
    }

    public AbstractExternalRepository getRepository(URI uri) throws ExternalRepositoryConfigurationException {
        ExternalLocation[] externalLocations;
        try {
            externalLocations = ModelBusConfiguration.getExternalLocations();
        }
        catch (ModelBusException exc) {
            throw new ExternalRepositoryConfigurationException(exc);
        }
        ExternalLocation externalLocation = null;
        ExternalLocation[] externalLocationArray = externalLocations;
        int n = externalLocations.length;
        int n2 = 0;
        while (n2 < n) {
            ExternalLocation location = externalLocationArray[n2];
            String locationValue = location.getLocation();
            if (locationValue != null && uri.toString().startsWith(AbstractLocationsUtil.getExternalLocation((String)locationValue))) {
                externalLocation = location;
                break;
            }
            ++n2;
        }
        return this.getRepositoryByLocation(externalLocation);
    }

    protected void initialize() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            this.extensions = new IExtension[0];
            return;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT_ID);
        this.extensions = extensionPoint.getExtensions();
    }
}

