/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.model;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.modelbus.tools.diffmerge.model.DiffElement;
import org.modelbus.tools.diffmerge.model.DiffElementCollection;
import org.modelbus.tools.diffmerge.model.DiffKind;
import org.modelbus.tools.diffmerge.model.DiffModelElement;
import org.modelbus.tools.diffmerge.model.DiffModelException;
import org.modelbus.tools.diffmerge.model.DiffSource;
import org.modelbus.tools.diffmerge.model.DiffType;
import org.modelbus.tools.diffmerge.model.collections.DiffCollection;

abstract class DiffElementLeaf
implements DiffElement {
    private final DiffElement parent;

    protected DiffElementLeaf(DiffElement parent) {
        this.parent = parent;
    }

    public Optional<DiffModelElement> getParentElement() {
        return Optional.of((Object)this.parent);
    }

    public List<DiffModelElement> getSubElements() {
        return Lists.newLinkedList();
    }

    public DiffCollection<DiffElement> getAllDiffElements() {
        return DiffElementCollection.createNewCollection();
    }

    public DiffCollection<DiffElement> getDiffElements() {
        return DiffElementCollection.createNewCollection();
    }

    public EStructuralFeature getAffectedFeature() {
        return this.parent.getAffectedFeature();
    }

    public EObject getAffectedModelElement() {
        return this.parent.getAffectedModelElement();
    }

    public DiffKind getKind() {
        return this.parent.getKind();
    }

    public EObject getLeftElement() {
        return this.parent.getLeftElement();
    }

    public Optional<EObject> getOriginElement() {
        return this.parent.getOriginElement();
    }

    public EObject getRightElement() {
        return this.parent.getRightElement();
    }

    public DiffSource getSource() {
        return this.parent.getSource();
    }

    public boolean isConflict() {
        return this.parent.isConflict();
    }

    public void mergeFromLeftToRight() {
        throw new DiffModelException("Not implemented in " + DiffElementLeaf.class.getName());
    }

    public void mergeFromRightToLeft() {
        throw new DiffModelException("Not implemented in " + DiffElementLeaf.class.getName());
    }

    public List<DiffModelElement> getAllSubElements() {
        return this.parent.getAllSubElements();
    }

    DiffElement getParent() {
        return this.parent;
    }

    public Object getValue() {
        return this.parent.getValue();
    }

    public void removeSubElement(DiffModelElement element) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeConflictingSubElement(DiffModelElement conflictingElement) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public DiffCollection<DiffElement> getConflictingElements() {
        return this.parent.getConflictingElements();
    }

    public DiffType getDiffType() {
        return this.parent.getDiffType();
    }
}

