/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.protocol;

import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.remote.AbstractOperationHandler;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WidgetOperationHandler<T extends Widget>
extends AbstractOperationHandler {
    private final T widget;

    public WidgetOperationHandler(T widget) {
        this.widget = widget;
    }

    @Override
    public void handleSet(JsonObject properties) {
        this.handleSet(this.widget, properties);
    }

    @Override
    public void handleCall(String method, JsonObject parameters) {
        this.handleCall(this.widget, method, parameters);
    }

    @Override
    public void handleNotify(String eventName, JsonObject properties) {
        this.handleNotify(this.widget, eventName, properties);
    }

    public void handleSet(T widget, JsonObject properties) {
        throw new UnsupportedOperationException("set operations not supported by this handler");
    }

    public void handleCall(T widget, String method, JsonObject parameters) {
        throw new UnsupportedOperationException("call operations not supported by this handler");
    }

    public void handleNotify(T widget, String eventName, JsonObject properties) {
        throw new UnsupportedOperationException("notify operations not supported by this handler");
    }

    protected static Event createSelectionEvent(int eventType, JsonObject properties) {
        Event event = new Event();
        event.type = eventType;
        event.stateMask = WidgetOperationHandler.readStateMask(properties);
        event.detail = WidgetOperationHandler.readDetail(properties);
        event.text = WidgetOperationHandler.readText(properties);
        event.button = WidgetOperationHandler.readButton(properties);
        event.setBounds(WidgetOperationHandler.readBounds(properties));
        return event;
    }

    protected static int readStateMask(JsonObject properties) {
        int stateMask = 0;
        if (JsonValue.TRUE.equals(properties.get("altKey"))) {
            stateMask |= 0x10000;
        }
        if (JsonValue.TRUE.equals(properties.get("ctrlKey"))) {
            stateMask |= 0x40000;
        }
        if (JsonValue.TRUE.equals(properties.get("shiftKey"))) {
            stateMask |= 0x20000;
        }
        return stateMask;
    }

    protected static int readDetail(JsonObject properties) {
        int detail = 0;
        JsonValue value = properties.get("detail");
        if (value != null && value.isString()) {
            String stringValue = value.asString();
            if ("check".equals(stringValue)) {
                detail = 32;
            } else if ("search".equals(stringValue)) {
                detail = 512;
            } else if ("cancel".equals(stringValue)) {
                detail = 256;
            } else if ("drag".equals(stringValue)) {
                detail = 1;
            } else if ("arrow".equals(stringValue)) {
                detail = 4;
            } else if ("cell".equals(stringValue)) {
                detail = 0x8000000;
            } else if ("hyperlink".equals(stringValue)) {
                detail = 0x4000000;
            }
        }
        return detail;
    }

    protected static Rectangle readBounds(JsonObject properties) {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        JsonValue x = properties.get("x");
        bounds.x = x == null ? 0 : x.asInt();
        JsonValue y = properties.get("y");
        bounds.y = y == null ? 0 : y.asInt();
        JsonValue width = properties.get("width");
        bounds.width = width == null ? 0 : width.asInt();
        JsonValue height = properties.get("height");
        bounds.height = height == null ? 0 : height.asInt();
        return bounds;
    }

    private static String readText(JsonObject properties) {
        JsonValue value = properties.get("text");
        return value == null ? null : value.asString();
    }

    private static int readButton(JsonObject properties) {
        JsonValue value = properties.get("button");
        return value == null ? 0 : value.asInt();
    }
}

