/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.core.lib.dosgi;

import java.util.Collection;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.Holder;
import org.modelbus.core.lib.IServicesHelper;
import org.modelbus.core.lib.configuration.ModelBusServiceConfiguration;
import org.modelbus.core.lib.dosgi.AbstractModelBusHelper;
import org.modelbus.core.lib.types.Status;
import org.modelbus.dosgi.repository.descriptor.InvalidServiceDescriptionException;
import org.modelbus.dosgi.repository.descriptor.MapEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.RepositoryRuntimeException;
import org.modelbus.dosgi.repository.descriptor.ServiceProperties;
import org.modelbus.dosgi.repository.descriptor.Session;

public class ServicesHelper
extends AbstractModelBusHelper
implements IServicesHelper {
    public Status getStatus(Session session, boolean includeServices) throws RepositoryAuthentificationException {
        Holder serviceStatusHolder = new Holder();
        Holder startupDateHolder = new Holder();
        Holder locationHolder = new Holder();
        Holder secureLocationHolder = new Holder();
        this.getService().getStatus(session, includeServices, serviceStatusHolder, startupDateHolder, locationHolder, secureLocationHolder);
        Status status = new Status();
        status.setLocation((String)locationHolder.value);
        status.setSecureLocation((String)secureLocationHolder.value);
        status.setStartupDate((XMLGregorianCalendar)startupDateHolder.value);
        if (serviceStatusHolder.value != null) {
            status.getServiceStatus().addAll((Collection)serviceStatusHolder.value);
        }
        return status;
    }

    public boolean publishService(Session session, ModelBusServiceConfiguration configuration) throws RepositoryAuthentificationException, InvalidServiceDescriptionException {
        ServiceProperties properties = ServicesHelper.mapServicesConfiguration(configuration);
        return this.getService().publishService(session, properties);
    }

    public boolean unpublishService(Session session, ModelBusServiceConfiguration configuration) throws RepositoryAuthentificationException, RepositoryRuntimeException, InvalidServiceDescriptionException {
        ServiceProperties properties = ServicesHelper.mapServicesConfiguration(configuration);
        return this.getService().unpublishService(session, properties);
    }

    private static ServiceProperties mapServicesConfiguration(ModelBusServiceConfiguration configuration) {
        ServiceProperties properties = new ServiceProperties();
        properties.setServiceInterface(configuration.getServiceInterface());
        properties.setServiceName(configuration.getServiceName());
        Map options = configuration.getOptions();
        for (String key : options.keySet()) {
            Object option = options.get(key);
            MapEntry entry = new MapEntry();
            entry.setKey(key);
            entry.setValue(option);
            properties.getEntries().add(entry);
        }
        return properties;
    }
}

