/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.jsse;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsseParameters
implements CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(JsseParameters.class);
    private CamelContext context;

    @Override
    public CamelContext getCamelContext() {
        return this.context;
    }

    @Override
    public void setCamelContext(CamelContext context) {
        this.context = context;
    }

    protected String parsePropertyValue(String value) throws RuntimeCamelException {
        if (this.getCamelContext() != null) {
            try {
                return this.getCamelContext().resolvePropertyPlaceholders(value);
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error parsing property value: " + value, e);
            }
        }
        return value;
    }

    protected List<String> parsePropertyValues(List<String> values) throws RuntimeCamelException {
        if (this.getCamelContext() == null) {
            return values;
        }
        ArrayList<String> parsedValues = new ArrayList<String>(values.size());
        for (String value : values) {
            parsedValues.add(this.parsePropertyValue(value));
        }
        return parsedValues;
    }

    protected InputStream resolveResource(String resource) throws IOException {
        InputStream is = null;
        try {
            LOG.trace("Trying to open resource as a file.");
            is = new FileInputStream(resource);
        }
        catch (FileNotFoundException e) {
            LOG.trace("Could not open resource as a file.", (Throwable)e);
        }
        if (is == null && Thread.currentThread().getContextClassLoader() != null) {
            LOG.trace("Trying to open resource as a class path resource with the TCCL {}.", (Object)Thread.currentThread().getContextClassLoader());
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            if (is == null) {
                LOG.trace("Could not open resource as a class path resource using the TCCL {}.", (Object)Thread.currentThread().getContextClassLoader());
            }
        }
        if (is == null) {
            LOG.trace("Trying to open resource as a class path resource using the classloader {}.", (Object)this.getClass().getClassLoader());
            is = this.getClass().getResourceAsStream(resource);
            if (is == null) {
                LOG.trace("Could not open resource as a class path resource using the classloader {}.", (Object)this.getClass().getClassLoader());
            }
        }
        if (is == null) {
            try {
                LOG.trace("Trying to open resource as a URL.");
                is = new URL(resource).openStream();
            }
            catch (IOException e) {
                LOG.trace("Could not open resource as a URL.", (Throwable)e);
            }
        }
        if (is == null && this.context != null) {
            LOG.trace("Trying to open resource using the CamelContext ClassResolver {}", (Object)this.context.getClassResolver());
            is = this.context.getClassResolver().loadResourceAsStream(resource);
            LOG.trace("Could not to open resource using the CamelContext ClassResolver {}.", (Object)this.context.getClassResolver());
        }
        if (is == null) {
            throw new IOException("Could not open " + resource + " as a file, class path resource, or URL.");
        }
        return is;
    }
}

