/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.modelbus.core.lib.util.ModelBusCoreUtil;
import org.modelbus.dosgi.repository.descriptor.ConstraintViolationException;
import org.modelbus.dosgi.repository.descriptor.IncomingReferencesInfo;
import org.modelbus.dosgi.repository.descriptor.InvalidRevisionException;
import org.modelbus.dosgi.repository.descriptor.InvalidValueException;
import org.modelbus.dosgi.repository.descriptor.LockedException;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.RepositoryRuntimeException;
import org.modelbus.dosgi.repository.descriptor.UnresolvedReferencesException;
import org.modelbus.model.dependencies.DependenciesFactory;
import org.modelbus.model.dependencies.DependenciesModel;
import org.modelbus.model.dependencies.DependenciesPackage;
import org.modelbus.model.dependencies.Dependency;
import org.modelbus.model.dependencies.IncomingReference;
import org.modelbus.model.dependencies.ReferencedType;
import org.modelbus.services.repository.server.IModelBusDirEntry;
import org.modelbus.services.repository.server.IModelBusRepository;
import org.modelbus.services.repository.server.IModelBusSession;
import org.modelbus.services.repository.server.ModelBusNodeKind;
import org.modelbus.services.repository.server.common.AbstractManager;
import org.modelbus.services.repository.server.common.AbstractModelBusRepository;
import org.modelbus.services.repository.server.common.AccessManager;

public class DependenciesManager
extends AbstractManager {
    private final boolean SAVE_REFERENCED_OBJECTS = false;
    private final DependenciesFactory dependenciesFactory = DependenciesFactory.eINSTANCE;
    private DependenciesModel dependenciesModel;
    private boolean referencedObjects = false;

    public DependenciesManager(IModelBusRepository modelBusRepositoryImpl) {
        super(modelBusRepositoryImpl);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("dependencies", new XMIResourceFactoryImpl());
    }

    private DependenciesModel createModel() {
        DependenciesModel dependenciesModel = this.dependenciesFactory.createDependenciesModel();
        return dependenciesModel;
    }

    public boolean isReferencedObjects() {
        return this.referencedObjects;
    }

    public void setReferencedObjects(boolean saveReferencedObjects) {
        this.referencedObjects = saveReferencedObjects;
    }

    private static URI createDependenciesURI(URI uri) {
        String uriString = uri.toString();
        if (uriString.endsWith("/")) {
            uriString = uriString.substring(0, uriString.length() - 1);
        }
        return URI.createURI((String)(String.valueOf(uriString) + "." + "dependencies"));
    }

    private DependenciesModel prepareDependenciesModel(URI modelURI) throws RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, NonExistingResourceException, LockedException {
        Resource dependenciesResource;
        ModelBusNodeKind nodeKindModel;
        modelURI = DependenciesManager.createDependenciesURI(modelURI);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(DependenciesPackage.eINSTANCE.getNsURI(), DependenciesPackage.eINSTANCE);
        URI dependenciesMMURI = URI.createURI((String)"http://www.modelbus.org/system/model/dependencies.ecore");
        ModelBusNodeKind nodeKindMetaModel = this.modelBusRepository.checkPathFileSystem(AccessManager.INTERNAL_MODEL_BUS_SESSION, dependenciesMMURI, "-1");
        if (nodeKindMetaModel == null) {
            Resource dependenciesModel = this.modelBusRepository.createModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, null, dependenciesMMURI, ECLASS_URI, "internal initial model creation", AbstractModelBusRepository.getDefaultOptionsMap());
            dependenciesModel.getContents().clear();
            dependenciesModel.getContents().add((Object)DependenciesPackage.eINSTANCE);
            this.modelBusRepository.checkInModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, dependenciesModel, "internal initial model creation", AbstractModelBusRepository.getDefaultOptionsMap());
        }
        if ((nodeKindModel = this.modelBusRepository.checkPathFileSystem(AccessManager.INTERNAL_MODEL_BUS_SESSION, modelURI, "-1")) == null) {
            dependenciesResource = this.modelBusRepository.createModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, null, modelURI, dependenciesMMURI.appendFragment("//DependenciesModel"), "internal initial model creation", AbstractModelBusRepository.getDefaultOptionsMap());
            dependenciesResource.getContents().clear();
            dependenciesResource.getContents().add((Object)this.createModel());
        } else {
            dependenciesResource = this.modelBusRepository.checkOutModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, modelURI);
        }
        DependenciesModel dependenciesModel = (DependenciesModel)dependenciesResource.getContents().get(0);
        return dependenciesModel;
    }

    private synchronized DependenciesModel getDependenciesModel(URI modelURI) throws RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, NonExistingResourceException, LockedException {
        if (this.dependenciesModel == null) {
            this.dependenciesModel = this.prepareDependenciesModel(modelURI);
        }
        return this.dependenciesModel;
    }

    private void fillReferencesMap(EObject referencedEObject, HashMap<String, HashMap<String, Integer>> references, List<String> dependenciesUris) {
        URI modelURI = EcoreUtil.getURI((EObject)referencedEObject).trimFragment();
        String modelUri = modelURI.toString();
        HashMap<Object, Object> referencedTypes = null;
        if (modelUri.isEmpty()) {
            return;
        }
        if (modelURI.isRelative()) {
            modelUri = "http:/" + modelUri;
        }
        String typeURI = EcoreUtil.getURI((EObject)referencedEObject.eClass()).toString();
        if (!references.containsKey(modelUri)) {
            referencedTypes = new HashMap<String, Integer>();
            referencedTypes.put(typeURI, 1);
        } else {
            referencedTypes = references.get(modelUri);
            if (referencedTypes.containsKey(typeURI)) {
                int occurence = (Integer)referencedTypes.get(typeURI);
                referencedTypes.put(typeURI, occurence + 1);
            } else {
                referencedTypes.put(typeURI, 1);
            }
        }
        references.put(modelUri, referencedTypes);
        if (!dependenciesUris.contains(modelUri)) {
            dependenciesUris.add(modelUri);
        }
    }

    private void addNewIncomingReference(EList<IncomingReference> incomingReferences, HashMap<String, Integer> typeMap, URI resourceURI) {
        IncomingReference newIncomingReference = DependenciesFactory.eINSTANCE.createIncomingReference();
        newIncomingReference.setModelUrl(resourceURI.toString());
        EList types = newIncomingReference.getReferencedTypes();
        for (Map.Entry<String, Integer> typesEntry : typeMap.entrySet()) {
            int occurence = typesEntry.getValue();
            ReferencedType newType = DependenciesFactory.eINSTANCE.createReferencedType();
            newType.setTypeURI(typesEntry.getKey());
            newType.setOccurrence(occurence);
            types.add((Object)newType);
        }
        incomingReferences.add((Object)newIncomingReference);
    }

    public void saveDependencies(Resource resource) throws RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, LockedException, UnresolvedReferencesException, NonExistingResourceException {
        URI resourceURI = resource.getURI();
        HashMap<String, HashMap<String, Integer>> references = new HashMap<String, HashMap<String, Integer>>();
        ArrayList<String> dependenciesUris = new ArrayList<String>();
        TreeIterator ti = resource.getAllContents();
        while (ti.hasNext()) {
            EObject eObject = (EObject)ti.next();
            EClass eClass = eObject.eClass();
            this.fillReferencesMap((EObject)eClass, references, dependenciesUris);
            EList list = eClass.getEAllReferences();
            for (EReference eReference : list) {
                URI currentObjectUri;
                if (eReference.isDerived()) continue;
                Object referenceValue = eObject.eGet((EStructuralFeature)eReference, false);
                if (referenceValue instanceof EList) {
                    EList eReferenceValues = (EList)referenceValue;
                    for (EObject eReferenceEObject : eReferenceValues) {
                        URI eReferenceEObjectUri;
                        if (eReferenceEObject.eIsProxy() || (eReferenceEObjectUri = EcoreUtil.getURI((EObject)eReferenceEObject)).trimFragment().equals(resourceURI)) continue;
                        this.fillReferencesMap(eReferenceEObject, references, dependenciesUris);
                    }
                    continue;
                }
                EObject currentObject = (EObject)referenceValue;
                if (currentObject == null) continue;
                if (currentObject.eIsProxy()) {
                    EcoreUtil.resolve((EObject)currentObject, (ResourceSet)resource.getResourceSet());
                }
                if ((currentObjectUri = EcoreUtil.getURI((EObject)currentObject)).trimFragment().equals(resourceURI)) continue;
                this.fillReferencesMap(currentObject, references, dependenciesUris);
            }
        }
        if (!references.isEmpty()) {
            this.saveIncomingReferences(references, resource);
            this.saveOutgoingReferences(dependenciesUris, resource);
        }
    }

    private void saveOutgoingReferences(List<String> dependenciesUris, Resource resource) throws InvalidValueException, ConstraintViolationException, RepositoryAuthentificationException, LockedException, UnresolvedReferencesException, NonExistingResourceException {
        URI resourceURI = resource.getURI();
        DependenciesModel dependenciesModel = this.getDependenciesModel(resourceURI);
        EList dependencies = dependenciesModel.getDependencies();
        ArrayList<Dependency> newDependencies = new ArrayList<Dependency>();
        for (String dependencyUriString : dependenciesUris) {
            URI dependencyURI = URI.createURI((String)dependencyUriString);
            if (ModelBusCoreUtil.URIUtil.isPathMapURI((URI)dependencyURI)) {
                dependencyUriString = dependencyUriString.replace("pathmap://", "http://");
            } else if (dependencyURI.isPlatformPlugin()) {
                dependencyUriString = dependencyUriString.replace("platform:/plugin/", "http://");
            } else if (dependencyURI.isPlatformResource()) {
                dependencyUriString = dependencyUriString.replace("platform:/resource/", "http://");
            } else if (!"http".equals(dependencyURI.scheme())) {
                String authority = resourceURI.authority();
                int index = -1;
                if (authority != null) {
                    index = dependencyUriString.indexOf(resourceURI.authority());
                }
                if (index == -1) {
                    index = dependencyUriString.indexOf(resourceURI.path());
                }
                dependencyUriString = index != -1 ? "http://" + dependencyUriString.substring(index) : resourceURI.trimSegments(1).appendSegment(URI.createURI((String)dependencyUriString).lastSegment()).toString();
            }
            boolean dependencyExists = false;
            for (Dependency dep : newDependencies) {
                if (!dep.getModelUrl().equals(dependencyUriString)) continue;
                dependencyExists = true;
                break;
            }
            if (dependencyExists) continue;
            Dependency newDependency = DependenciesFactory.eINSTANCE.createDependency();
            newDependency.setModelUrl(dependencyUriString);
            newDependencies.add(newDependency);
        }
        dependencies.clear();
        dependencies.addAll(newDependencies);
        try {
            this.modelBusRepository.checkInModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, dependenciesModel.eResource(), "internal update", AbstractModelBusRepository.getDefaultOptionsMap());
        }
        finally {
            this.dependenciesModel = null;
        }
    }

    private void saveIncomingReferences(HashMap<String, HashMap<String, Integer>> references, Resource resource) throws RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, NonExistingResourceException, LockedException {
        URI resourceURI = resource.getURI();
        Set<Map.Entry<String, HashMap<String, Integer>>> set = references.entrySet();
        for (Map.Entry<String, HashMap<String, Integer>> entry : set) {
            DependenciesModel dependenciesModel;
            block23: {
                String modelUriKey = entry.getKey();
                HashMap<String, Integer> typeMap = entry.getValue();
                if (ModelBusCoreUtil.URIUtil.isPathMapURI((URI)URI.createURI((String)modelUriKey))) {
                    modelUriKey = modelUriKey.replace("pathmap://", "http://");
                } else if (modelUriKey.startsWith("platform:/plugin/")) {
                    modelUriKey = modelUriKey.replace("platform:/plugin/", "http://");
                } else if (modelUriKey.startsWith("platform:/resource/")) {
                    modelUriKey = modelUriKey.replace("platform:/resource/", "http://");
                } else if (!"http".equals(URI.createURI((String)modelUriKey).scheme())) {
                    String authority = resourceURI.authority();
                    int index = -1;
                    if (authority != null) {
                        index = modelUriKey.indexOf(resourceURI.authority());
                    }
                    if (index == -1) {
                        index = modelUriKey.indexOf(resourceURI.path());
                    }
                    modelUriKey = index != -1 ? "http://" + modelUriKey.substring(index) : resourceURI.trimSegments(1).appendSegment(URI.createURI((String)modelUriKey).lastSegment()).toString();
                }
                URI modelURI = URI.createURI((String)modelUriKey);
                dependenciesModel = this.getDependenciesModel(modelURI.trimFragment());
                EList incomingReferences = dependenciesModel.getIncomingReferences();
                int incomingReferencesSize = incomingReferences.size();
                if (!incomingReferences.isEmpty()) {
                    int j = 0;
                    while (j < incomingReferencesSize) {
                        IncomingReference incomingReference = (IncomingReference)incomingReferences.get(j);
                        if (incomingReference.getModelUrl().equals(resourceURI.toString())) {
                            EList types = incomingReference.getReferencedTypes();
                            int typesSize = types.size();
                            int i = 0;
                            while (i < typesSize) {
                                ReferencedType type = (ReferencedType)types.get(i);
                                if (typeMap.containsKey(type.getTypeURI())) {
                                    for (Map.Entry<String, Integer> typesEntry : typeMap.entrySet()) {
                                        String uri = typesEntry.getKey();
                                        if (!uri.equals(type.getTypeURI())) continue;
                                        type.setOccurrence(typesEntry.getValue().intValue());
                                        break block23;
                                    }
                                    break block23;
                                }
                                if (i == typesSize - 1) {
                                    for (Map.Entry<String, Integer> typesEntry : typeMap.entrySet()) {
                                        ReferencedType newType = DependenciesFactory.eINSTANCE.createReferencedType();
                                        newType.setTypeURI(typesEntry.getKey());
                                        newType.setOccurrence(typesEntry.getValue().intValue());
                                        types.add((Object)newType);
                                    }
                                }
                                ++i;
                            }
                            break;
                        }
                        if (j == incomingReferencesSize - 1) {
                            this.addNewIncomingReference((EList<IncomingReference>)incomingReferences, typeMap, resourceURI);
                        }
                        ++j;
                    }
                } else {
                    this.addNewIncomingReference((EList<IncomingReference>)incomingReferences, typeMap, resourceURI);
                }
            }
            try {
                this.modelBusRepository.checkInModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, dependenciesModel.eResource(), "internal update", AbstractModelBusRepository.getDefaultOptionsMap());
            }
            finally {
                this.dependenciesModel = null;
            }
        }
    }

    private ArrayList<URI> getPossibleModelsFor(EObject eObject) throws RepositoryAuthentificationException, NonExistingResourceException, UnresolvedReferencesException {
        ResourceSet resourceSet = DependenciesManager.createResourceSet();
        if (eObject == null) {
            return new ArrayList<URI>();
        }
        URI dependenciesLocation = DependenciesManager.createDependenciesURI(EcoreUtil.getURI((EObject)eObject).trimFragment());
        Resource resource = resourceSet.createResource(dependenciesLocation);
        if (!this.modelBusRepository.exists(AccessManager.INTERNAL_MODEL_BUS_SESSION, dependenciesLocation, "-1")) {
            return new ArrayList<URI>();
        }
        resource = this.modelBusRepository.checkOutModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, dependenciesLocation, "-1", new HashMap<String, Object>());
        DependenciesModel dependenciesModel = (DependenciesModel)resource.getContents().get(0);
        EList incomingReferences = dependenciesModel.getIncomingReferences();
        ArrayList<URI> modelUrls = new ArrayList<URI>();
        for (IncomingReference incomingReference : incomingReferences) {
            URI modelURI = URI.createURI((String)incomingReference.getModelUrl());
            for (ReferencedType type : incomingReference.getReferencedTypes()) {
                URI eObjectTypeURI = EcoreUtil.getURI((EObject)eObject.eClass());
                URI typeURI = URI.createURI((String)type.getTypeURI());
                if (!eObjectTypeURI.lastSegment().concat(eObjectTypeURI.fragment()).equals(typeURI.lastSegment().concat(typeURI.fragment()))) continue;
                modelUrls.add(modelURI);
            }
        }
        return modelUrls;
    }

    private void fillIncomingReferencesInfoList(URI referencedObjectUri, EObject referencingObject, String currentObjectUriLastSegmentWithFragment, List<IncomingReferencesInfo> incomingReferencesInfos) {
        if (referencedObjectUri.trimFragment().toString().isEmpty()) {
            return;
        }
        String referencedObjectUriLastSegmentWithFragment = referencedObjectUri.lastSegment();
        if (referencedObjectUriLastSegmentWithFragment.equals(currentObjectUriLastSegmentWithFragment)) {
            IncomingReferencesInfo incomingReferencesInfo = new IncomingReferencesInfo();
            String referencingObjectUri = EcoreUtil.getURI((EObject)referencingObject).toString();
            EClass referencingObjectClass = referencingObject.eClass();
            EList attributes = referencingObjectClass.getEAllAttributes();
            String name = "";
            for (EAttribute attribute : attributes) {
                Object attributName;
                if (!"name".equals(attribute.getName()) || (attributName = referencingObject.eGet((EStructuralFeature)attribute)) == null) continue;
                name = attributName.toString();
            }
            incomingReferencesInfo.setReferencingObjectUri(referencingObjectUri);
            incomingReferencesInfo.setObjectTypeUri(EcoreUtil.getURI((EObject)referencingObjectClass).toString());
            incomingReferencesInfo.setObjectName(name);
            incomingReferencesInfos.add(incomingReferencesInfo);
        }
    }

    private static ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)DependenciesPackage.eINSTANCE.getNsURI(), (Object)DependenciesPackage.eINSTANCE);
        return resourceSet;
    }

    public IncomingReferencesInfo[] getIncomingReferencesFor(URI uri) throws RepositoryAuthentificationException, NonExistingResourceException, UnresolvedReferencesException {
        URI uriWithoutFragment;
        if (uri.fragment() == null) {
            List<IncomingReferencesInfo> incomingRefs = this.getModelIncomingReferencesFor(uri);
            if (this.modelBusRepository.areSymbolicLinksEnabled()) {
                List<IModelBusDirEntry> entries;
                try {
                    entries = this.modelBusRepository.info(AccessManager.INTERNAL_MODEL_BUS_SESSION, uri, "-1");
                }
                catch (InvalidRevisionException exc) {
                    throw new RepositoryRuntimeException(exc.getMessage(), (Throwable)exc);
                }
                if (entries != null) {
                    for (IModelBusDirEntry entry : entries) {
                        String symLinkPath = entry.getProperty("MB_SymLink");
                        if (symLinkPath == null) continue;
                        List<IncomingReferencesInfo> otherIncomingRefs = this.getModelIncomingReferencesFor(URI.createURI((String)symLinkPath));
                        for (IncomingReferencesInfo otherRef : otherIncomingRefs) {
                            boolean refIncluded = false;
                            for (IncomingReferencesInfo incomingReferencesInfo : incomingRefs) {
                                if (!incomingReferencesInfo.equals((Object)otherRef)) continue;
                                refIncluded = true;
                                break;
                            }
                            if (refIncluded) continue;
                            incomingRefs.add(otherRef);
                        }
                    }
                }
            }
            return incomingRefs.toArray(new IncomingReferencesInfo[incomingRefs.size()]);
        }
        ResourceSet resourceSet = DependenciesManager.createResourceSet();
        ArrayList<Object> possibleModels = new ArrayList();
        ArrayList<IncomingReferencesInfo> depInfos = new ArrayList<IncomingReferencesInfo>();
        URI resourceLocation = uriWithoutFragment = uri.trimFragment();
        String fragment = uri.fragment();
        Resource fragmentResource = resourceSet.createResource(resourceLocation);
        fragmentResource = this.modelBusRepository.checkOutModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, resourceLocation, "-1", new HashMap<String, Object>());
        EObject currentObject = fragmentResource.getEObject(fragment);
        possibleModels = this.getPossibleModelsFor(currentObject);
        String currentObjectUriLastSegmentWithFragment = URI.createURI((String)uriWithoutFragment.lastSegment()).appendFragment(fragment).toString();
        if (!possibleModels.isEmpty()) {
            for (URI uRI : possibleModels) {
                Resource modelResource = resourceSet.createResource(uRI);
                modelResource = this.modelBusRepository.checkOutModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, uRI, "-1", new HashMap<String, Object>());
                TreeIterator iterator = modelResource.getAllContents();
                while (iterator.hasNext()) {
                    EObject referencingObject = (EObject)iterator.next();
                    EClass referencingObjectClass = referencingObject.eClass();
                    EList allReferences = referencingObjectClass.getEAllReferences();
                    for (EReference eReference : allReferences) {
                        URI objectUri;
                        if (eReference.isDerived()) continue;
                        Object referenceValue = referencingObject.eGet((EStructuralFeature)eReference, false);
                        if (referenceValue instanceof EList) {
                            EList eReferenceValues = (EList)referenceValue;
                            for (EObject eReferenceValue : eReferenceValues) {
                                URI objectUri2 = EcoreUtil.getURI((EObject)eReferenceValue);
                                if (objectUri2.trimFragment().equals(modelResource.getURI())) continue;
                                this.fillIncomingReferencesInfoList(objectUri2, referencingObject, currentObjectUriLastSegmentWithFragment, depInfos);
                            }
                            continue;
                        }
                        EObject currObject = (EObject)referenceValue;
                        if (currObject == null || (objectUri = EcoreUtil.getURI((EObject)currObject)).trimFragment().equals(modelResource.getURI())) continue;
                        this.fillIncomingReferencesInfoList(objectUri, referencingObject, currentObjectUriLastSegmentWithFragment, depInfos);
                    }
                }
            }
            return depInfos.toArray(new IncomingReferencesInfo[depInfos.size()]);
        }
        return new IncomingReferencesInfo[0];
    }

    private List<IncomingReferencesInfo> getModelIncomingReferencesFor(URI uri) {
        ArrayList<IncomingReferencesInfo> incomingReferencesInfos;
        block6: {
            ResourceSet resourceSet = DependenciesManager.createResourceSet();
            incomingReferencesInfos = new ArrayList<IncomingReferencesInfo>();
            URI dependenciesLocation = DependenciesManager.createDependenciesURI(uri);
            try {
                if (!this.modelBusRepository.exists(AccessManager.INTERNAL_MODEL_BUS_SESSION, dependenciesLocation, "-1")) break block6;
                Resource resource = resourceSet.createResource(dependenciesLocation);
                resource = this.modelBusRepository.checkOutModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, dependenciesLocation, "-1", new HashMap<String, Object>());
                DependenciesModel dependenciesModel = (DependenciesModel)resource.getContents().get(0);
                EList incomingReferences = dependenciesModel.getIncomingReferences();
                int i = 0;
                while (i < incomingReferences.size()) {
                    IncomingReferencesInfo incomingReferencesInfo = new IncomingReferencesInfo();
                    URI modelURI = URI.createURI((String)((IncomingReference)incomingReferences.get(i)).getModelUrl());
                    if (this.modelBusRepository.exists(AccessManager.INTERNAL_MODEL_BUS_SESSION, modelURI, "-1")) {
                        Resource modelResource = resourceSet.createResource(modelURI);
                        try {
                            modelResource = this.modelBusRepository.checkOutModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, modelURI, "-1", new HashMap<String, Object>());
                            EObject root = (EObject)modelResource.getContents().get(0);
                            String typeUri = EcoreUtil.getURI((EObject)root.eClass()).toString();
                            incomingReferencesInfo.setObjectTypeUri(typeUri);
                            incomingReferencesInfo.setObjectName("");
                        }
                        catch (Exception exception) {}
                    }
                    incomingReferencesInfo.setReferencingObjectUri(modelURI.toString());
                    incomingReferencesInfos.add(incomingReferencesInfo);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        return incomingReferencesInfos;
    }

    public List<String> getDependenciesFor(URI modelUri) throws RepositoryAuthentificationException, NonExistingResourceException, UnresolvedReferencesException {
        ResourceSet resourceSet = DependenciesManager.createResourceSet();
        ArrayList<String> dependenciesUrls = new ArrayList<String>();
        URI dependenciesLocation = DependenciesManager.createDependenciesURI(modelUri = modelUri.trimFragment());
        if (this.modelBusRepository.exists(AccessManager.INTERNAL_MODEL_BUS_SESSION, dependenciesLocation, "-1")) {
            Resource resource = resourceSet.createResource(dependenciesLocation);
            resource = this.modelBusRepository.checkOutModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, dependenciesLocation, "-1", new HashMap<String, Object>());
            DependenciesModel dependenciesModel = (DependenciesModel)resource.getContents().get(0);
            EList dependencies = dependenciesModel.getDependencies();
            for (Dependency dependency : dependencies) {
                String modelUrl = dependency.getModelUrl();
                dependenciesUrls.add(modelUrl);
            }
        }
        return dependenciesUrls;
    }

    public void deleteDependenciesInfos(URI modelURI) throws RepositoryAuthentificationException, NonExistingResourceException, UnresolvedReferencesException, LockedException, InvalidValueException, ConstraintViolationException {
        IncomingReferencesInfo[] incomingReferencesInfos = this.getIncomingReferencesFor(modelURI);
        ArrayList<URI> dependencyModelsToCheck = new ArrayList<URI>();
        IncomingReferencesInfo[] incomingReferencesInfoArray = incomingReferencesInfos;
        int n = incomingReferencesInfos.length;
        int n2 = 0;
        while (n2 < n) {
            IncomingReferencesInfo incomingReferencesInfo = incomingReferencesInfoArray[n2];
            dependencyModelsToCheck.add(URI.createURI((String)incomingReferencesInfo.getReferencingObjectUri()));
            ++n2;
        }
        this.deleteDependencyEntries(dependencyModelsToCheck, modelURI);
        URI modelDependenciesFileLocation = DependenciesManager.createDependenciesURI(modelURI);
        if (this.modelBusRepository.exists(AccessManager.INTERNAL_MODEL_BUS_SESSION, modelDependenciesFileLocation, "-1")) {
            this.modelBusRepository.delete(AccessManager.INTERNAL_MODEL_BUS_SESSION, modelDependenciesFileLocation, "[no comment]", "-1");
        }
    }

    private void deleteDependencyEntries(List<URI> dependencyModelsToCheck, URI model) throws RepositoryAuthentificationException, NonExistingResourceException, InvalidValueException, ConstraintViolationException, LockedException, UnresolvedReferencesException {
        for (URI modelURI : dependencyModelsToCheck) {
            if (!this.modelBusRepository.exists(AccessManager.INTERNAL_MODEL_BUS_SESSION, DependenciesManager.createDependenciesURI(modelURI), "-1")) continue;
            DependenciesModel dependenciesModel = this.getDependenciesModel(modelURI);
            EList incomingReferences = dependenciesModel.getIncomingReferences();
            for (IncomingReference incomingReference : incomingReferences) {
                URI incomingModelUri = URI.createURI((String)incomingReference.getModelUrl());
                if (!incomingModelUri.equals(model)) continue;
                incomingReferences.remove((Object)incomingReference);
                break;
            }
            EList dependencies = dependenciesModel.getDependencies();
            for (Dependency dependency : dependencies) {
                String modelUrl = dependency.getModelUrl();
                if (!modelUrl.equals(model.toString())) continue;
                dependencies.remove((Object)dependency);
                break;
            }
            this.modelBusRepository.checkInModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, dependenciesModel.eResource(), "internal update", AbstractModelBusRepository.getDefaultOptionsMap());
        }
    }

    @Override
    public void createModel(URI modelUri, IModelBusSession session) {
    }

    @Override
    public void deleteModel(URI modelUri, IModelBusSession session) {
        String fileExtension = modelUri.fileExtension();
        if (fileExtension != null && fileExtension.equals("dependencies")) {
            this.dependenciesModel = null;
        }
    }

    @Override
    public void updateModel(URI modelUri, IModelBusSession session) {
        String fileExtension = modelUri.fileExtension();
        if (fileExtension != null && fileExtension.equals("dependencies")) {
            this.dependenciesModel = null;
        }
    }

    @Override
    public void commitChangeModelNotification(String messageID, URI modelUri, DataHandler changeModelContent) {
    }
}

