/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.user;

import java.util.Set;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.modelbus.desktop.Activator;
import org.modelbus.model.user.NamedElement;
import org.modelbus.model.user.User;
import org.modelbus.model.user.UserGroup;

public class UserTreeViewLabelProvider
extends CellLabelProvider {
    private final IMapChangeListener mapChangeListener = new IMapChangeListener(){

        public void handleMapChange(MapChangeEvent event) {
            Set affectedElements = event.diff.getChangedKeys();
            if (!affectedElements.isEmpty()) {
                LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)UserTreeViewLabelProvider.this, affectedElements.toArray());
                UserTreeViewLabelProvider.this.fireLabelProviderChanged(newEvent);
            }
        }
    };

    public UserTreeViewLabelProvider(IObservableMap ... attributeMaps) {
        IObservableMap[] iObservableMapArray = attributeMaps;
        int n = attributeMaps.length;
        int n2 = 0;
        while (n2 < n) {
            IObservableMap attributeMap = iObservableMapArray[n2];
            attributeMap.addMapChangeListener(this.mapChangeListener);
            ++n2;
        }
    }

    public String getToolTipText(Object element) {
        return "TODO: tooltip";
    }

    public void update(ViewerCell cell) {
        String imageName = null;
        Object cellElement = cell.getElement();
        if (cellElement instanceof NamedElement) {
            NamedElement resource = (NamedElement)cell.getElement();
            cell.setText(resource.getName());
            if (cellElement instanceof User) {
                imageName = "user.png";
            } else if (cellElement instanceof UserGroup) {
                imageName = "usergroup.png";
            }
        }
        if (imageName != null) {
            cell.setImage(Activator.getImageDescriptor("icons/" + imageName).createImage());
        }
    }
}

