/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server.git;

import java.io.IOException;
import java.util.Date;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.modelbus.dosgi.repository.descriptor.RepositoryRuntimeException;

public class GitUtil {
    public static ObjectLoader getObjectLoader(Repository repository, String filePath, RevCommit commit) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        TreeWalk treeWalk = GitUtil.createTreeWalk(repository, filePath, commit);
        if (treeWalk == null) {
            return null;
        }
        return repository.open((AnyObjectId)treeWalk.getObjectId(0));
    }

    public static TreeWalk createTreeWalk(Repository repository, String filePath, RevCommit commit) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        TreeWalk treeWalk;
        String filePathTrimmed = GitUtil.getTrimmedPath(filePath);
        if (!GitUtil.isEmptyPath(filePathTrimmed)) {
            treeWalk = TreeWalk.forPath((Repository)repository, (String)filePathTrimmed, (RevTree)commit.getTree());
        } else {
            treeWalk = new TreeWalk(repository);
            treeWalk.addTree((AnyObjectId)commit.getTree());
        }
        return treeWalk;
    }

    public static ObjectLoader getObjectLoader(Repository repository, String filePath, String revision) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        RevCommit commit = GitUtil.getCommitForFile(repository, filePath, revision);
        if (commit == null) {
            return null;
        }
        return GitUtil.getObjectLoader(repository, filePath, commit);
    }

    private static String getTrimmedPath(String path) {
        String filePathTrimmed = new String(path);
        if (filePathTrimmed.startsWith("/") && path.length() > 1) {
            filePathTrimmed = filePathTrimmed.substring(1);
        }
        return filePathTrimmed;
    }

    public static String toFileSystemPath(URI fileURI) {
        String filePath = fileURI.isFile() ? fileURI.toFileString() : fileURI.toString();
        return filePath.replace("\\", "/");
    }

    public static RevCommit getCommitForFile(Repository repository, String filePath, String revision) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        String filePathTrimmed = GitUtil.getTrimmedPath(filePath);
        RevWalk revWalk = GitUtil.getRevWalkForPath(repository, filePathTrimmed, revision);
        if (revWalk == null) {
            return null;
        }
        RevCommit commit = revWalk.next();
        revWalk.dispose();
        return commit;
    }

    public static RevWalk getRevWalkForPath(Repository repository, String filePath, String revision) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectId commitReference = GitUtil.getCommitReference(repository, revision);
        if (commitReference == null) {
            return null;
        }
        RevWalk revWalk = new RevWalk(repository);
        try {
            revWalk.markStart(revWalk.parseCommit((AnyObjectId)commitReference));
        }
        catch (Exception e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        if (!GitUtil.isEmptyPath(filePath)) {
            revWalk.setTreeFilter((TreeFilter)PathFilter.create((String)filePath));
        }
        return revWalk;
    }

    private static boolean isEmptyPath(String path) {
        return path.isEmpty() || "/".equals(path);
    }

    public static ObjectId getCommitReference(Repository repository, String revisionString) throws RepositoryRuntimeException {
        ObjectId commitReference;
        block14: {
            if ("0".equals(revisionString)) {
                RevCommit rootCommit;
                try {
                    rootCommit = GitUtil.getInitialCommit(repository);
                }
                catch (Exception e) {
                    throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
                }
                return rootCommit.getId();
            }
            if ("-1".equals(revisionString)) {
                try {
                    commitReference = repository.resolve("HEAD");
                }
                catch (Exception e) {
                    throw new RepositoryRuntimeException("Error parsing revision", (Throwable)e);
                }
            }
            try {
                commitReference = repository.resolve(revisionString);
            }
            catch (Exception e) {
                throw new RepositoryRuntimeException("Error parsing revision", (Throwable)e);
            }
            if (commitReference == null) {
                try {
                    long revisionLong = Long.parseLong(revisionString);
                    if (revisionLong >= 0L) break block14;
                    try {
                        commitReference = repository.resolve("HEAD");
                    }
                    catch (Exception e) {
                        throw new RepositoryRuntimeException("Error parsing revision", (Throwable)e);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        if (commitReference == null) {
            System.err.println("Warning no commit found: " + revisionString);
        }
        return commitReference;
    }

    public static RevCommit getInitialCommit(Repository repository) throws RevisionSyntaxException, AmbiguousObjectException, IncorrectObjectTypeException, IOException {
        RevWalk revWalk = new RevWalk(repository);
        ObjectId headID = repository.resolve("HEAD");
        RevCommit root = revWalk.parseCommit((AnyObjectId)headID);
        revWalk.sort(RevSort.REVERSE);
        revWalk.markStart(root);
        RevCommit c = revWalk.next();
        return c;
    }

    public static String getCommitAuthor(RevCommit commit) {
        return commit.getCommitterIdent().getName();
    }

    public static Date getCommitDate(RevCommit commit) {
        return new Date((long)commit.getCommitTime() * 1000L);
    }

    public static String getCommitRevision(RevCommit commit) {
        return commit.getId().getName();
    }

    public static String getCommitMessage(RevCommit commit) {
        return commit.getFullMessage();
    }
}

