/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.merge;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.modelbus.tools.diffmerge.merge.AbstractDiffModelElementMerger;
import org.modelbus.tools.diffmerge.merge.MergeException;
import org.modelbus.tools.diffmerge.model.AbstractDiffElement;
import org.modelbus.tools.diffmerge.model.DiffElement;
import org.modelbus.tools.diffmerge.model.DiffModel;
import org.modelbus.tools.diffmerge.model.DiffModelBuilder;
import org.modelbus.tools.diffmerge.model.DiffModelElement;
import org.modelbus.tools.diffmerge.model.collections.DiffCollection;

class BasicMerger
extends AbstractDiffModelElementMerger {
    private DiffModel model;

    BasicMerger() {
    }

    @Override
    public DiffModel mergeFromLeftToRight(DiffModelElement modelElement) {
        this.mergeModelElementAndAllChildren(modelElement, true);
        return this.getModel();
    }

    void mergeModelElementAndAllChildren(DiffModelElement modelElement, boolean leftToRight) {
        this.removeElementFromModel(modelElement);
        this.mergeDiffModelElement(modelElement, leftToRight);
        this.fixModelElementIfItIsTheModel(modelElement);
    }

    void removeElementFromModel(DiffModelElement child) {
        Optional optional = child.getParentElement();
        if (optional.isPresent()) {
            DiffModelElement parent = (DiffModelElement)optional.get();
            this.removeChildFromParent(child, parent);
        }
    }

    private void removeChildFromParent(DiffModelElement modelElement, DiffModelElement parent) {
        parent.removeSubElement(modelElement);
        if (parent.getAllDiffElements().isEmpty()) {
            this.removeParentFromModelTree(parent);
        }
    }

    private void removeParentFromModelTree(DiffModelElement parent) {
        while (parent.getParentElement().isPresent()) {
            DiffModelElement childElement = parent;
            if ((parent = (DiffModelElement)parent.getParentElement().get()).getSubElements().size() <= 1) {
                parent.removeSubElement(childElement);
                continue;
            }
            parent.removeSubElement(childElement);
            return;
        }
    }

    void mergeDiffModelElement(DiffModelElement modelElement, boolean leftToRight) {
        if (modelElement instanceof AbstractDiffElement) {
            this.mergeDiffElement((DiffElement)modelElement, leftToRight);
        } else {
            List<DiffElement> processedElements = this.getProcessor().preprocessDiffElements((DiffCollection<DiffElement>)modelElement.getAllDiffElements());
            for (DiffElement diff : processedElements) {
                this.mergeDiffElement(diff, leftToRight);
            }
        }
    }

    void mergeDiffElement(DiffElement diffElement, boolean leftToRight) {
        this.checkDiffElement(diffElement);
        AbstractDiffElement element = (AbstractDiffElement)diffElement;
        AbstractMerger merger = element.getMerger();
        Diff diff = element.getDiff();
        Monitor monitor = element.getMonitor();
        if (leftToRight) {
            merger.copyLeftToRight(diff, monitor);
        } else {
            merger.copyRightToLeft(diff, monitor);
        }
    }

    void checkDiffElement(DiffElement element) {
        if (!(element instanceof AbstractDiffElement)) {
            String type = element.getClass().getName();
            throw new MergeException("Error while merging DiffElement! Can not merge element of type " + type);
        }
    }

    void fixModelElementIfItIsTheModel(DiffModelElement modelElement) {
        if (modelElement instanceof DiffModel && modelElement.getConflictingElements().isEmpty()) {
            DiffModel model = DiffModelBuilder.createNewBuilder().createEmptyDiffModel(((DiffModel)modelElement).isThreeWay(), this.model.getLeftSide(), this.model.getRightSide());
            this.setModel(model);
        }
    }

    @Override
    public DiffModel mergeFromRightToLeft(DiffModelElement modelElement) {
        this.mergeModelElementAndAllChildren(modelElement, false);
        return this.getModel();
    }

    @Override
    public void mergeModelFromLeftToRight(DiffModel model) {
        this.mergeModelElementAndAllChildren((DiffModelElement)model, true);
    }

    @Override
    public void mergeModelFromRightToLeft(DiffModel model) {
        this.mergeModelElementAndAllChildren((DiffModelElement)model, false);
    }

    void setModel(DiffModel model) {
        this.model = model;
    }

    DiffModel getModel() {
        return (DiffModel)Preconditions.checkNotNull((Object)this.model, (Object)"No model set!!!");
    }
}

