/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.user;

import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.model.user.UserModel;

public class UserModelProvider {
    private static Resource userModelResource;
    private static UserModel userModel;

    public static synchronized UserModel getUserModel() {
        if (UserSessionHelper.getInstance().getSession() == null) {
            return null;
        }
        if (userModel == null) {
            ResourceSetImpl rs = new ResourceSetImpl();
            userModelResource = rs.createResource(URI.createURI((String)"http://www.modelbus.org/system/model/ModelBus.user"));
            try {
                ModelBusCoreLib.getRepositoryHelper().checkOutModel(UserSessionHelper.getInstance().getSession(), userModelResource, Collections.EMPTY_MAP);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            EList contents = userModelResource.getContents();
            if (contents.isEmpty()) {
                return null;
            }
            Object root = contents.get(0);
            if (!(root instanceof UserModel)) {
                throw new RuntimeException("Invalid user model structure");
            }
            userModel = (UserModel)root;
        }
        return userModel;
    }

    public static synchronized void commitUserModelChanges() {
        if (userModelResource == null) {
            return;
        }
        try {
            ModelBusCoreLib.getRepositoryHelper().checkInModel(UserSessionHelper.getInstance().getSession(), userModelResource, Collections.EMPTY_MAP, "[ModelBus Manager] User model update");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

