/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.bus;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import net.engio.mbassy.PublicationError;
import net.engio.mbassy.bus.AbstractMessageBus;
import net.engio.mbassy.bus.BusConfiguration;
import net.engio.mbassy.bus.MessagePublication;
import net.engio.mbassy.bus.SyncAsyncPostCommand;
import net.engio.mbassy.common.DeadMessage;
import net.engio.mbassy.subscription.Subscription;

public class MBassador<T>
extends AbstractMessageBus<T, SyncAsyncPostCommand<T>> {
    public MBassador(BusConfiguration configuration) {
        super(configuration);
    }

    public MessagePublication publishAsync(T message) {
        return this.addAsynchronousDeliveryRequest(this.createMessagePublication(message));
    }

    public MessagePublication publishAsync(T message, long timeout, TimeUnit unit) {
        return this.addAsynchronousDeliveryRequest(this.createMessagePublication(message), timeout, unit);
    }

    private MessagePublication createMessagePublication(T message) {
        Collection<Subscription> subscriptions = this.getSubscriptionsByMessageType(message.getClass());
        if ((subscriptions == null || subscriptions.isEmpty()) && !message.getClass().equals(DeadMessage.class)) {
            subscriptions = this.getSubscriptionsByMessageType(DeadMessage.class);
            return this.getPublicationFactory().createPublication(this, subscriptions, new DeadMessage(message));
        }
        return this.getPublicationFactory().createPublication(this, subscriptions, message);
    }

    public void publish(T message) {
        try {
            MessagePublication publication = this.createMessagePublication(message);
            publication.execute();
        }
        catch (Throwable e) {
            this.handlePublicationError(new PublicationError().setMessage("Error during publication of message").setCause(e).setPublishedObject(message));
        }
    }

    @Override
    public SyncAsyncPostCommand<T> post(T message) {
        return new SyncAsyncPostCommand<T>(this, message);
    }

    public void stop() {
        this.stopAllDispatcher();
    }
}

