/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.modelbusexplorer.blackboard.listener;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.Enveloped;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.Handler;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.IMessageFilter;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.Mode;

public class MessageHandlerMetadata {
    private Method handler;
    private IMessageFilter[] filter;
    private Handler handlerConfig;
    private Enveloped envelope = null;
    private List<Class<?>> handledMessages = new LinkedList();

    public MessageHandlerMetadata(Method handler, IMessageFilter[] filter, Handler handlerConfig) {
        this.handler = handler;
        this.filter = filter;
        this.handlerConfig = handlerConfig;
        this.envelope = handler.getAnnotation(Enveloped.class);
        if (this.envelope != null) {
            Class<?>[] classArray = this.envelope.messages();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> messageType = classArray[n2];
                this.handledMessages.add(messageType);
                ++n2;
            }
        } else {
            this.handledMessages.add(handler.getParameterTypes()[0]);
        }
        this.handler.setAccessible(true);
    }

    public boolean isAsynchronous() {
        return this.handlerConfig.delivery().equals((Object)Mode.Concurrent);
    }

    public boolean isFiltered() {
        return this.filter != null && this.filter.length > 0;
    }

    public int getPriority() {
        return this.handlerConfig.priority();
    }

    public Method getHandler() {
        return this.handler;
    }

    public IMessageFilter[] getFilter() {
        return this.filter;
    }

    public List<Class<?>> getHandledMessages() {
        return this.handledMessages;
    }

    public boolean isEnveloped() {
        return this.envelope != null;
    }

    public boolean handlesMessage(Class<?> messageType) {
        for (Class<?> handledMessage : this.handledMessages) {
            if (handledMessage.equals(messageType)) {
                return true;
            }
            if (!handledMessage.isAssignableFrom(messageType) || !this.acceptsSubtypes()) continue;
            return true;
        }
        return false;
    }

    public boolean acceptsSubtypes() {
        return !this.handlerConfig.rejectSubtypes();
    }

    public boolean isEnabled() {
        return this.handlerConfig.enabled();
    }
}

