/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.discovery;

import java.util.List;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.discovery.IDiscoveryContainerAdapter;
import org.eclipse.ecf.provider.discovery.SingletonDiscoveryContainer;

public class SingletonDiscoveryContainerInstantiator
implements IContainerInstantiator {
    private static IContainer INSTANCE;

    private static synchronized IContainer getInstance(String containerName) throws ContainerCreateException {
        if (INSTANCE == null) {
            IContainerFactory factory = ContainerFactory.getDefault();
            List list = factory.getDescriptions();
            for (ContainerTypeDescription ctd : list) {
                String name = ctd.getName();
                if (!name.equals(containerName)) continue;
                IContainer createContainer = factory.createContainer(ctd.getName());
                INSTANCE = new SingletonDiscoveryContainer(createContainer);
                return INSTANCE;
            }
            if (INSTANCE == null) {
                throw new ContainerCreateException("Unknown Container Name");
            }
        }
        return INSTANCE;
    }

    public IContainer createInstance(ContainerTypeDescription description, Object[] parameters) throws ContainerCreateException {
        if (parameters != null && parameters.length == 1 && parameters[0] instanceof String) {
            String containerName = (String)parameters[0];
            return SingletonDiscoveryContainerInstantiator.getInstance(containerName);
        }
        throw new ContainerCreateException("Missing parameter");
    }

    public String[] getSupportedAdapterTypes(ContainerTypeDescription description) {
        return new String[]{IDiscoveryContainerAdapter.class.getName()};
    }

    public Class[][] getSupportedParameterTypes(ContainerTypeDescription description) {
        return new Class[][]{{String.class}};
    }

    public String[] getSupportedIntents(ContainerTypeDescription description) {
        return null;
    }
}

