/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server.svn;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.eclipse.emf.common.util.URI;
import org.modelbus.dosgi.repository.descriptor.ConstraintViolationException;
import org.modelbus.dosgi.repository.descriptor.InvalidRevisionException;
import org.modelbus.dosgi.repository.descriptor.InvalidValueException;
import org.modelbus.dosgi.repository.descriptor.LockedException;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.OptionMapEntry;
import org.modelbus.dosgi.repository.descriptor.OptionsMap;
import org.modelbus.dosgi.repository.descriptor.PathFileContentMapEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.RepositoryRuntimeException;
import org.modelbus.dosgi.repository.descriptor.UnresolvedReferencesException;
import org.modelbus.services.repository.server.IModelBusDirEntry;
import org.modelbus.services.repository.server.IModelBusExtendedRepositoryLogEntry;
import org.modelbus.services.repository.server.IModelBusRepository;
import org.modelbus.services.repository.server.IModelBusRepositoryLogEntry;
import org.modelbus.services.repository.server.IModelBusRepositoryLogPath;
import org.modelbus.services.repository.server.IModelBusSession;
import org.modelbus.services.repository.server.ModelBusNodeKind;
import org.modelbus.services.repository.server.ModelBusRepositoryNodeChangeType;
import org.modelbus.services.repository.server.common.AbstractModelBusRepository;
import org.modelbus.services.repository.server.common.ModelBusRepositoryPathMappingHelper;
import org.modelbus.services.repository.server.impl.ModelBusExtendedRepositoryLogEntryImpl;
import org.modelbus.services.repository.server.impl.ModelBusRepositoryLogEntryImpl;
import org.modelbus.services.repository.server.impl.ModelBusRepositoryLogPathImpl;
import org.modelbus.services.repository.server.svn.ModelBusSvnDirEntry;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SVNModelBusRepository
extends AbstractModelBusRepository
implements IModelBusRepository {
    private static final String[] EXPOSE_SVN_PROPERTIES = new String[]{"mime-type"};
    private static final long REVISION_HEAD = -1L;
    private static final int SVN_ERROR_CODE_DIR_ACCESS_TO_FILE = 160016;
    private static final int SVN_ERROR_CODE_FILE_ACCESS_TO_DIR = 160017;
    private static final int SVN_ERROR_CODE_FILE_EXISTING = 160020;
    private final SVNRepository svnRepository;

    public SVNModelBusRepository(SVNRepository svnRepository) {
        this.svnRepository = svnRepository;
    }

    private void closeOpenDirs(URI uri, ISVNEditor editor) throws SVNException {
        String[] pathComponents = "/".equals(uri.path()) ? new String[1] : (uri.path() != null ? uri.path().split("/") : new String[]{uri.authority()});
        int i = 0;
        while (i < pathComponents.length - 1) {
            if (!"".equals(pathComponents[i])) {
                editor.closeDir();
            }
            ++i;
        }
    }

    private void createFolderPath(URI uri, URI availablePath, ISVNEditor editor, boolean createForLastSegment) {
        String[] pathComponents = "/".equals(uri.path()) ? new String[1] : (uri.path() != null ? uri.path().split("/") : new String[]{uri.authority()});
        int availableSegmentsCount = availablePath != null ? availablePath.segmentCount() + 1 : 0;
        String currentPathComponent = "";
        int last = createForLastSegment ? pathComponents.length : pathComponents.length - 1;
        int i = 0;
        while (i < last) {
            block8: {
                if (!"".equals(pathComponents[i])) {
                    currentPathComponent = String.valueOf(currentPathComponent) + "/" + pathComponents[i];
                    try {
                        if (i < availableSegmentsCount) {
                            editor.openDir(currentPathComponent, -1L);
                            break block8;
                        }
                        try {
                            editor.addDir(currentPathComponent, null, -1L);
                        }
                        catch (SVNException exc) {
                            if (SVNModelBusRepository.exceptionErrorCodeEquals(exc, 160020)) {
                                editor.openDir(currentPathComponent, -1L);
                            }
                        }
                    }
                    catch (SVNException e) {
                        System.out.println(e.getErrorMessage());
                    }
                }
            }
            ++i;
        }
    }

    private void createSVNAuthentication(IModelBusSession session, boolean authenticateByPassword) {
        String username = session.getValueForKey("username");
        SVNPasswordAuthentication svnUserAuthentication = new SVNPasswordAuthentication(username, session.getValueForKey("password"), false, this.svnRepository.getLocation(), false);
        SVNUserNameAuthentication svnUserNameAuthentication = new SVNUserNameAuthentication(username, false, this.svnRepository.getLocation(), false);
        ((BasicAuthenticationManager)this.svnRepository.getAuthenticationManager()).setAuthentications(new SVNAuthentication[]{svnUserAuthentication, svnUserNameAuthentication});
    }

    public String createFile(IModelBusSession session, URI fileUri, InputStream initalFileContent, String logMessage, OptionsMap options) throws RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException {
        try {
            this.accessManager.checkAccessRights(session, fileUri, 2);
        }
        catch (NonExistingResourceException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        catch (LockedException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        this.lockManager.checkCompletlyAccessibleForUser(fileUri, session.getValueForKey("username"));
        return this.internalSaveFile(session, fileUri, initalFileContent, logMessage, 1, options);
    }

    public String createDir(IModelBusSession session, URI directoryUri, String logMessage, OptionsMap options) throws RepositoryAuthentificationException {
        ISVNEditor editor = null;
        this.createSVNAuthentication(session, false);
        URI availURI = this.getAvailablePathURI(session, directoryUri);
        try {
            editor = this.svnRepository.getCommitEditor(logMessage, null, true, null);
            editor.openRoot(-1L);
            this._internalCreateDir(session, editor, availURI, directoryUri, logMessage, true);
        }
        catch (Exception e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
        return "OK";
    }

    private String checkInFile(IModelBusSession session, ISVNEditor editor, URI fileUri, InputStream fileContent, String logMessage) throws InvalidValueException, RepositoryAuthentificationException, LockedException {
        try {
            this.accessManager.checkAccessRights(session, fileUri, 2);
        }
        catch (NonExistingResourceException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        try {
            String fileName = "/" + fileUri.authority();
            String uriPath = fileUri.path();
            if (uriPath != null) {
                fileName = String.valueOf(fileName) + uriPath;
            }
            fileName = URI.decode((String)URI.decode((String)fileName));
            editor.openFile(fileName, -1L);
            editor.applyTextDelta(fileName, null);
            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
            String checksum = deltaGenerator.sendDelta(fileName, (InputStream)new ByteArrayInputStream(new byte[0]), 0L, fileContent, (ISVNDeltaConsumer)editor, false);
            editor.closeFile(fileName, checksum);
            this.notifyUpdateModel(fileUri, session);
            return checksum;
        }
        catch (SVNException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
    }

    private String createFile(IModelBusSession session, ISVNEditor editor, URI availablePath, URI fileUri, InputStream fileContent, String logMessage) throws InvalidValueException, RepositoryAuthentificationException, LockedException, NonExistingResourceException {
        try {
            this.accessManager.checkAccessRights(session, fileUri, 2);
        }
        catch (NonExistingResourceException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        catch (LockedException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        try {
            URI uri = fileUri;
            this.createFolderPath(uri, availablePath, editor, false);
            String fileName = "/" + uri.authority();
            String uriPath = uri.path();
            if (uriPath != null) {
                fileName = String.valueOf(fileName) + uriPath;
            }
            editor.addFile(fileName, null, -1L);
            editor.applyTextDelta(fileName, null);
            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
            String checksum = deltaGenerator.sendDelta(fileName, fileContent, (ISVNDeltaConsumer)editor, true);
            editor.closeFile(fileName, checksum);
            this.closeOpenDirs(uri, editor);
            this.notifyCreateModel(fileUri, session);
            return "OK";
        }
        catch (SVNException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
    }

    private void delete(IModelBusSession session, ISVNEditor editor, URI uri, String logMessage, String revision) throws RepositoryAuthentificationException, LockedException, NonExistingResourceException {
        this.accessManager.checkAccessRights(session, uri, 2);
        try {
            editor.deleteEntry(ModelBusRepositoryPathMappingHelper.normalizePathfromURI((URI)uri), SVNModelBusRepository.parseRevision(revision));
            this.notifyDeleteModel(uri, session);
        }
        catch (SVNException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
    }

    private static long parseRevision(String revisionString) {
        try {
            Long rev = Long.valueOf(revisionString);
            return rev;
        }
        catch (NumberFormatException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
    }

    private String _internalCreateDir(IModelBusSession session, ISVNEditor editor, URI availablePath, URI directoryUri, String logMessage, boolean closeEditor) throws RepositoryAuthentificationException, LockedException, NonExistingResourceException, Exception {
        this.accessManager.checkAccessRights(session, directoryUri, 2);
        try {
            this.createFolderPath(directoryUri, availablePath, editor, true);
            this.closeOpenDirs(directoryUri, editor);
        }
        finally {
            if (closeEditor && editor != null) {
                try {
                    editor.closeEdit();
                }
                catch (SVNException e) {
                    throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
                }
            }
        }
        this.notifyCreateModel(directoryUri, session);
        return "OK";
    }

    public String checkInFile(IModelBusSession session, URI fileUri, InputStream fileContent, String logMessage, OptionsMap options) throws InvalidValueException, RepositoryAuthentificationException, LockedException {
        try {
            this.accessManager.checkAccessRights(session, fileUri, 2);
        }
        catch (NonExistingResourceException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        return this.internalSaveFile(session, fileUri, fileContent, logMessage, 2, options);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String internalSaveFile(IModelBusSession session, URI fileUri, InputStream fileContent, String logMessage, int mode, OptionsMap options) {
        ISVNEditor editor;
        this.createSVNAuthentication(session, false);
        URI availURI = null;
        if (mode == 1) {
            try {
                availURI = this.getAvailablePathURI(session, fileUri);
            }
            catch (RepositoryAuthentificationException e) {
                throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
            }
        }
        try {
            editor = this.svnRepository.getCommitEditor(logMessage, null, true, null);
            editor.openRoot(-1L);
        }
        catch (SVNException exc) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)exc));
        }
        if (mode == 1) {
            this.createFolderPath(fileUri, availURI, editor, false);
        }
        String fileName = "/" + fileUri.authority();
        String uriPath = fileUri.path();
        if (uriPath != null) {
            fileName = String.valueOf(fileName) + uriPath;
        }
        fileName = URI.decode((String)URI.decode((String)fileName));
        try {
            String resourceLinkOption;
            if (mode == 1) {
                editor.addFile(fileName, null, -1L);
            } else {
                editor.openFile(fileName, -1L);
            }
            editor.applyTextDelta(fileName, null);
            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
            String contentTypeOption = AbstractModelBusRepository.getOptionAsString((OptionsMap)options, (String)"Content-Type");
            if (contentTypeOption != null) {
                this.setFileProperty(editor, fileName, "svn:mime-type", contentTypeOption);
            }
            if ((resourceLinkOption = AbstractModelBusRepository.getOptionAsString((OptionsMap)options, (String)"MB_SymLink")) != null) {
                this.setFileProperty(editor, fileName, "MB_SymLink", resourceLinkOption);
            }
            String checksum = mode == 1 ? deltaGenerator.sendDelta(fileName, fileContent, (ISVNDeltaConsumer)editor, true) : deltaGenerator.sendDelta(fileName, (InputStream)new ByteArrayInputStream(new byte[0]), 0L, fileContent, (ISVNDeltaConsumer)editor, false);
            if (mode == 1) {
                this.closeOpenDirs(fileUri, editor);
            } else {
                editor.closeFile(fileName, checksum);
            }
            editor.closeDir();
            URI notificationURI = fileUri;
            URI origURI = (URI)AbstractModelBusRepository.getOption((OptionsMap)options, (String)"origURI");
            if (origURI != null) {
                notificationURI = origURI;
            }
            if (mode == 1) {
                this.notifyCreateModel(notificationURI, session);
            } else {
                this.notifyUpdateModel(notificationURI, session);
            }
            String string = checksum;
            return string;
        }
        catch (SVNException exc) {
            if (this.areSymbolicLinksEnabled() && SVNModelBusRepository.exceptionErrorCodeEquals(exc, 160017)) {
                URI newURI;
                block57: {
                    newURI = URI.createURI((String)(String.valueOf(fileUri.toString()) + "_file"));
                    try {
                        if (editor == null) break block57;
                        editor.openDir(fileName, -1L);
                        this._setDirectoryProperty(editor, fileName, "MB_SymLink", newURI.toString());
                        try {
                            editor.closeDir();
                        }
                        catch (SVNException sVNException) {}
                        editor.closeEdit();
                        editor = null;
                    }
                    catch (SVNException e) {
                        throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
                    }
                }
                OptionMapEntry option = new OptionMapEntry();
                option.setOptionName("origURI");
                option.setOptionValue((Object)fileUri);
                options.getMapEntry().add(option);
                int useMode = 1;
                try {
                    if (this.internalExists(session, newURI, "-1")) {
                        useMode = 2;
                    }
                }
                catch (Exception exception) {
                    throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)exc));
                }
                String string = this.internalSaveFile(session, newURI, fileContent, logMessage, useMode, options);
                return string;
            }
            if (!this.areSymbolicLinksEnabled()) throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)exc));
            if (!SVNModelBusRepository.exceptionErrorCodeEquals(exc, 160016)) throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)exc));
            if (editor != null) {
                try {
                    if (mode == 1) {
                        this.closeOpenDirs(fileUri, editor);
                    }
                    editor.closeDir();
                }
                catch (Exception exception) {}
                try {
                    editor.closeEdit();
                }
                catch (SVNException sVNException) {}
            }
            URI symDirURI = this.getLinkDirURI(session, fileUri);
            String dirNameOld = fileUri.segment(symDirURI.segmentCount() - 1);
            String dirNameNew = symDirURI.lastSegment();
            URI symLinkURI = symDirURI;
            int i = symDirURI.segmentCount();
            while (true) {
                if (i >= fileUri.segmentCount()) {
                    try {
                        if (editor == null) break;
                        String _fileName = symDirURI.trimSegments(1).appendSegment(dirNameOld).toString().replace("http://", "");
                        editor.openRoot(-1L);
                        editor.openFile(_fileName, -1L);
                        this.setFileProperty(editor, _fileName, "MB_SymLink", dirNameNew);
                        editor.closeDir();
                        editor.closeEdit();
                        editor = null;
                        break;
                    }
                    catch (SVNException e) {
                        throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
                    }
                }
                symLinkURI = symLinkURI.appendSegment(fileUri.segment(i));
                ++i;
            }
            OptionMapEntry option = new OptionMapEntry();
            option.setOptionName("origURI");
            option.setOptionValue((Object)fileUri);
            options.getMapEntry().add(option);
            try {
                if (this.internalExists(session, symLinkURI, "-1")) return "OK";
                String string = this.internalSaveFile(session, symLinkURI, fileContent, logMessage, 1, options);
                return string;
            }
            catch (Exception exception) {
                return "OK";
            }
        }
        finally {
            try {
                if (editor != null) {
                    editor.closeEdit();
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    private void setFileProperty(ISVNEditor editor, String filePath, String propertyName, String propertyValue) throws SVNException {
        editor.changeFileProperty(filePath, propertyName, SVNPropertyValue.create((String)propertyValue));
    }

    private void _setDirectoryProperty(ISVNEditor editor, String filePath, String propertyName, String propertyValue) throws SVNException {
        editor.changeDirProperty(propertyName, SVNPropertyValue.create((String)propertyValue));
    }

    public IModelBusDirEntry getDir(IModelBusSession session, URI uri, String revision, boolean includeCommitMessages, Collection<IModelBusDirEntry> entries) throws RepositoryAuthentificationException, InvalidRevisionException, NonExistingResourceException {
        try {
            String normalizedUrl = ModelBusRepositoryPathMappingHelper.normalizePathfromURI((URI)uri);
            if (this.exists(session, URI.createURI((String)normalizedUrl), revision)) {
                SVNDirEntry svnDirEntry = this.svnRepository.getDir(normalizedUrl, SVNModelBusRepository.parseRevision(revision), includeCommitMessages, entries);
                ModelBusSvnDirEntry.convertSVNDirEntryCollectionToModelBusDirEntryCollectionDestructive(entries, this.svnRepository.getLocation().getPath());
                ArrayList<IModelBusDirEntry> symEntries = new ArrayList<IModelBusDirEntry>();
                Iterator<IModelBusDirEntry> iterator = entries.iterator();
                while (iterator.hasNext()) {
                    IModelBusDirEntry symLinkSubEntry;
                    String symLinkURI;
                    IModelBusDirEntry subEntry = iterator.next();
                    String subEntryURL = subEntry.getUrl();
                    URI subEntryURI = URI.createURI((String)subEntryURL);
                    boolean removed = false;
                    if (!this.accessManager.hasAccessRights(session, subEntryURI, 1)) {
                        iterator.remove();
                        removed = true;
                    }
                    if (subEntryURL.endsWith("_file") || subEntryURL.endsWith("_dir")) {
                        iterator.remove();
                        removed = true;
                    }
                    if (removed || (symLinkURI = this.getFileProperty(session, subEntryURI, "MB_SymLink", revision)) == null || (symLinkSubEntry = this.infoFileSystem(session, URI.createURI((String)symLinkURI), revision)) == null) continue;
                    symLinkSubEntry.setName(subEntry.getName());
                    symLinkSubEntry.setUrl(subEntry.getUrl());
                    symEntries.add(symLinkSubEntry);
                }
                entries.addAll(symEntries);
                return new ModelBusSvnDirEntry(svnDirEntry, this.svnRepository.getLocation().getPath());
            }
            return null;
        }
        catch (Exception e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
    }

    protected boolean _internalExists(IModelBusSession session, URI uri, String revision) throws RepositoryAuthentificationException, NonExistingResourceException {
        try {
            SVNNodeKind svnNodeKind = this.svnRepository.checkPath(ModelBusRepositoryPathMappingHelper.normalizePathfromURI((URI)uri), SVNModelBusRepository.parseRevision(revision));
            return SVNNodeKind.NONE.compareTo((Object)svnNodeKind) != 0;
        }
        catch (SVNException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
    }

    protected URI getSymLinkForFileURI(IModelBusSession session, URI uri, String revision) {
        ModelBusNodeKind nodeKind;
        try {
            nodeKind = this.checkPathFileSystem(session, uri, revision);
        }
        catch (Exception e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
        if (nodeKind != null && ModelBusNodeKind.FILE.equals((Object)nodeKind)) {
            return null;
        }
        List segmentsList = uri.segmentsList();
        URI checkURI = uri.trimSegments(uri.segmentCount());
        int i = 0;
        while (i < segmentsList.size()) {
            String symLink;
            ModelBusNodeKind subNodeKind;
            String segment = (String)segmentsList.get(i);
            checkURI = checkURI.appendSegment(segment);
            try {
                subNodeKind = this.checkPathFileSystem(session, checkURI, revision);
            }
            catch (Exception e) {
                throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
            }
            if (!(subNodeKind != null && i < segmentsList.size() - 1 && ModelBusNodeKind.DIR.equals((Object)subNodeKind) || (symLink = this.getFileProperty(session, checkURI, "MB_SymLink", revision)) == null)) {
                checkURI = checkURI.trimSegments(1).appendSegment(symLink);
            }
            ++i;
        }
        if (checkURI.equals(uri)) {
            return null;
        }
        return checkURI;
    }

    public void delete(IModelBusSession session, URI uri, String logMessage, String revision) throws RepositoryAuthentificationException, LockedException, NonExistingResourceException {
        if ("".equals(logMessage)) {
            logMessage = "[no comment]";
        }
        ISVNEditor editor = null;
        try {
            try {
                this.createSVNAuthentication(session, false);
                editor = this.svnRepository.getCommitEditor(logMessage, null, true, null);
                long revisionLong = SVNModelBusRepository.parseRevision(revision);
                editor.openRoot(revisionLong);
                this.delete(session, editor, uri, logMessage, revision);
                if (editor != null) {
                    editor.closeEdit();
                    editor = null;
                }
                try {
                    this.dependenciesManager.deleteDependenciesInfos(uri);
                }
                catch (UnresolvedReferencesException e) {
                    throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
                }
                catch (InvalidValueException e) {
                    throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
                }
                catch (ConstraintViolationException e) {
                    throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
                }
            }
            catch (SVNException e) {
                throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
            }
        }
        finally {
            try {
                if (editor != null) {
                    editor.closeEdit();
                    editor = null;
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    public void copy(IModelBusSession session, URI[] srcPaths, URI destPath, boolean isMove, boolean failWhenDstExists, String message) throws RepositoryAuthentificationException, NonExistingResourceException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, InvalidRevisionException {
        try {
            this.accessManager.checkAccessRights(session, srcPaths, 1);
            this.accessManager.checkAccessRights(session, destPath, 2);
        }
        catch (LockedException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        SVNClientManager clientManager = SVNClientManager.newInstance();
        this.createSVNAuthentication(session, true);
        clientManager.setAuthenticationManager(this.svnRepository.getAuthenticationManager());
        String rootURL = this.svnRepository.getLocation().toString();
        SVNCopySource[] svnCopySources = new SVNCopySource[srcPaths.length];
        int i = 0;
        while (i < srcPaths.length) {
            URI currentURI = srcPaths[i];
            String currentPathAdjusted = String.valueOf(rootURL) + "/" + currentURI.toString().substring("http://".length());
            SVNRevision pegRevision = null;
            SVNRevision svnRevision = null;
            if (currentURI.hasQuery()) {
                Map queryMap = AbstractModelBusRepository.getQueryMap((String)currentURI.query());
                pegRevision = SVNRevision.parse((String)((String)queryMap.get("pegRevision")));
                svnRevision = SVNRevision.parse((String)((String)queryMap.get("revision")));
                currentPathAdjusted = currentPathAdjusted.substring(0, currentPathAdjusted.indexOf(63));
            } else {
                pegRevision = SVNRevision.HEAD;
                IModelBusDirEntry entry = this.infoFileSystem(session, currentURI, "-1");
                if (entry == null) {
                    throw new NonExistingResourceException("Resource \"" + currentURI.toString() + "\" does not exist.");
                }
                long revisionLong = Long.valueOf(entry.getRevision());
                svnRevision = SVNRevision.create((long)revisionLong);
            }
            try {
                SVNURL svnurl = SVNURL.parseURIEncoded((String)currentPathAdjusted);
                svnCopySources[i] = new SVNCopySource(pegRevision, svnRevision, svnurl);
            }
            catch (SVNException e) {
                throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
            }
            ++i;
        }
        String destPathAdjusted = String.valueOf(rootURL) + "/" + destPath.toString().substring("http://".length());
        try {
            clientManager.getCopyClient().doCopy(svnCopySources, SVNURL.parseURIEncoded((String)destPathAdjusted), isMove, true, failWhenDstExists, message, new SVNProperties());
        }
        catch (SVNException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
    }

    public ModelBusNodeKind checkPathFileSystem(IModelBusSession session, URI uri, String revision) throws RepositoryAuthentificationException, NonExistingResourceException {
        SVNNodeKind svnNodeKind;
        try {
            this.accessManager.checkAccessRights(session, uri, 1);
        }
        catch (LockedException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        try {
            svnNodeKind = this.svnRepository.checkPath(ModelBusRepositoryPathMappingHelper.normalizePathfromURI((URI)uri), SVNModelBusRepository.parseRevision(revision));
        }
        catch (SVNException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        if (svnNodeKind.equals(SVNNodeKind.NONE)) {
            return null;
        }
        return ModelBusSvnDirEntry.convertSVNNodeKindToModelBusNodeKind(svnNodeKind);
    }

    protected IModelBusDirEntry infoFileSystem(IModelBusSession session, URI uri, String revision) throws RepositoryAuthentificationException, InvalidRevisionException, NonExistingResourceException {
        try {
            this.accessManager.checkAccessRights(session, uri, 1);
        }
        catch (LockedException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        try {
            URI infoURI = null;
            URI symLinkForFileURI = null;
            if (!this.internalExists(session, uri, revision)) {
                symLinkForFileURI = this.getSymLinkForFileURI(session, uri, revision);
                if (symLinkForFileURI != null && this.internalExists(session, symLinkForFileURI, revision)) {
                    infoURI = symLinkForFileURI;
                }
            } else {
                infoURI = uri;
            }
            if (infoURI != null) {
                String normalizedUrl = ModelBusRepositoryPathMappingHelper.normalizePathfromURI((URI)infoURI);
                long revisionLong = SVNModelBusRepository.parseRevision(revision);
                SVNDirEntry svnDirEntry = this.svnRepository.info(normalizedUrl, revisionLong);
                ModelBusSvnDirEntry entry = new ModelBusSvnDirEntry(svnDirEntry, this.svnRepository.getLocation().getPath());
                if (symLinkForFileURI != null) {
                    entry.setUrl(uri.toString());
                }
                SVNProperties svnProperties = new SVNProperties();
                if (ModelBusNodeKind.FILE.equals((Object)entry.getKind())) {
                    this.svnRepository.getFile(normalizedUrl, revisionLong, svnProperties, null);
                } else {
                    this.svnRepository.getDir(normalizedUrl, revisionLong, svnProperties, new ISVNDirEntryHandler(){

                        public void handleDirEntry(SVNDirEntry entry) throws SVNException {
                        }
                    });
                }
                for (Object key : svnProperties.asMap().keySet()) {
                    String propertyName;
                    if (!(key instanceof String)) continue;
                    String propertyNameUse = propertyName = (String)key;
                    if (propertyName.startsWith("svn:")) {
                        String propertyNameWithoutPrefix = propertyName.substring(4);
                        boolean whiteListed = false;
                        String[] stringArray = EXPOSE_SVN_PROPERTIES;
                        int n = EXPOSE_SVN_PROPERTIES.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String whiteListedProperty = stringArray[n2];
                            if (whiteListedProperty.equals(propertyNameWithoutPrefix)) {
                                whiteListed = true;
                                break;
                            }
                            ++n2;
                        }
                        if (!whiteListed) continue;
                        propertyNameUse = propertyNameWithoutPrefix;
                    }
                    entry.addProperty(propertyNameUse, svnProperties.getStringValue(propertyName));
                }
                return entry;
            }
        }
        catch (MalformedURLException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
        catch (SVNException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        return null;
    }

    public IModelBusRepositoryLogEntry[] getLogEntries(IModelBusSession session, URI[] targetPaths, String startRevision, String endRevision, boolean changedPath, boolean strictNode, long limit, boolean includeMergedRevisions, String[] revisionProperties) throws RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException {
        try {
            this.accessManager.checkAccessRights(session, targetPaths, 1);
        }
        catch (NonExistingResourceException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        catch (LockedException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        final ArrayList modelBusRepositoryLogEntries = new ArrayList();
        revisionProperties = new String[]{"svn:author", "svn:log", "svn:date"};
        String[] targetPathsAdjusted = new String[targetPaths.length];
        int i = 0;
        while (i < targetPaths.length) {
            targetPathsAdjusted[i] = targetPaths[i].toString().substring("http:/".length());
            ++i;
        }
        try {
            this.svnRepository.log(targetPathsAdjusted, SVNModelBusRepository.parseRevision(startRevision), SVNModelBusRepository.parseRevision(endRevision), changedPath, strictNode, limit, includeMergedRevisions, revisionProperties, new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                    Map changedPathsOriginal = logEntry.getChangedPaths();
                    Map changedPathsConverted = SVNModelBusRepository.convertFSPathChangeMapToIModelBusRepositoryChangePathMap(changedPathsOriginal);
                    ModelBusRepositoryLogEntryImpl modelBusEntry = new ModelBusRepositoryLogEntryImpl(changedPathsConverted, String.valueOf(logEntry.getRevision()), logEntry.getAuthor(), logEntry.getDate(), logEntry.getMessage(), logEntry.hasChildren());
                    modelBusRepositoryLogEntries.add(modelBusEntry);
                }
            });
            return modelBusRepositoryLogEntries.toArray(new IModelBusRepositoryLogEntry[0]);
        }
        catch (SVNException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
    }

    private static Map<String, IModelBusRepositoryLogPath> convertFSPathChangeMapToIModelBusRepositoryChangePathMap(Map<String, SVNLogEntryPath> changedPathsOriginal) {
        HashMap<String, IModelBusRepositoryLogPath> changedPathsConverted = new HashMap<String, IModelBusRepositoryLogPath>(changedPathsOriginal.size());
        Iterator<String> it = changedPathsOriginal.keySet().iterator();
        String key = null;
        SVNLogEntryPath original = null;
        ModelBusRepositoryLogPathImpl converted = null;
        while (it.hasNext()) {
            key = it.next();
            original = changedPathsOriginal.get(key);
            converted = new ModelBusRepositoryLogPathImpl();
            converted.setPath(original.getPath());
            converted.setCopiedFromPath(original.getCopyPath());
            converted.setCopiedFromRevision(String.valueOf(original.getCopyRevision()));
            converted.setAction(SVNModelBusRepository.convertFSPathChangeKindToModelBusRepositoryNodeChangeType(original));
            changedPathsConverted.put(converted.getPath(), (IModelBusRepositoryLogPath)converted);
        }
        return changedPathsConverted;
    }

    private static ModelBusRepositoryNodeChangeType convertFSPathChangeKindToModelBusRepositoryNodeChangeType(SVNLogEntryPath svnLogEntryPath) {
        ModelBusRepositoryNodeChangeType result = ModelBusRepositoryNodeChangeType.NONE;
        switch (svnLogEntryPath.getType()) {
            case 'A': {
                result = ModelBusRepositoryNodeChangeType.ADDED;
                break;
            }
            case 'D': {
                result = ModelBusRepositoryNodeChangeType.DELETED;
                break;
            }
            case 'M': {
                result = ModelBusRepositoryNodeChangeType.MODIFIED;
                break;
            }
            case 'R': {
                result = ModelBusRepositoryNodeChangeType.REPLACED;
                break;
            }
            default: {
                result = ModelBusRepositoryNodeChangeType.NONE;
            }
        }
        return result;
    }

    protected void control_SetModelFragmentProperties(IModelBusSession session, URI parentModelURI, URI childModelURI, URI fragmentURI, String logMessage) {
        ISVNEditor editor = null;
        try {
            try {
                this.createSVNAuthentication(session, false);
                editor = this.svnRepository.getCommitEditor(logMessage, null, true, null);
                editor.openRoot(-1L);
                String childFileName = "/" + childModelURI.authority() + childModelURI.path();
                String modelFileName = "/" + parentModelURI.authority() + parentModelURI.path();
                childFileName = URI.decode((String)URI.decode((String)childFileName));
                editor.openFile(childFileName, -1L);
                editor.changeFileProperty(childFileName, "MB_ParentModel", SVNPropertyValue.create((String)fragmentURI.toString()));
                editor.closeFile(childFileName, null);
                modelFileName = URI.decode((String)URI.decode((String)modelFileName));
                editor.openFile(modelFileName, -1L);
                editor.changeFileProperty(modelFileName, "MB_ChildModel", SVNPropertyValue.create((String)childModelURI.toString()));
                editor.closeFile(modelFileName, null);
                editor.closeDir();
            }
            catch (SVNException e) {
                throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
            }
        }
        finally {
            try {
                if (editor != null) {
                    editor.closeEdit();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void uncontrol_SetModelParentProperty(IModelBusSession session, URI parentModelURI, URI childModelURI, String logMessage) {
        ISVNEditor editor = null;
        try {
            try {
                this.createSVNAuthentication(session, false);
                editor = this.svnRepository.getCommitEditor(logMessage, null, true, null);
                editor.openRoot(-1L);
                String childModelFileName = "/" + childModelURI.authority() + childModelURI.path();
                childModelFileName = URI.decode((String)URI.decode((String)childModelFileName));
                editor.openFile(childModelFileName, -1L);
                editor.changeFileProperty(childModelFileName, "MB_ParentModel", SVNPropertyValue.create((String)parentModelURI.toString()));
                editor.closeFile(childModelFileName, null);
                editor.closeDir();
            }
            catch (SVNException e) {
                throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
            }
        }
        finally {
            if (editor != null) {
                try {
                    editor.closeEdit();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
    }

    public String commit(IModelBusSession session, List<PathFileContentMapEntry> createFileMap, List<PathFileContentMapEntry> checkInFileMap, List<String> folderPaths, List<String> deletionPaths, String logMessage) throws RepositoryAuthentificationException, InvalidValueException, RepositoryRuntimeException, LockedException, NonExistingResourceException {
        ISVNEditor editor = null;
        try {
            try {
                PathFileContentMapEntry mapEntry;
                int i;
                this.createSVNAuthentication(session, false);
                URI[] availFolderURIs = null;
                URI[] folderURIs = null;
                URI[] availFilePathURIs = null;
                URI[] fileURIs = null;
                if (folderPaths != null) {
                    availFolderURIs = new URI[folderPaths.size()];
                    folderURIs = new URI[folderPaths.size()];
                    i = 0;
                    while (i < folderPaths.size()) {
                        URI folderURI = URI.createURI((String)folderPaths.get(i));
                        availFolderURIs[i] = this.getAvailablePathURI(session, folderURI);
                        folderURIs[i] = folderURI;
                        ++i;
                    }
                }
                if (createFileMap != null) {
                    availFilePathURIs = new URI[createFileMap.size()];
                    fileURIs = new URI[createFileMap.size()];
                    i = 0;
                    while (i < createFileMap.size()) {
                        mapEntry = createFileMap.get(i);
                        URI fileURI = URI.createURI((String)mapEntry.getPath());
                        fileURI = AbstractModelBusRepository.getRemoteURI((URI)fileURI);
                        availFilePathURIs[i] = this.getAvailablePathURI(session, fileURI);
                        fileURIs[i] = fileURI;
                        ++i;
                    }
                }
                editor = this.svnRepository.getCommitEditor(logMessage, null, true, null);
                editor.openRoot(-1L);
                if (folderURIs != null) {
                    i = 0;
                    while (i < folderURIs.length) {
                        try {
                            this._internalCreateDir(session, editor, availFolderURIs[i], folderURIs[i], logMessage, false);
                        }
                        catch (Exception e) {
                            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
                        }
                        ++i;
                    }
                }
                if (createFileMap != null) {
                    i = 0;
                    while (i < createFileMap.size()) {
                        mapEntry = createFileMap.get(i);
                        DataHandler dataHandler = mapEntry.getFileContent();
                        DataSource dataSource = dataHandler.getDataSource();
                        File tempFile = null;
                        try {
                            try {
                                tempFile = AbstractModelBusRepository._writeToTemporaryFile((InputStream)dataSource.getInputStream());
                                this.createFile(session, editor, availFilePathURIs[i], fileURIs[i], new FileInputStream(tempFile), logMessage);
                            }
                            catch (IOException e) {
                                throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
                            }
                        }
                        finally {
                            if (tempFile != null && tempFile.exists()) {
                                tempFile.delete();
                            }
                        }
                        ++i;
                    }
                }
                if (checkInFileMap != null) {
                    for (PathFileContentMapEntry mapEntry2 : checkInFileMap) {
                        String path = mapEntry2.getPath();
                        DataHandler dataHandler = mapEntry2.getFileContent();
                        DataSource dataSource = dataHandler.getDataSource();
                        File tempFile = null;
                        try {
                            try {
                                tempFile = AbstractModelBusRepository._writeToTemporaryFile((InputStream)dataSource.getInputStream());
                                this.checkInFile(session, editor, URI.createURI((String)path), new FileInputStream(tempFile), logMessage);
                            }
                            catch (IOException e) {
                                throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
                            }
                        }
                        finally {
                            if (tempFile != null && tempFile.exists()) {
                                tempFile.delete();
                            }
                        }
                    }
                }
                if (deletionPaths != null) {
                    for (String deletionPath : deletionPaths) {
                        this.delete(session, editor, URI.createURI((String)deletionPath), logMessage, "-1");
                    }
                }
                editor.closeDir();
                editor.closeEdit();
                if (deletionPaths != null) {
                    for (String deletionPath : deletionPaths) {
                        try {
                            this.dependenciesManager.deleteDependenciesInfos(URI.createURI((String)deletionPath));
                        }
                        catch (UnresolvedReferencesException e) {
                            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
                        }
                        catch (InvalidValueException e) {
                            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
                        }
                        catch (ConstraintViolationException e) {
                            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
                        }
                    }
                }
            }
            catch (SVNException e) {
                throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
            }
        }
        finally {
            if (editor != null) {
                try {
                    editor.closeEdit();
                }
                catch (SVNException e) {
                    e.printStackTrace();
                }
            }
        }
        return "OK";
    }

    protected long internalLoadFile(IModelBusSession session, String filePath, String revision, Map<String, Object> properties, OutputStream content, boolean useSymLinks) {
        SVNProperties svnFileProperties = new SVNProperties();
        try {
            long taken_revision = this.svnRepository.getFile(filePath, SVNModelBusRepository.parseRevision(revision), svnFileProperties, content);
            Map propertiesMap = svnFileProperties.asMap();
            Set svnpropertiesKeys = propertiesMap.keySet();
            for (String propertyKey : svnpropertiesKeys) {
                Object propertyObject = propertiesMap.get(propertyKey);
                if (propertyObject == null || !(propertyObject instanceof SVNPropertyValue)) continue;
                properties.put(propertyKey, propertyObject.toString());
            }
            return taken_revision;
        }
        catch (SVNException exc) {
            if (this.areSymbolicLinksEnabled() && useSymLinks) {
                URI symURI;
                if (SVNModelBusRepository.exceptionErrorCodeEquals(exc, 160017)) {
                    String linkURI = this.getFileProperty(session, URI.createURI((String)filePath), "MB_SymLink", revision);
                    if (linkURI != null) {
                        String linkURINormalized = ModelBusRepositoryPathMappingHelper.normalizePathfromURIString((String)linkURI);
                        System.out.println("Checking out file: " + linkURINormalized + " linked in: " + filePath);
                        return this.internalLoadFile(session, linkURINormalized, revision, properties, content, true);
                    }
                } else if (SVNModelBusRepository.exceptionErrorCodeEquals(exc, 160016) && (symURI = this.getSymLinkForFileURI(session, URI.createURI((String)("http:/" + filePath)), revision)) != null) {
                    String symURINormalized = ModelBusRepositoryPathMappingHelper.normalizePathfromURI((URI)symURI);
                    System.out.println("Checking out file: " + filePath + " from sym link \"" + symURINormalized.toString() + "\".");
                    return this.internalLoadFile(session, symURINormalized, revision, properties, content, true);
                }
            }
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)exc));
        }
    }

    protected static boolean exceptionErrorCodeEquals(SVNException exc, int code) {
        return exc.getErrorMessage().getErrorCode().getCode() == code;
    }

    protected IModelBusExtendedRepositoryLogEntry _getExtendedLogEntryByDate(IModelBusSession session, long revisionDate) throws RepositoryRuntimeException, RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException {
        IModelBusRepositoryLogEntry[] logEntries;
        try {
            logEntries = this.getLogEntries(session, new URI[]{URI.createURI((String)"http:/")}, "-1", "0", true, true, -1L, true, null);
        }
        catch (UnresolvedReferencesException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        if (logEntries == null || logEntries.length == 0) {
            return null;
        }
        IModelBusRepositoryLogEntry entryFound = null;
        IModelBusRepositoryLogEntry[] iModelBusRepositoryLogEntryArray = logEntries;
        int n = logEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IModelBusRepositoryLogEntry logEntry = iModelBusRepositoryLogEntryArray[n2];
            long currentTimestamp = logEntry.getDate().getTime();
            if (currentTimestamp == revisionDate) {
                if (entryFound != null) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTimeInMillis(revisionDate);
                }
                entryFound = logEntry;
            }
            ++n2;
        }
        if (entryFound == null) {
            return null;
        }
        return this._getExtendedLogEntryByRevision(session, entryFound.getRevision());
    }

    protected IModelBusExtendedRepositoryLogEntry _getExtendedLogEntryByRevision(IModelBusSession session, String revision) throws RepositoryRuntimeException, RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException {
        IModelBusRepositoryLogEntry[] logEntries;
        long revisionLong;
        long previousRevision = revisionLong = SVNModelBusRepository.parseRevision(revision);
        if (revisionLong > 1L) {
            --previousRevision;
        }
        try {
            logEntries = this.getLogEntries(session, new URI[]{URI.createURI((String)"http:/")}, revision, String.valueOf(previousRevision), true, true, 2L, true, null);
        }
        catch (UnresolvedReferencesException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        if (logEntries == null || logEntries.length == 0) {
            return null;
        }
        String previousRevisionString = null;
        Date previousRevisionDate = null;
        if (logEntries.length > 1) {
            IModelBusRepositoryLogEntry previousLogEntry = logEntries[1];
            previousRevisionString = previousLogEntry.getRevision();
            previousRevisionDate = previousLogEntry.getDate();
        }
        IModelBusRepositoryLogEntry logEntry = logEntries[0];
        ModelBusExtendedRepositoryLogEntryImpl extLogEntry = new ModelBusExtendedRepositoryLogEntryImpl(logEntry.getChangedPaths(), logEntry.getRevision(), logEntry.getAuthor(), logEntry.getDate(), previousRevisionString, previousRevisionDate, logEntry.getMessage(), logEntry.hasChildren());
        return extLogEntry;
    }

    protected String getFileProperty(IModelBusSession session, URI fileURI, String propertyName, String revision) {
        ModelBusNodeKind nodeKind = null;
        try {
            nodeKind = this.checkPathFileSystem(session, fileURI, revision);
        }
        catch (Exception e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)e);
        }
        if (nodeKind == null) {
            return null;
        }
        long revisionLong = SVNModelBusRepository.parseRevision(revision);
        SVNProperties svnProperties = new SVNProperties();
        String normalizedUrl = ModelBusRepositoryPathMappingHelper.normalizePathfromURI((URI)fileURI);
        try {
            if (ModelBusNodeKind.FILE.equals((Object)nodeKind)) {
                this.svnRepository.getFile(normalizedUrl, revisionLong, svnProperties, null);
            } else {
                this.svnRepository.getDir(normalizedUrl, revisionLong, svnProperties, new ISVNDirEntryHandler(){

                    public void handleDirEntry(SVNDirEntry entry) throws SVNException {
                    }
                });
            }
        }
        catch (SVNException e) {
            throw AbstractModelBusRepository._createWrappedRepositoryRuntimeException((Exception)((Object)e));
        }
        if (svnProperties.containsName(propertyName)) {
            return svnProperties.getStringValue(propertyName);
        }
        return null;
    }
}

