/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.model;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.modelbus.desktop.auth.api.SelectionDispatcher;
import org.modelbus.desktop.model.ModelElementUtil;
import org.modelbus.desktop.model.ModelTreeContentProvider;

public class ModelViewComposite
extends Composite {
    private static final long serialVersionUID = 5883499507114783123L;
    private TreeViewer modelElementsTreeViewer;

    public ModelViewComposite(Composite parent, int style) {
        super(parent, style);
        this.build();
    }

    private void build() {
        GridLayout mainCompositeLayout = new GridLayout(1, false);
        mainCompositeLayout.marginWidth = 0;
        mainCompositeLayout.marginHeight = 0;
        this.setLayout((Layout)mainCompositeLayout);
        Composite treeComposite = new Composite((Composite)this, 0);
        treeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.modelElementsTreeViewer = new TreeViewer(treeComposite, 68100);
        this.modelElementsTreeViewer.getTree().setHeaderVisible(false);
        this.modelElementsTreeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.modelElementsTreeViewer.setContentProvider((IContentProvider)new ModelTreeContentProvider());
        TreeViewerColumn columnElement = new TreeViewerColumn(this.modelElementsTreeViewer, 16384);
        columnElement.getColumn().setText("Element");
        columnElement.getColumn().setMoveable(true);
        TreeColumnLayout tableColumnLayout = new TreeColumnLayout();
        treeComposite.setLayout((Layout)tableColumnLayout);
        tableColumnLayout.setColumnData((Widget)columnElement.getColumn(), (ColumnLayoutData)new ColumnWeightData(80));
        columnElement.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private static final long serialVersionUID = 991621213507956551L;

            public String getText(Object element) {
                if (!(element instanceof EObject)) {
                    return element.toString();
                }
                return ModelElementUtil.getElementLabelReflectively((EObject)element, true);
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        this.modelElementsTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection structSelection = (IStructuredSelection)selection;
                if (structSelection.isEmpty()) {
                    return;
                }
                EObject selectedElement = (EObject)structSelection.getFirstElement();
                SelectionDispatcher.getInstance().setSelectedModelElement(selectedElement);
            }
        });
    }

    public void setModel(Resource model) {
        if (model == null) {
            this.modelElementsTreeViewer.setInput(null);
            return;
        }
        EList contents = model.getContents();
        if (!contents.isEmpty()) {
            EObject rootElement = (EObject)contents.get(0);
            this.modelElementsTreeViewer.setInput((Object)rootElement);
            this.modelElementsTreeViewer.expandAll();
        }
    }
}

