/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.processor.resequencer.ResequencerEngine;
import org.apache.camel.processor.resequencer.SequenceElementComparator;
import org.apache.camel.processor.resequencer.SequenceSender;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamResequencer
extends ServiceSupport
implements SequenceSender<Exchange>,
Processor,
Navigate<Processor>,
Traceable {
    private static final long DELIVERY_ATTEMPT_INTERVAL = 1000L;
    private static final Logger LOG = LoggerFactory.getLogger(StreamResequencer.class);
    private final CamelContext camelContext;
    private final ExceptionHandler exceptionHandler;
    private final ResequencerEngine<Exchange> engine;
    private final Processor processor;
    private Delivery delivery;
    private int capacity;
    private boolean ignoreInvalidExchanges;

    public StreamResequencer(CamelContext camelContext, Processor processor, SequenceElementComparator<Exchange> comparator) {
        ObjectHelper.notNull(camelContext, "CamelContext");
        this.camelContext = camelContext;
        this.exceptionHandler = new LoggingExceptionHandler(this.getClass());
        this.engine = new ResequencerEngine<Exchange>(comparator);
        this.engine.setSequenceSender(this);
        this.processor = processor;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public long getTimeout() {
        return this.engine.getTimeout();
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setTimeout(long timeout) {
        this.engine.setTimeout(timeout);
    }

    public boolean isIgnoreInvalidExchanges() {
        return this.ignoreInvalidExchanges;
    }

    public void setIgnoreInvalidExchanges(boolean ignoreInvalidExchanges) {
        this.ignoreInvalidExchanges = ignoreInvalidExchanges;
    }

    public String toString() {
        return "StreamResequencer[to: " + this.processor + "]";
    }

    @Override
    public String getTraceLabel() {
        return "streamResequence";
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.processor);
        this.delivery = new Delivery();
        this.engine.start();
        this.delivery.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.engine.stop();
        ServiceHelper.stopServices(this.processor);
    }

    @Override
    public void sendElement(Exchange exchange) throws Exception {
        this.processor.process(exchange);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        while (this.engine.size() >= this.capacity) {
            Thread.sleep(this.getTimeout());
        }
        try {
            this.engine.insert(exchange);
            this.delivery.request();
        }
        catch (IllegalArgumentException e) {
            if (this.isIgnoreInvalidExchanges()) {
                LOG.debug("Invalid Exchange. This Exchange will be ignored: {}", (Object)exchange);
                return;
            }
            throw new CamelExchangeException("Error processing Exchange in StreamResequencer", exchange, e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.processor != null;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.processor);
        return answer;
    }

    class Delivery
    extends Thread {
        private Lock deliveryRequestLock;
        private Condition deliveryRequestCondition;

        public Delivery() {
            super(StreamResequencer.this.camelContext.getExecutorServiceManager().resolveThreadName("Resequencer Delivery"));
            this.deliveryRequestLock = new ReentrantLock();
            this.deliveryRequestCondition = this.deliveryRequestLock.newCondition();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (StreamResequencer.this.isRunAllowed()) {
                try {
                    this.deliveryRequestLock.lock();
                    try {
                        this.deliveryRequestCondition.await(1000L, TimeUnit.MILLISECONDS);
                    }
                    finally {
                        this.deliveryRequestLock.unlock();
                    }
                }
                catch (InterruptedException e) {
                    break;
                }
                try {
                    StreamResequencer.this.engine.deliver();
                }
                catch (Throwable t) {
                    StreamResequencer.this.getExceptionHandler().handleException(t);
                }
            }
        }

        public void cancel() {
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void request() {
            this.deliveryRequestLock.lock();
            try {
                this.deliveryRequestCondition.signal();
            }
            finally {
                this.deliveryRequestLock.unlock();
            }
        }
    }
}

