/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.auth.api;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.core.lib.types.Status;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.desktop.util.ModelBusDesktopUtil;

public class LoginView
extends ViewPart
implements Observer {
    public static final String ID = "org.modelbus.desktop.loginview";
    private static final String DEFAULT_USERNAME_VALUE = "username";
    private static final String DEFAULT_PASSWORD_VALUE = "password";
    private static Color BG_COLOR = null;
    private Button loginButton;
    private Text passwordInput;
    private Text usernameInput;
    private Composite mainComposite;
    private Composite loginComposite;
    private Composite statusComposite;
    private Composite parent;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        BG_COLOR = new Color((Device)parent.getDisplay(), 249, 249, 249);
        this.parent.setBackground(BG_COLOR);
        parent.setLayout((Layout)new GridLayout(1, false));
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setBackground(BG_COLOR);
        GridLayout mainCompositeLayout = new GridLayout();
        mainCompositeLayout.horizontalSpacing = 0;
        mainCompositeLayout.marginWidth = 0;
        mainCompositeLayout.marginHeight = 0;
        this.mainComposite.setLayout((Layout)mainCompositeLayout);
        this.mainComposite.setLayoutData((Object)new GridData(131072, 1024, true, true, 1, 1));
        ModelBusDesktopUtil.getInstance().getStatus().addObserver(this, true);
        this.updateControls();
    }

    public void setFocus() {
    }

    private void updateControls() {
        if (this.parent == null) {
            return;
        }
        final Display display = this.parent.getDisplay();
        Runnable bgRunnable = new Runnable(){

            @Override
            public void run() {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!LoginView.this.mainComposite.isDisposed()) {
                            GridData loginCompositeLayoutData = new GridData(131072, 4, true, false, 1, 1);
                            GridData inputLayoutData = new GridData();
                            inputLayoutData.widthHint = 100;
                            if (LoginView.this.statusComposite != null && !LoginView.this.statusComposite.isDisposed()) {
                                LoginView.this.statusComposite.dispose();
                            }
                            if (LoginView.this.loginComposite != null && !LoginView.this.loginComposite.isDisposed()) {
                                LoginView.this.loginComposite.dispose();
                            }
                            if (UserSessionHelper.getInstance().getSession() != null) {
                                LoginView.this.statusComposite = new Composite(LoginView.this.mainComposite, 0);
                                LoginView.this.statusComposite.setBackground(BG_COLOR);
                                LoginView.this.statusComposite.setLayout((Layout)new GridLayout(2, false));
                                LoginView.this.statusComposite.setLayoutData((Object)loginCompositeLayoutData);
                                Label statusLabel = new Label(LoginView.this.statusComposite, 0);
                                statusLabel.setBackground(BG_COLOR);
                                statusLabel.setText("Logged in as: " + UserSessionHelper.getInstance().getUsername());
                                Link logoutLink = new Link(LoginView.this.statusComposite, 0);
                                logoutLink.setText("<a>Logout</a>");
                                logoutLink.addMouseListener((MouseListener)new MouseAdapter(){

                                    public void mouseUp(MouseEvent e) {
                                        UserSessionHelper.getInstance().destroySession();
                                        LoginView.this.updateControls();
                                    }
                                });
                            } else {
                                LoginView.this.loginComposite = new Composite(LoginView.this.mainComposite, 0);
                                LoginView.this.loginComposite.setBackground(BG_COLOR);
                                GridLayout loginCompositeLayout = new GridLayout(3, false);
                                LoginView.this.loginComposite.setLayout((Layout)loginCompositeLayout);
                                LoginView.this.loginComposite.setLayoutData((Object)loginCompositeLayoutData);
                                LoginView.this.usernameInput = new Text(LoginView.this.loginComposite, 2048);
                                LoginView.this.usernameInput.setText(LoginView.DEFAULT_USERNAME_VALUE);
                                LoginView.this.usernameInput.setLayoutData((Object)inputLayoutData);
                                LoginView.this.usernameInput.addFocusListener((FocusListener)new FocusAdapter(){

                                    public void focusLost(FocusEvent evt) {
                                        if ("".equals(LoginView.this.usernameInput.getText())) {
                                            LoginView.this.usernameInput.setText(LoginView.DEFAULT_USERNAME_VALUE);
                                        }
                                    }

                                    public void focusGained(FocusEvent evt) {
                                        if (LoginView.DEFAULT_USERNAME_VALUE.equals(LoginView.this.usernameInput.getText())) {
                                            LoginView.this.usernameInput.setText("");
                                        }
                                    }
                                });
                                KeyAdapter returnAdapter = new KeyAdapter(){

                                    public void keyReleased(KeyEvent e) {
                                        boolean inputComplete;
                                        if (e.keyCode != 13) {
                                            return;
                                        }
                                        String username = LoginView.this.usernameInput.getText();
                                        String password = LoginView.this.passwordInput.getText();
                                        boolean bl = inputComplete = !"".equals(username) && !"".equals(password);
                                        if (inputComplete) {
                                            LoginView.this.doLogin();
                                        }
                                    }
                                };
                                ModifyListener modifyListener = new ModifyListener(){

                                    public void modifyText(ModifyEvent event) {
                                        String username = LoginView.this.usernameInput.getText();
                                        String password = LoginView.this.passwordInput.getText();
                                        boolean inputComplete = !"".equals(username) && !"".equals(password);
                                        LoginView.this.loginButton.setEnabled(inputComplete);
                                    }
                                };
                                LoginView.this.usernameInput.addKeyListener((KeyListener)returnAdapter);
                                LoginView.this.usernameInput.addModifyListener(modifyListener);
                                LoginView.this.passwordInput = new Text(LoginView.this.loginComposite, 0x400800);
                                LoginView.this.passwordInput.setText(LoginView.DEFAULT_PASSWORD_VALUE);
                                LoginView.this.passwordInput.setLayoutData((Object)inputLayoutData);
                                LoginView.this.passwordInput.addFocusListener((FocusListener)new FocusAdapter(){

                                    public void focusLost(FocusEvent evt) {
                                        if ("".equals(LoginView.this.passwordInput.getText())) {
                                            LoginView.this.passwordInput.setText(LoginView.DEFAULT_PASSWORD_VALUE);
                                        }
                                    }

                                    public void focusGained(FocusEvent evt) {
                                        if (LoginView.DEFAULT_PASSWORD_VALUE.equals(LoginView.this.passwordInput.getText())) {
                                            LoginView.this.passwordInput.setText("");
                                        }
                                    }
                                });
                                LoginView.this.passwordInput.addKeyListener((KeyListener)returnAdapter);
                                LoginView.this.passwordInput.addModifyListener(modifyListener);
                                LoginView.this.loginButton = new Button(LoginView.this.loginComposite, 0x1000008);
                                LoginView.this.loginButton.setText("Login");
                                LoginView.this.loginButton.setEnabled(false);
                                GridData loginButtonLayoutData = new GridData();
                                loginButtonLayoutData.heightHint = 17;
                                LoginView.this.loginButton.setLayoutData((Object)loginButtonLayoutData);
                                LoginView.this.loginButton.addMouseListener((MouseListener)new MouseAdapter(){

                                    public void mouseUp(MouseEvent evt) {
                                        LoginView.this.doLogin();
                                    }
                                });
                            }
                            LoginView.this.mainComposite.layout();
                            LoginView.this.mainComposite.getParent().layout();
                        }
                    }
                });
            }
        };
        Thread bgThread = new Thread(bgRunnable);
        bgThread.setDaemon(true);
        bgThread.start();
    }

    private void doLogin() {
        String username = this.usernameInput.getText();
        String password = this.passwordInput.getText();
        if (!"".equals(username) && !"".equals(password)) {
            this.loginButton.setEnabled(false);
            String sessionID = null;
            try {
                sessionID = ModelBusCoreLib.getRepositoryHelper().authenticate(username, password);
                if (sessionID != null) {
                    UserSessionHelper.getInstance().setUsername(username);
                    UserSessionHelper.getInstance().setPassword(password);
                    Status status = ModelBusCoreLib.getServicesHelper().getStatus(UserSessionHelper.getInstance().getSession(), true);
                    ModelBusDesktopUtil.getInstance().getStatus().setStatus(status);
                } else {
                    this.showLoginErrorMessage();
                }
            }
            catch (Exception e1) {
                this.showLoginErrorMessage();
                e1.printStackTrace();
                this.loginButton.setEnabled(true);
            }
        }
    }

    private void showLoginErrorMessage() {
        MessageDialog.openInformation((Shell)this.parent.getShell(), (String)"Login", (String)"Login failed");
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.updateControls();
    }
}

