/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.ui.model;

import com.google.common.base.Optional;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.modelbus.tools.diffmerge.ui.model.ModelElementSelectionChangedEvent;
import org.modelbus.tools.diffmerge.ui.model.ModelView;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;

class ModelViewImpl
extends CTabFolder
implements ModelView {
    private final ITreeContentProvider contentProvider;
    private final ILabelProvider labelProvider;
    private TreeViewer viewer;
    private String modelName = "Model";
    private Notifier model;
    private final ModelBusEventBus eventBus;
    private final boolean editable;

    public ModelViewImpl(Composite parent, int style, ITreeContentProvider contentProvider, ILabelProvider labelProvider, ModelBusEventBus eventBus, boolean isEditable) {
        super(parent, style);
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        this.eventBus = eventBus;
        this.editable = isEditable;
        this.init();
    }

    private void init() {
        CTabItem item = new CTabItem((CTabFolder)this, 0);
        item.setText(this.modelName);
        this.viewer = new TreeViewer((Composite)this);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Notifier element = (Notifier)selection.getFirstElement();
                if (element != null) {
                    ModelViewImpl.this.eventBus.post((Object)new ModelElementSelectionChangedEvent(element, ModelViewImpl.this.editable));
                }
            }
        });
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        item.setControl((Control)this.viewer.getTree());
        item.setData("viewer", (Object)this.viewer);
        this.setSelection(item);
    }

    protected void checkSubclass() {
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public void setModelName(String name) {
        this.modelName = name;
        this.getItem(0).setText(name);
    }

    @Override
    public Optional<ISelection> getCurrentSelection() {
        ISelection selection = this.viewer.getSelection();
        return Optional.fromNullable((Object)selection);
    }

    @Override
    public void selectElement(Object element) {
        this.viewer.setSelection((ISelection)new StructuredSelection(element));
    }

    @Override
    public Notifier getModel() {
        return this.model;
    }

    @Override
    public void setModel(Notifier model) {
        this.model = model;
        this.viewer.setAutoExpandLevel(2);
        this.viewer.setInput((Object)model);
    }

    @Override
    public void refreshView() {
        this.viewer.refresh();
    }
}

