/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.model;

import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.modelbus.tools.diffmerge.model.AbstractDiffElement;
import org.modelbus.tools.diffmerge.model.DiffModelElement;
import org.modelbus.tools.diffmerge.model.DiffSource;

class AttributeDiffElement
extends AbstractDiffElement {
    AttributeDiffElement(DiffModelElement parent, Diff diff, AbstractMerger merger, Monitor monitor) {
        super(parent, diff, merger, monitor);
    }

    public EAttribute getAffectedFeature() {
        AttributeChange diff = (AttributeChange)this.getDiff();
        return diff.getAttribute();
    }

    @Override
    public void mergeFromRightToLeft() {
        this.getMerger().copyRightToLeft(this.getDiff(), this.getMonitor());
    }

    @Override
    public void mergeFromLeftToRight() {
        this.getMerger().copyLeftToRight(this.getDiff(), this.getMonitor());
    }

    public Object getValue() {
        return ((AttributeChange)this.getDiff()).getValue();
    }

    @Override
    public String toString() {
        EAttribute attribute = this.getAffectedFeature();
        String attributeName = attribute.getName();
        StringBuilder result = new StringBuilder(attributeName);
        switch (this.getKind()) {
            case Add: {
                result.append(" was added");
                break;
            }
            case Remove: {
                result.append(" was removed");
            }
            case Change: {
                EObject leftElement = this.getLeftElement();
                EObject rightElement = this.getRightElement();
                Object leftValue = leftElement.eGet((EStructuralFeature)attribute);
                Object rightValue = rightElement.eGet((EStructuralFeature)attribute);
                if (this.getSource() == DiffSource.Right) {
                    result.append(" changed from ").append(leftValue.toString()).append(" to ").append(rightValue.toString());
                    break;
                }
                result.append(" changed from ").append(rightValue.toString()).append(" to ").append(leftValue.toString());
                break;
            }
            default: {
                result.append(" moved");
            }
        }
        return result.toString();
    }
}

