/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.auth;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.core.lib.types.Status;
import org.modelbus.desktop.Activator;
import org.modelbus.desktop.auth.LoginDialog;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.desktop.util.ModelBusDesktopUtil;

public class LoginLogoutAction
extends Action
implements Observer {
    private Shell shell;
    private static final long serialVersionUID = -4429689824378634254L;

    public LoginLogoutAction(Shell shell) {
        super("Login", Activator.getImageDescriptor("icons/login.gif"));
        this.setId("loginLogout");
        ModelBusDesktopUtil.getInstance().getStatus().addObserver(this, true);
    }

    public void run() {
        if (UserSessionHelper.getInstance().getSession() != null) {
            UserSessionHelper.getInstance().destroySession();
            this.updateLabel();
            return;
        }
        LoginDialog loginDialog = new LoginDialog(this.shell);
        int loginStatus = loginDialog.open();
        if (loginStatus == 0) {
            String username = loginDialog.getUsername();
            String password = loginDialog.getPassword();
            String sessionID = null;
            try {
                sessionID = ModelBusCoreLib.getRepositoryHelper().authenticate(username, password);
                if (sessionID != null) {
                    UserSessionHelper.getInstance().setUsername(username);
                    UserSessionHelper.getInstance().setPassword(password);
                    Status status = ModelBusCoreLib.getServicesHelper().getStatus(UserSessionHelper.getInstance().getSession(), true);
                    ModelBusDesktopUtil.getInstance().getStatus().setStatus(status);
                    this.updateLabel();
                } else {
                    MessageDialog.openInformation((Shell)this.shell, (String)"Login", (String)"Login failed");
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                MessageDialog.openInformation((Shell)this.shell, (String)"Login Error", (String)e1.getMessage());
            }
        }
    }

    protected void updateLabel() {
        if (UserSessionHelper.getInstance().getSession() == null) {
            this.setText("Login");
            this.setToolTipText("ModelBus Manager Login");
        } else {
            this.setText("Logout");
            this.setToolTipText("Close current session (User: " + UserSessionHelper.getInstance().getUsername() + ")");
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateLabel();
    }
}

