/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.project;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.desktop.project.NewProjectWizardPage;
import org.modelbus.desktop.project.ProjectSetupTemplateFactory;
import org.modelbus.desktop.project.api.IProjectSetup;
import org.modelbus.dosgi.repository.descriptor.Session;

public class NewProjectWizard
extends Wizard
implements INewWizard {
    private static final String ERROR_MESSAGE = "Project could not be created. Reason: ";
    private NewProjectWizardPage mainpage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.mainpage = new NewProjectWizardPage("New Project");
        this.addPage((IWizardPage)this.mainpage);
    }

    public boolean performFinish() {
        String projectName = this.mainpage.getProjectName();
        if (projectName == null || "".equals(projectName)) {
            return false;
        }
        String templateName = this.mainpage.getProjectTemplateName();
        IProjectSetup template = ProjectSetupTemplateFactory.getInstance().getProjectSetupTemplate(templateName);
        if (template == null) {
            return false;
        }
        Session session = UserSessionHelper.getInstance().getSession();
        if (session == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Project could not be created. Reason: Login required");
            return false;
        }
        return template.createProject(this.getShell(), projectName);
    }
}

