/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.status;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.modelbus.core.lib.types.Status;
import org.modelbus.dosgi.repository.descriptor.ServiceStatus;

public class ModelBusStatusProvider
extends Observable {
    public static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(2, 2);
    private boolean available = false;
    private String repositoryLocation;
    private long repositoryStartup;
    private List<ServiceStatus> services = new ArrayList<ServiceStatus>();
    private long lastResponse;
    private String statusMessage;
    private List<Observer> notifyEachObservers = new ArrayList<Observer>();

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        boolean availableOld = this.available;
        this.available = available;
        if (!available) {
            this.reset();
        }
        this.fireChange(availableOld ^ this.available);
    }

    private void reset() {
        this.repositoryLocation = null;
        this.repositoryStartup = -1L;
        this.services.clear();
    }

    @Override
    public synchronized void addObserver(Observer o) {
        this.addObserver(o, false);
    }

    public synchronized void addObserver(Observer o, boolean notifyAvChangeOnly) {
        super.addObserver(o);
        if (!notifyAvChangeOnly) {
            this.notifyEachObservers.add(o);
        }
    }

    private void fireChange(boolean availbilityChanged) {
        this.setChanged();
        if (availbilityChanged) {
            this.notifyObservers();
        } else {
            for (Observer o : this.notifyEachObservers) {
                o.update(this, null);
            }
        }
        this.clearChanged();
    }

    public String getRepositoryLocation() {
        return this.repositoryLocation;
    }

    private void setRepositoryLocation(String repositoryLocation) {
        this.repositoryLocation = repositoryLocation;
    }

    public long getRepositoryStartup() {
        return this.repositoryStartup;
    }

    public void setRepositoryStartup(long repositoryStartup) {
        this.repositoryStartup = repositoryStartup;
    }

    public List<ServiceStatus> getServices() {
        return this.services;
    }

    private void setServices(List<ServiceStatus> services) {
        if (services != null) {
            this.services = services;
        } else {
            this.services.clear();
        }
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    private void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public void registerException(Exception exc) {
        this.setStatusMessage(exc.getMessage());
    }

    public void setStatus(Status status) {
        if (status == null) {
            this.reset();
            return;
        }
        this.setRepositoryLocation(status.getLocation());
        this.setRepositoryStartup(status.getStartupDate().toGregorianCalendar().getTimeInMillis());
        this.setServices(status.getServiceStatus());
        this.lastResponse = new Date().getTime();
        this.setAvailable(true);
    }

    public long getLastResponse() {
        return this.lastResponse;
    }
}

