/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.modelbus.services.repository.server.IModelBusSession;
import org.modelbus.services.repository.server.common.AbstractModelBusRepository;

public class ModelBusURIHandler
extends URIHandlerImpl {
    private final AbstractModelBusRepository repository;
    private final IModelBusSession session;

    public ModelBusURIHandler(AbstractModelBusRepository repository, IModelBusSession session) {
        this.repository = repository;
        this.session = session;
    }

    public boolean canHandle(URI uri) {
        if (uri.isPlatform()) {
            return false;
        }
        return this.exists(uri, null);
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        try {
            return this.repository.exists(this.session, uri, "-1");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.repository.checkOutFile(this.session, uri, "-1", new HashMap<String, Object>(), output);
            return new ByteArrayInputStream(output.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        return new ByteArrayOutputStream();
    }

    public void delete(URI uri, Map<?, ?> options) {
        try {
            this.repository.delete(this.session, uri, "TODO message", "-1");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

