/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.match;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.util.Collection;
import org.eclipse.emf.compare.match.DefaultComparisonFactory;
import org.eclipse.emf.compare.match.DefaultEqualityHelperFactory;
import org.eclipse.emf.compare.match.DefaultMatchEngine;
import org.eclipse.emf.compare.match.IComparisonFactory;
import org.eclipse.emf.compare.match.IEqualityHelperFactory;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.IdentifierEObjectMatcher;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryRegistryImpl;
import org.eclipse.emf.compare.utils.UseIdentifiers;
import org.eclipse.emf.ecore.EObject;
import org.modelbus.tools.diffmerge.config.DiffMergeConfigUpdateEvent;
import org.modelbus.tools.diffmerge.match.MatchEngineFactoryProvider;
import org.modelbus.tools.diffmerge.match.Matcher;
import org.modelbus.tools.diffmerge.model.identifier.ModelIdentifier;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.Handler;

class MatcherImpl
implements Matcher {
    private UseIdentifiers objectIdentifier = UseIdentifiers.WHEN_AVAILABLE;
    private final int priority;
    private final ModelIdentifier supporter;
    private final MatchEngineFactoryProvider provider;

    MatcherImpl(int priority, ModelIdentifier supporter, MatchEngineFactoryProvider provider) {
        this.priority = priority;
        this.provider = provider;
        this.supporter = supporter;
    }

    @Override
    public IMatchEngine.Factory.Registry getMatchEngineFactoryRegistry() {
        IEObjectMatcher matcher;
        IMatchEngine.Factory.Registry matchEngineRegistry = MatchEngineFactoryRegistryImpl.createStandaloneInstance();
        Function<EObject, String> idFunction = this.getIDFunction();
        IEObjectMatcher fallBackMatcher = DefaultMatchEngine.createDefaultEObjectMatcher((UseIdentifiers)this.objectIdentifier);
        switch (this.objectIdentifier) {
            case NEVER: {
                matcher = DefaultMatchEngine.createDefaultEObjectMatcher((UseIdentifiers)UseIdentifiers.NEVER);
                break;
            }
            default: {
                matcher = new IdentifierEObjectMatcher(fallBackMatcher, idFunction);
            }
        }
        DefaultComparisonFactory comparisonFactory = new DefaultComparisonFactory((IEqualityHelperFactory)new DefaultEqualityHelperFactory());
        IMatchEngine.Factory matchEngineFactory = this.provider.create(matcher, (IComparisonFactory)comparisonFactory);
        matchEngineFactory.setRanking(this.getPriority());
        matchEngineRegistry.add(matchEngineFactory);
        return matchEngineRegistry;
    }

    private Function<EObject, String> getIDFunction() {
        Function<EObject, String> idFunction = new Function<EObject, String>(){

            public String apply(EObject input) {
                return MatcherImpl.this.supporter.getID(input);
            }
        };
        return idFunction;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Handler
    public void diffMergeConfifgUpdateEventHandler(DiffMergeConfigUpdateEvent event) {
        switch (event.getMode()) {
            case ID: {
                this.objectIdentifier = UseIdentifiers.WHEN_AVAILABLE;
                break;
            }
            case STRUCTURE: {
                this.objectIdentifier = UseIdentifiers.NEVER;
                break;
            }
        }
    }

    public Collection<Object> getAllEventHandlers() {
        return Sets.newHashSet((Object[])new Object[]{this});
    }

    public ModelBusEventBus getEventBus() {
        throw new UnsupportedOperationException();
    }

    public void setEventBus(ModelBusEventBus eventBus) {
        throw new UnsupportedOperationException();
    }
}

