/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.dosgi.repository.service;

import org.modelbus.core.lib.configuration.ModelBusServiceConfiguration;
import org.modelbus.core.lib.util.LocationsUtilFactory;
import org.modelbus.dosgi.repository.descriptor.RepositoryService;
import org.modelbus.dosgi.repository.service.DefaultModelBusSessionFactory;
import org.modelbus.dosgi.repository.service.RepositoryServiceImpl;
import org.modelbus.dosgi.repository.service.api.ModelBusServiceListenerManager;
import org.modelbus.dosgi.services.api.AbstractModelBusServiceActivator;
import org.modelbus.services.repository.server.IModelBusRepository;
import org.modelbus.services.repository.server.common.ModelBusRepositoryFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends AbstractModelBusServiceActivator {
    private ServiceTracker<RepositoryService, RepositoryService> repositoryTracker;
    private boolean serviceAvailbilityNotified = false;
    private static Activator INSTANCE = null;

    static Activator getInstance() {
        return INSTANCE;
    }

    public void start(BundleContext bc) throws Exception {
        super.start(bc);
        INSTANCE = this;
        this.repositoryTracker = new ServiceTracker<RepositoryService, RepositoryService>(bc, RepositoryService.class, null){

            public RepositoryService addingService(ServiceReference<RepositoryService> reference) {
                RepositoryService svc = (RepositoryService)super.addingService(reference);
                if (svc instanceof RepositoryService && !Activator.this.serviceAvailbilityNotified) {
                    System.out.println("--------------------------");
                    System.out.println("ModelBus is up and running");
                    ModelBusServiceListenerManager.getInstance().notifyListeners();
                    Activator.this.serviceAvailbilityNotified = true;
                }
                return svc;
            }

            public void removedService(ServiceReference<RepositoryService> reference, RepositoryService service) {
                super.removedService(reference, (Object)service);
            }
        };
        this.repositoryTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        INSTANCE = null;
        if (this.repositoryTracker != null) {
            this.repositoryTracker.close();
        }
    }

    protected void configure(ModelBusServiceConfiguration config) {
        String repoLocation = LocationsUtilFactory.getInstance().getLocationsUtil().getRepositoryLocation(true);
        if (repoLocation == null) {
            throw new RuntimeException("Option for ModelBus repository location is not set.");
        }
        String context = repoLocation.substring(repoLocation.lastIndexOf(47));
        config.setOption("osgiServiceContext", (Object)context);
        config.unsetOption("serviceAddress");
        config.setOption("databinding", (Object)"jaxb");
    }

    protected Object createServiceInstance() {
        IModelBusRepository modelBusRepository = ModelBusRepositoryFactory.createModelBusRepository();
        if (modelBusRepository == null) {
            throw new RuntimeException("No Modelbus repository implementation available. Check configuration.");
        }
        DefaultModelBusSessionFactory modelBusSessionFactory = new DefaultModelBusSessionFactory();
        RepositoryServiceImpl service = new RepositoryServiceImpl(modelBusRepository, modelBusSessionFactory);
        return service;
    }

    public Class<?> getServiceInterface() {
        return RepositoryService.class;
    }
}

