/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.core.lib.notification;

import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.util.ByteSequence;
import org.modelbus.core.lib.notification.ModelbusNotificationPingThread;
import org.modelbus.core.lib.notification.NotificationListenerManager;
import org.modelbus.core.lib.notification.NotificationLocationStatus;
import org.modelbus.core.lib.util.LocationsUtilFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ModelBusTopicListener
implements MessageListener {
    public static final String NOTIFICATION_MODE_CREATE = "create";
    public static final String NOTIFICATION_MODE_DELETE = "delete";
    public static final String NOTIFICATION_MODE_UPDATE = "update";
    private Connection connection;
    private MessageProducer producer;
    private Session session;
    private int count;
    private long start;
    private Topic repositoryNotificationTopic;
    private Topic repositoryNotificationControl;
    private Topic repositoryChangeModelNotificationTopic;
    private String url;
    private static ModelBusTopicListener topicListener = null;
    private volatile boolean isModelbusTopicListenerRunning = false;
    private Thread runTopicListener;
    private boolean isModelbusTopicListenerThreadRunning;
    private static String notificationLocation;
    private final ModelbusNotificationPingThread modelbusNotificationPingThread;
    private static final XPathExpression bodyContentExpr;

    static {
        XPathFactory xFactory = XPathFactory.newInstance();
        XPath xPath = xFactory.newXPath();
        try {
            bodyContentExpr = xPath.compile("/Envelope/Body/*[1]");
        }
        catch (XPathExpressionException exc) {
            throw new RuntimeException(exc);
        }
    }

    private ModelBusTopicListener(String url) {
        this.url = url;
        this.modelbusNotificationPingThread = new ModelbusNotificationPingThread(20000L);
        this.modelbusNotificationPingThread.start();
    }

    public static ModelBusTopicListener getTopicListener() {
        if (topicListener == null) {
            try {
                notificationLocation = LocationsUtilFactory.getInstance().getLocationsUtil().getNotificationLocation();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            topicListener = new ModelBusTopicListener("failover://(" + notificationLocation + ")?initialReconnectDelay=10000");
        }
        return topicListener;
    }

    public synchronized void startModelbusTopicListener() {
        final NotificationLocationStatus notificationLocationStatus = NotificationListenerManager.getNotificationListenerManager().getNotificationLocationStatus();
        if (this.runTopicListener == null) {
            this.runTopicListener = new Thread("ModelbusTopicListener"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (!notificationLocationStatus.isAvailable() && ModelBusTopicListener.this.isModelbusTopicListenerThreadRunning) {
                            try {
                                Thread thread = ModelBusTopicListener.this.runTopicListener;
                                synchronized (thread) {
                                    ModelBusTopicListener.this.runTopicListener.wait(20000L);
                                }
                            }
                            catch (InterruptedException exc) {
                                throw new RuntimeException(exc);
                            }
                        }
                        topicListener.run(notificationLocationStatus);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ModelBusTopicListener.this.isModelbusTopicListenerThreadRunning = false;
                    }
                }
            };
        }
        if (!this.isModelbusTopicListenerThreadRunning) {
            this.runTopicListener.start();
            this.isModelbusTopicListenerThreadRunning = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopModelbusTopicListener() throws JMSException {
        this.isModelbusTopicListenerRunning = false;
        this.isModelbusTopicListenerThreadRunning = false;
        this.modelbusNotificationPingThread.kill();
        Thread thread = this.runTopicListener;
        synchronized (thread) {
            this.runTopicListener.notify();
        }
        topicListener = null;
    }

    public boolean isModelbusTopicListenerThreadRunning() {
        return this.isModelbusTopicListenerThreadRunning;
    }

    public boolean isModelbusTopicListenerRunning() {
        return this.isModelbusTopicListenerRunning;
    }

    public void run(NotificationLocationStatus notificationLocationStatus) throws JMSException {
        if (!this.isModelbusTopicListenerRunning && notificationLocationStatus != null && notificationLocationStatus.isAvailable() && notificationLocation != null) {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.url);
            this.connection = factory.createConnection();
            this.session = this.connection.createSession(false, 1);
            this.repositoryNotificationTopic = this.session.createTopic("RepositoryNotification");
            this.repositoryNotificationControl = this.session.createTopic("RepositoryNotificationControl");
            this.repositoryChangeModelNotificationTopic = this.session.createTopic("RepositoryChangeModelNotification");
            MessageConsumer repositoryNotificationConsumer = this.session.createConsumer((Destination)this.repositoryNotificationTopic);
            repositoryNotificationConsumer.setMessageListener((MessageListener)this);
            MessageConsumer repositoryChangeModelNotificationConsumer = this.session.createConsumer((Destination)this.repositoryChangeModelNotificationTopic);
            repositoryChangeModelNotificationConsumer.setMessageListener((MessageListener)this);
            this.connection.start();
            this.producer = this.session.createProducer((Destination)this.repositoryNotificationControl);
            this.isModelbusTopicListenerRunning = true;
        }
    }

    private static boolean checkText(Message m, String s) {
        try {
            return m instanceof TextMessage && ((TextMessage)m).getText().equals(s);
        }
        catch (JMSException e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public void onMessage(Message message) {
        try {
            NotificationListenerManager nManager;
            Document doc;
            String content = "";
            if (message instanceof ActiveMQTextMessage) {
                content = ((ActiveMQTextMessage)message).getText();
            } else if (message instanceof ActiveMQBytesMessage) {
                ByteSequence sequence = ((ActiveMQBytesMessage)message).getContent();
                content = new String(sequence.getData(), StandardCharsets.UTF_8);
            }
            String changeModelContent = null;
            int start = content.indexOf("<?xml");
            int end = content.lastIndexOf(62);
            if (start != -1 && end != -1) {
                changeModelContent = content.substring(start, end + 1);
            }
            if (changeModelContent != null) {
                start = content.indexOf("<soap:Envelope");
                end = content.indexOf("</soap:Envelope>");
                content = content.substring(start, end + 16);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                StringReader reader = new StringReader(content);
                doc = builder.parse(new InputSource(reader));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Object result = null;
            try {
                result = bodyContentExpr.evaluate(doc, XPathConstants.NODE);
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
            Element messageElement = (Element)result;
            String nodeName = messageElement.getNodeName();
            NodeList children = messageElement.getChildNodes();
            String modelUri = null;
            String sessionID = null;
            String username = null;
            String modelLocation = null;
            String messageID = null;
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                String currentNodeName = child.getNodeName();
                if ("modelUri".equals(currentNodeName)) {
                    modelUri = child.getTextContent();
                } else if ("userName".equals(currentNodeName)) {
                    username = child.getTextContent();
                } else if ("sessionID".equals(currentNodeName)) {
                    sessionID = child.getTextContent();
                } else if ("modelLocation".equals(currentNodeName)) {
                    modelLocation = child.getTextContent();
                } else if ("messageID".equals(currentNodeName)) {
                    messageID = child.getTextContent();
                }
                ++i;
            }
            if (modelUri == null || modelUri.isEmpty()) {
                modelUri = "n/a";
            }
            if (username == null || username.isEmpty()) {
                username = "n/a";
            }
            if (sessionID == null || sessionID.isEmpty()) {
                sessionID = "n/a";
            }
            if ((nManager = NotificationListenerManager.getNotificationListenerManager()) != null) {
                if (nodeName.contains("updateModel")) {
                    nManager.notify(modelUri, NOTIFICATION_MODE_UPDATE, username, sessionID);
                } else if (nodeName.contains("deleteModel")) {
                    nManager.notify(modelUri, NOTIFICATION_MODE_DELETE, username, sessionID);
                } else if (nodeName.contains("createModel")) {
                    nManager.notify(modelUri, NOTIFICATION_MODE_CREATE, username, sessionID);
                } else if (nodeName.contains("commitChangeModel") && messageID != null && modelLocation != null && changeModelContent != null) {
                    nManager.notifyChangeModelNotificationListener(modelLocation, messageID, changeModelContent);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (ModelBusTopicListener.checkText(message, "SHUTDOWN")) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        } else if (ModelBusTopicListener.checkText(message, "REPORT")) {
            try {
                long time = System.currentTimeMillis() - this.start;
                String msg = "Received " + this.count + " in " + time + "ms";
                this.producer.send((Message)this.session.createTextMessage(msg));
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            this.count = 0;
        } else {
            if (this.count == 0) {
                this.start = System.currentTimeMillis();
            }
            if (++this.count % 1000 == 0) {
                System.out.println("Received " + this.count + " messages.");
            }
        }
    }

    public void setUrl(String url) {
        if (!url.startsWith("failover")) {
            url = "failover://(" + url + ")?initialReconnectDelay=10000";
        }
        notificationLocation = this.url = url;
    }
}

