/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.postprocessor;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.internal.postprocessor.factories.IChangeFactory;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.uml2.internal.UMLCompareMessages;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.emf.compare.uml2.internal.postprocessor.extension.UMLExtensionFactoryRegistry;
import org.eclipse.emf.compare.uml2.internal.postprocessor.util.UMLCompareUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ProfileApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLPostProcessor
implements IPostProcessor {
    private static final Predicate<Match> ANNOTATION_REFERENCING_PROFILE_DEFINITION = new Predicate<Match>(){
        private Pattern umlNsPattern = Pattern.compile("http://www\\.eclipse\\.org/uml2/.*/UML");

        public boolean apply(Match input) {
            return input.getLeft() instanceof EAnnotation && this.umlNsPattern.matcher(((EAnnotation)input.getLeft()).getSource()).matches();
        }
    };
    private Set<IChangeFactory> uml2ExtensionFactories;

    public void postMatch(Comparison comparison, Monitor monitor) {
        boolean isSameProfileVersion = true;
        Iterator matchesRoot = comparison.getMatches().iterator();
        while (matchesRoot.hasNext() && isSameProfileVersion) {
            Match matchRoot = (Match)matchesRoot.next();
            isSameProfileVersion = this.checkProfileVersion(matchRoot);
            Iterator matches = matchRoot.getAllSubmatches().iterator();
            while (matches.hasNext() && isSameProfileVersion) {
                Match match = (Match)matches.next();
                isSameProfileVersion = this.checkProfileVersion(match);
            }
        }
    }

    private boolean checkProfileVersion(Match match) {
        EObject left = match.getLeft();
        EObject right = match.getRight();
        if (left instanceof ProfileApplication && right != null) {
            Collection annotationsMatches = Collections2.filter((Collection)match.getSubmatches(), ANNOTATION_REFERENCING_PROFILE_DEFINITION);
            for (Match annotationMatch : annotationsMatches) {
                EAnnotation leftAnnot = (EAnnotation)annotationMatch.getLeft();
                EAnnotation rightAnnot = (EAnnotation)annotationMatch.getRight();
                if (this.checkProfileVersion(match.getComparison(), (ProfileApplication)left, leftAnnot, rightAnnot)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkProfileVersion(Comparison comparison, ProfileApplication profileApplication, EAnnotation leftAnnot, EAnnotation rightAnnot) {
        Collection<URI> leftUris = this.getURIs(ReferenceUtil.getAsList((EObject)leftAnnot, (EStructuralFeature)EcorePackage.Literals.EANNOTATION__REFERENCES));
        Collection<URI> rightUris = this.getURIs(ReferenceUtil.getAsList((EObject)rightAnnot, (EStructuralFeature)EcorePackage.Literals.EANNOTATION__REFERENCES));
        if (leftUris.size() != rightUris.size() || !leftUris.containsAll(rightUris)) {
            Package impactedPackage = profileApplication.getApplyingPackage();
            String message = impactedPackage != null ? UMLCompareMessages.getString("profile.definition.changed.on", "<" + impactedPackage.eClass().getName() + "> " + impactedPackage.getName()) : UMLCompareMessages.getString("profile.definition.changed");
            this.addDiagnostic(comparison, (Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.compare.diff.uml", 0, message, new Object[0]));
            return false;
        }
        return true;
    }

    private void addDiagnostic(Comparison comparison, Diagnostic diagnostic) {
        Diagnostic currentDiag = comparison.getDiagnostic();
        if (currentDiag == null) {
            comparison.setDiagnostic((Diagnostic)new BasicDiagnostic("org.eclipse.emf.compare.diff.uml", 0, null, new Object[0]));
        }
        ((BasicDiagnostic)comparison.getDiagnostic()).add(diagnostic);
    }

    private Collection<URI> getURIs(List<Object> eObjects) {
        Function<Object, URI> eObjectToURI = new Function<Object, URI>(){

            public URI apply(Object input) {
                if (input instanceof EObject) {
                    return EcoreUtil.getURI((EObject)((EObject)input));
                }
                return null;
            }
        };
        return Collections2.transform(eObjects, (Function)eObjectToURI);
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postComparison(Comparison comparison, Monitor monitor) {
        Map<Class<? extends Diff>, IChangeFactory> mapUml2ExtensionFactories = UMLExtensionFactoryRegistry.createExtensionFactories();
        this.uml2ExtensionFactories = new LinkedHashSet<IChangeFactory>(mapUml2ExtensionFactories.values());
        for (Diff diff : comparison.getDifferences()) {
            this.applyManagedTypes(diff);
        }
        for (Diff umlDiff : comparison.getDifferences()) {
            Class classDiffElement;
            IChangeFactory diffFactory;
            if (!(umlDiff instanceof UMLDiff) || (diffFactory = mapUml2ExtensionFactories.get(classDiffElement = umlDiff.eClass().getInstanceClass())) == null) continue;
            diffFactory.fillRequiredDifferences(comparison, umlDiff);
        }
        for (Diff diff : comparison.getDifferences()) {
            if (!(diff instanceof ReferenceChange)) continue;
            this.fillImplicationsWithUMLSubsets((ReferenceChange)diff);
        }
    }

    private void applyManagedTypes(Diff element) {
        for (IChangeFactory factory : this.uml2ExtensionFactories) {
            if (!factory.handles(element)) continue;
            Diff extension = factory.create(element);
            if (!extension.getRefinedBy().isEmpty()) {
                Match match = factory.getParentMatch(element);
                if (match == null) continue;
                match.getDifferences().add((Object)extension);
                continue;
            }
            extension = null;
        }
    }

    private void fillImplicationsWithUMLSubsets(ReferenceChange diff) {
        EReference reference = diff.getReference();
        for (EReference superSet : UMLCompareUtil.getNonUnionSupersetReferences(reference)) {
            Comparison comparison = diff.getMatch().getComparison();
            for (Diff superSetDiff : comparison.getDifferences((EObject)superSet)) {
                if (!(superSetDiff instanceof ReferenceChange) || ((ReferenceChange)superSetDiff).getReference() != superSet || ((ReferenceChange)superSetDiff).getValue() != diff.getValue() || ((ReferenceChange)superSetDiff).getMatch() != diff.getMatch()) continue;
                if (ComparisonUtil.isAddOrSetDiff((Diff)diff) && ComparisonUtil.isAddOrSetDiff((Diff)superSetDiff)) {
                    diff.getImplies().add((Object)superSetDiff);
                    continue;
                }
                if (!ComparisonUtil.isDeleteOrUnsetDiff((Diff)diff) || !ComparisonUtil.isDeleteOrUnsetDiff((Diff)superSetDiff)) continue;
                diff.getImpliedBy().add((Object)superSetDiff);
            }
        }
    }
}

