/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.ui.properties;

import com.google.common.collect.Sets;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.modelbus.tools.diffmerge.ui.model.ModelElementSelectionChangedEvent;
import org.modelbus.tools.diffmerge.ui.properties.EStructuralFeaturePropertyElement;
import org.modelbus.tools.diffmerge.ui.properties.PropertiesConfigEvent;
import org.modelbus.tools.diffmerge2.joint.EventBusParticipant;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.Handler;
import org.modelbus.tools.modelbusexplorer.properties.PropertyElement;
import org.modelbus.tools.modelbusexplorer.properties.PropertyViewRegistry;
import org.modelbus.tools.modelbusexplorer.properties.PropertyViewUpdateEvent;

public class PropertiesViewEventHandler
implements EventBusParticipant {
    private final ModelBusEventBus eventBus;
    private boolean editingEnabled;

    public PropertiesViewEventHandler(ModelBusEventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Handler
    public void propertiesConfigEventHandler(PropertiesConfigEvent event) {
        this.editingEnabled = event.isEditingEnabled();
    }

    @Handler
    public void modelElementSelectionChangedEventHandler(ModelElementSelectionChangedEvent event) {
        PropertyElement[] propElements = this.createPropertyElementsForSelection(event.getSelection(), event.isEdit());
        PropertyViewRegistry.instance.updatePropertyViews(new PropertyViewUpdateEvent("No Source Name", propElements));
    }

    private PropertyElement[] createPropertyElementsForSelection(Notifier selection, boolean canEdit) {
        PropertyElement[] properties;
        if (selection instanceof EObject) {
            EObject obj = (EObject)selection;
            properties = EStructuralFeaturePropertyElement.createPropertyElements(obj, canEdit && this.editingEnabled);
        } else {
            properties = new PropertyElement[]{};
        }
        return properties;
    }

    public Collection<Object> getAllEventHandlers() {
        return Sets.newHashSet((Object[])new Object[]{this});
    }

    public ModelBusEventBus getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(ModelBusEventBus eventBus) {
        throw new RuntimeException("Operation not supported");
    }
}

