/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server.common;

import java.util.ArrayList;
import java.util.Iterator;
import javax.activation.DataHandler;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.modelbus.dosgi.repository.descriptor.ConstraintViolationException;
import org.modelbus.dosgi.repository.descriptor.InvalidValueException;
import org.modelbus.dosgi.repository.descriptor.LockedException;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.RepositoryRuntimeException;
import org.modelbus.dosgi.repository.descriptor.UnresolvedReferencesException;
import org.modelbus.model.lock.Lock;
import org.modelbus.model.lock.LockFactory;
import org.modelbus.model.lock.LockModel;
import org.modelbus.model.lock.LockPackage;
import org.modelbus.services.repository.server.IModelBusRepository;
import org.modelbus.services.repository.server.IModelBusRepositoryListener;
import org.modelbus.services.repository.server.IModelBusSession;
import org.modelbus.services.repository.server.LockInfo;
import org.modelbus.services.repository.server.ModelBusNodeKind;
import org.modelbus.services.repository.server.common.AbstractManager;
import org.modelbus.services.repository.server.common.AbstractModelBusRepository;
import org.modelbus.services.repository.server.common.AccessManager;

public class LockManager
extends AbstractManager
implements IModelBusRepositoryListener {
    private final LockFactory lockFactory = LockFactory.eINSTANCE;
    private static LockModel lockModel = null;

    public LockManager(IModelBusRepository modelBusRepository) {
        super(modelBusRepository);
    }

    private LockModel createModel() {
        LockModel lockModel = this.lockFactory.createLockModel();
        return lockModel;
    }

    private LockModel loadLockModel() throws RepositoryAuthentificationException, NonExistingResourceException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, LockedException {
        Resource resource;
        boolean lockModelExists;
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        EPackage.Registry.INSTANCE.put((Object)LockPackage.eINSTANCE.getNsURI(), (Object)LockPackage.eINSTANCE);
        URI lockMMURI = URI.createURI((String)"http://www.modelbus.org/system/model/lock.ecore");
        URI modelBusLockURI = URI.createURI((String)"http://www.modelbus.org/system/model/ModelBus.lock");
        ModelBusNodeKind nodeKind = this.modelBusRepository.checkPathFileSystem(AccessManager.INTERNAL_MODEL_BUS_SESSION, modelBusLockURI, "-1");
        boolean bl = lockModelExists = nodeKind != null;
        if (!lockModelExists) {
            Resource lockResource = this.modelBusRepository.createModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, null, lockMMURI, ECLASS_URI, "internal model creation", AbstractModelBusRepository.getDefaultOptionsMap());
            lockResource.getContents().clear();
            lockResource.getContents().add((Object)LockPackage.eINSTANCE);
            this.modelBusRepository.checkInModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, lockResource, "internal model creation", AbstractModelBusRepository.getDefaultOptionsMap());
            resource = this.modelBusRepository.createModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, null, modelBusLockURI, lockMMURI.appendFragment("//LockModel"), "internal model creation", AbstractModelBusRepository.getDefaultOptionsMap());
            resource.getContents().clear();
            resource.getContents().add((Object)this.createModel());
            this.modelBusRepository.checkInModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, resource, "internal model creation", AbstractModelBusRepository.getDefaultOptionsMap());
        } else {
            resource = this.modelBusRepository.checkOutModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, modelBusLockURI);
        }
        LockModel lockModel = (LockModel)resource.getContents().get(0);
        return lockModel;
    }

    private synchronized LockModel getLockModel() throws RepositoryAuthentificationException, NonExistingResourceException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, LockedException {
        if (lockModel == null) {
            lockModel = this.loadLockModel();
        }
        return lockModel;
    }

    public void lock(URI uri, String username) throws RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, LockedException, UnresolvedReferencesException {
        LockModel lockModel;
        try {
            lockModel = this.getLockModel();
        }
        catch (NonExistingResourceException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidValueException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (ConstraintViolationException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (UnresolvedReferencesException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (LockedException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        Lock lock = this.lockFactory.createLock();
        lock.setUrl(uri.toString());
        lock.setUserName(username);
        lock.setTime(System.currentTimeMillis());
        lockModel.getLock().add((Object)lock);
        this.modelBusRepository.checkInModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, lockModel.eResource(), "internal update", AbstractModelBusRepository.getDefaultOptionsMap());
    }

    public void unlock(URI uri, String username) throws RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, LockedException, UnresolvedReferencesException {
        LockModel lockModel;
        try {
            lockModel = this.getLockModel();
        }
        catch (NonExistingResourceException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidValueException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (ConstraintViolationException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (UnresolvedReferencesException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (LockedException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        EList locks = lockModel.getLock();
        boolean changed = false;
        Iterator iterator = locks.iterator();
        while (iterator.hasNext()) {
            Lock currentLock = (Lock)iterator.next();
            if (uri == null || !uri.toString().equals(currentLock.getUrl())) continue;
            iterator.remove();
            changed = true;
        }
        if (changed) {
            this.modelBusRepository.checkInModel(AccessManager.INTERNAL_MODEL_BUS_SESSION, lockModel.eResource(), "internal update", AbstractModelBusRepository.getDefaultOptionsMap());
        }
    }

    public LockInfo[] getLockInfos() throws RepositoryAuthentificationException {
        LockModel lockModel;
        try {
            lockModel = this.getLockModel();
        }
        catch (NonExistingResourceException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidValueException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (ConstraintViolationException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (UnresolvedReferencesException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (LockedException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        EList locks = lockModel.getLock();
        LockInfo[] lockInfos = new LockInfo[locks.size()];
        int i = 0;
        Iterator iterator = locks.iterator();
        while (iterator.hasNext()) {
            Lock lock;
            Lock currentLock = lock = (Lock)iterator.next();
            lockInfos[i] = new LockInfo();
            lockInfos[i].time = currentLock.getTime();
            lockInfos[i].url = currentLock.getUrl();
            lockInfos[i].user = currentLock.getUserName();
            ++i;
        }
        return lockInfos;
    }

    public LockInfo[] getLockInfosFor(URI url) throws RepositoryAuthentificationException {
        LockModel lockModel;
        try {
            lockModel = this.getLockModel();
        }
        catch (NonExistingResourceException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidValueException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (ConstraintViolationException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (UnresolvedReferencesException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (LockedException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        EList locks = lockModel.getLock();
        ArrayList<LockInfo> lockInfos = new ArrayList<LockInfo>();
        Iterator iterator = locks.iterator();
        while (iterator.hasNext()) {
            Lock lock;
            Lock currentLock = lock = (Lock)iterator.next();
            if (!url.toString().startsWith(currentLock.getUrl())) continue;
            LockInfo lockInfo = new LockInfo();
            lockInfo.time = currentLock.getTime();
            lockInfo.url = currentLock.getUrl();
            lockInfo.user = currentLock.getUserName();
            lockInfos.add(lockInfo);
        }
        return lockInfos.toArray(new LockInfo[lockInfos.size()]);
    }

    public boolean checkCompletlyAccessibleForUser(URI url, String user) throws RepositoryAuthentificationException {
        LockInfo[] lockInfos;
        LockInfo[] lockInfoArray = lockInfos = this.getLockInfosFor(url);
        int n = lockInfos.length;
        int n2 = 0;
        while (n2 < n) {
            LockInfo lockInfo2;
            LockInfo lockInfo = lockInfo2 = lockInfoArray[n2];
            if (user.equals(lockInfo.user)) {
                return true;
            }
            if (!user.equals(lockInfo.user)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void createModel(URI modelUri, IModelBusSession session) {
    }

    @Override
    public void deleteModel(URI modelUri, IModelBusSession session) {
    }

    @Override
    public void updateModel(URI modelUri, IModelBusSession session) {
        if ("http://www.modelbus.org/system/model/ModelBus.lock".equals(modelUri.toString())) {
            lockModel = null;
        }
    }

    @Override
    public void commitChangeModelNotification(String messageID, URI modelUri, DataHandler changeModelContent) {
    }
}

