/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.modelbus.tools.diffmerge.model.DiffElement;
import org.modelbus.tools.diffmerge.model.DiffElementCollection;
import org.modelbus.tools.diffmerge.model.DiffModel;
import org.modelbus.tools.diffmerge.model.DiffModelElement;
import org.modelbus.tools.diffmerge.model.DiffModelElementImpl;
import org.modelbus.tools.diffmerge.model.collections.DiffCollection;
import org.modelbus.tools.modelbusexplorer.logging.LoggerFactory;

class DiffModelImpl
implements DiffModel {
    private final List<DiffModelElement> nodes = Lists.newLinkedList();
    private final boolean isThreeWay;
    private final Notifier left;
    private final Notifier right;
    int removeCnt = 0;

    DiffModelImpl(boolean isThreeWay, Notifier left, Notifier right) {
        this.isThreeWay = isThreeWay;
        this.left = left;
        this.right = right;
    }

    public boolean isThreeWay() {
        return this.isThreeWay;
    }

    public Optional<DiffModelElement> getParentElement() {
        return Optional.absent();
    }

    public String toString() {
        return String.format("%d change(s) found ", this.getAllDiffElements().size());
    }

    public List<DiffModelElement> getSubElements() {
        return ImmutableList.copyOf(this.nodes);
    }

    public List<DiffModelElement> getAllSubElements() {
        LinkedList result = Lists.newLinkedList();
        result.addAll(this.nodes);
        for (DiffModelElement node : this.nodes) {
            result.addAll(node.getAllSubElements());
        }
        return ImmutableList.copyOf((Collection)result);
    }

    public DiffCollection<DiffElement> getAllDiffElements() {
        DiffCollection<DiffElement> collection = DiffElementCollection.createNewCollection();
        for (DiffModelElement node : this.nodes) {
            collection.add(node.getAllDiffElements());
        }
        return collection;
    }

    public DiffCollection<DiffElement> getDiffElements() {
        return DiffElementCollection.createNewCollection();
    }

    boolean addNode(DiffModelElement node) {
        Preconditions.checkNotNull((Object)node);
        if (!this.nodes.contains(node)) {
            return this.nodes.add(node);
        }
        return false;
    }

    public EObject getLeftElement() {
        return null;
    }

    public Optional<EObject> getOriginElement() {
        return Optional.absent();
    }

    public EObject getRightElement() {
        return null;
    }

    public boolean match() {
        return this.getAllDiffElements().size() == 0;
    }

    public void removeSubElement(DiffModelElement element) {
        this.removeCnt = 0;
        for (DiffModelElement node : this.nodes) {
            this.removeElementFromSubElements(node, element);
        }
        if (1 < this.removeCnt) {
            LoggerFactory.getLogger(DiffModelElementImpl.class).warn(String.format("Element '%s' was '%d' time removed ", element.toString(), this.removeCnt));
        }
    }

    private void removeElementFromSubElements(DiffModelElement root, DiffModelElement elementToRemove) {
        for (DiffModelElement sub : root.getAllSubElements()) {
            this.removeElementFromSubElements(sub, elementToRemove);
        }
        if (root.getSubElements().contains(elementToRemove)) {
            ++this.removeCnt;
        }
        root.removeSubElement(elementToRemove);
    }

    public void removeConflictingSubElement(DiffModelElement conflictingElement) {
        List<DiffModelElement> subElements = this.getAllSubElements();
        for (DiffModelElement node : subElements) {
            node.removeConflictingSubElement(conflictingElement);
        }
    }

    public DiffCollection<DiffElement> getConflictingElements() {
        DiffCollection<DiffElement> conflicts = DiffElementCollection.createNewCollection();
        for (DiffModelElement node : this.nodes) {
            conflicts.add(node.getConflictingElements());
        }
        return conflicts;
    }

    public Notifier getLeftSide() {
        return this.left;
    }

    public Notifier getRightSide() {
        return this.right;
    }
}

