/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.ui;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.modelbus.tools.diffmerge.model.DiffElement;
import org.modelbus.tools.diffmerge.model.DiffModel;
import org.modelbus.tools.diffmerge.model.DiffModelElement;
import org.modelbus.tools.diffmerge.model.identifier.ModelIdentifier;
import org.modelbus.tools.diffmerge.ui.DiffMergeView;
import org.modelbus.tools.diffmerge.ui.DiffMergeViewException;
import org.modelbus.tools.diffmerge.ui.IconProviderQueue;
import org.modelbus.tools.diffmerge.ui.UIEventHandler;
import org.modelbus.tools.diffmerge.ui.UIListener;
import org.modelbus.tools.diffmerge.ui.UIListenerUpdateEvent;
import org.modelbus.tools.diffmerge.ui.buttonadapter.AbstractButtonSelectionAdapter;
import org.modelbus.tools.diffmerge.ui.buttonadapter.CancelButtonSelectionAdapter;
import org.modelbus.tools.diffmerge.ui.buttonadapter.CommitButtonSelectionAdatper;
import org.modelbus.tools.diffmerge.ui.buttonadapter.EventHandleCallback;
import org.modelbus.tools.diffmerge.ui.buttonadapter.ResolveButtonSelectionAdapter;
import org.modelbus.tools.diffmerge.ui.buttonadapter.UpdateButtonSelectionAdapter;
import org.modelbus.tools.diffmerge.ui.config.UIButtonUpdateEvent;
import org.modelbus.tools.diffmerge.ui.config.UIConfig;
import org.modelbus.tools.diffmerge.ui.diff.DiffModelView;
import org.modelbus.tools.diffmerge.ui.diff.SelectNextDiffElementEvent;
import org.modelbus.tools.diffmerge.ui.icon.CommonIconProvider;
import org.modelbus.tools.diffmerge.ui.icon.DiffIconsImageProvider;
import org.modelbus.tools.diffmerge.ui.icon.EcoreIconProvider;
import org.modelbus.tools.diffmerge.ui.icon.IconProvider;
import org.modelbus.tools.diffmerge.ui.model.ModelCompareView;
import org.modelbus.tools.diffmerge.ui.util.GuiHelperUtil;
import org.modelbus.tools.diffmerge2.joint.EventBusParticipant;
import org.modelbus.tools.diffmerge2.joint.event.DiffModelChangedEvent;
import org.modelbus.tools.diffmerge2.joint.event.LeftModelChangedEvent;
import org.modelbus.tools.diffmerge2.joint.event.RightModelChangedEvent;
import org.modelbus.tools.diffmerge2.joint.event.ShutDownEvent;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;
import org.modelbus.tools.modelbusexplorer.blackboard.listener.Handler;
import org.modelbus.tools.modelbusexplorer.logging.Logger;
import org.modelbus.tools.modelbusexplorer.logging.LoggerFactory;

public class DiffMergeViewImpl
extends Composite
implements DiffMergeView,
EventBusParticipant {
    private static final Logger LOG = LoggerFactory.getLogger((String)DiffMergeViewImpl.class.getName());
    private final ModelBusEventBus eventBus;
    private final UIConfig config;
    private final GuiHelperUtil guiUtil;
    private final List<Object> eventHandlers = Lists.newLinkedList();
    private final ModelIdentifier supporter;
    private Button btnCancel;
    private Button btnUpdate;
    private Button btnCommit;
    private Composite mergeAndMarkButtonContainer;
    private Composite actionButtonsContainer;
    private UpdateButtonSelectionAdapter updateButtonSelectionAdapter;
    private CommitButtonSelectionAdatper commitButtinSelectionAdatper;
    private ResolveButtonSelectionAdapter resolveButtonSelectionAdapter;
    private AbstractButtonSelectionAdapter copyLeftButtonSelectionAdapter;
    private AbstractButtonSelectionAdapter cancelButtonSelectionAdatper;
    private Button btnMarkSolved;
    private Button btnMergeLeft;
    private final UIEventHandler uiEventHandler;
    private Button btnOk;
    private final IconProviderQueue iconProvider;

    public DiffMergeViewImpl(Composite parent, int style, UIConfig config, ModelBusEventBus eventBus, GuiHelperUtil guiUtil, ModelIdentifier supporter) {
        super(parent, style);
        this.config = (UIConfig)Preconditions.checkNotNull((Object)config);
        this.eventBus = (ModelBusEventBus)Preconditions.checkNotNull((Object)eventBus);
        this.guiUtil = (GuiHelperUtil)Preconditions.checkNotNull((Object)guiUtil);
        this.supporter = (ModelIdentifier)Preconditions.checkNotNull((Object)supporter);
        this.uiEventHandler = new UIEventHandler();
        this.eventHandlers.add(this.uiEventHandler);
        this.iconProvider = new IconProviderQueue();
        this.initSelectionAdapters();
        this.initUI();
    }

    private void initSelectionAdapters() {
        final DiffMergeViewImpl view = this;
        this.updateButtonSelectionAdapter = new UpdateButtonSelectionAdapter(this.config.getConfigID(), this.eventBus, new EventHandleCallback.EventHandleCallbackImpl(){

            @Override
            public void diffMergeModeChanged(UIConfig.DiffMergeMode mode) {
                boolean enabled;
                boolean bl = enabled = !mode.equals((Object)UIConfig.DiffMergeMode.COMMIT);
                if (!DiffMergeViewImpl.this.btnUpdate.isDisposed()) {
                    DiffMergeViewImpl.this.btnUpdate.setEnabled(enabled);
                }
            }

            @Override
            public void handleSelection() {
                DiffMergeViewImpl.this.getEventBus().post((Object)new UIListenerUpdateEvent(view, UIListenerUpdateEvent.ButtonType.UPDATE));
                if (DiffMergeViewImpl.this.updateButtonSelectionAdapter.isCloseOnUpdate()) {
                    DiffMergeViewImpl.this.dispose();
                }
            }
        });
        this.commitButtinSelectionAdatper = new CommitButtonSelectionAdatper(this.config.getConfigID(), this.eventBus, new EventHandleCallback.EventHandleCallbackImpl(){

            @Override
            public void diffMergeModeChanged(UIConfig.DiffMergeMode mode) {
                boolean enabled;
                boolean bl = enabled = !mode.equals((Object)UIConfig.DiffMergeMode.UPDATE);
                if (!DiffMergeViewImpl.this.btnCommit.isDisposed()) {
                    DiffMergeViewImpl.this.btnCommit.setEnabled(enabled);
                }
            }

            @Override
            public void handleSelection() {
                DiffMergeViewImpl.this.getEventBus().post((Object)new UIListenerUpdateEvent(view, UIListenerUpdateEvent.ButtonType.COMMIT));
            }
        });
        this.resolveButtonSelectionAdapter = new ResolveButtonSelectionAdapter(this.config.getConfigID(), this.eventBus, new EventHandleCallback.EventHandleCallbackImpl(){

            @Override
            public void diffModelElementSelected(DiffModelElement element) {
                if (element instanceof DiffElement) {
                    boolean conflict = ((DiffElement)element).isConflict();
                    DiffMergeViewImpl.this.btnMergeLeft.setEnabled(!conflict);
                } else if (!DiffMergeViewImpl.this.btnMergeLeft.isDisposed()) {
                    DiffMergeViewImpl.this.btnMergeLeft.setEnabled(true);
                }
            }
        });
        this.copyLeftButtonSelectionAdapter = new UpdateButtonSelectionAdapter(this.config.getConfigID(), this.eventBus, new EventHandleCallback.EventHandleCallbackImpl(){

            @Override
            public void diffModelElementSelected(DiffModelElement element) {
                if (element instanceof DiffElement) {
                    boolean conflict = ((DiffElement)element).isConflict();
                    DiffMergeViewImpl.this.btnMergeLeft.setEnabled(!conflict);
                } else if (!DiffMergeViewImpl.this.btnMergeLeft.isDisposed()) {
                    DiffMergeViewImpl.this.btnMergeLeft.setEnabled(true);
                }
            }
        });
        this.cancelButtonSelectionAdatper = new CancelButtonSelectionAdapter(this.config.getConfigID(), this.eventBus, new EventHandleCallback.EventHandleCallbackImpl(){

            @Override
            public void widgetSelected(Button source) {
                UIListenerUpdateEvent.ButtonType button;
                LOG.debug(String.valueOf(source.getText()) + " clicked");
                if (source.equals(DiffMergeViewImpl.this.btnCancel)) {
                    button = UIListenerUpdateEvent.ButtonType.CANCEL;
                } else if (source.equals(DiffMergeViewImpl.this.btnOk)) {
                    button = UIListenerUpdateEvent.ButtonType.OK;
                } else {
                    throw new RuntimeException("Unkown button");
                }
                DiffMergeViewImpl.this.getEventBus().post((Object)new UIListenerUpdateEvent(view, button));
            }
        });
        this.eventHandlers.add(this);
        this.eventHandlers.add((Object)this.updateButtonSelectionAdapter);
        this.eventHandlers.add((Object)this.commitButtinSelectionAdatper);
        this.eventHandlers.add((Object)this.resolveButtonSelectionAdapter);
        this.eventHandlers.add((Object)this.copyLeftButtonSelectionAdapter);
        this.eventHandlers.add((Object)this.cancelButtonSelectionAdatper);
    }

    private void initUI() {
        this.initIconProviders();
        this.setLayout((Layout)new FillLayout(512));
        SashForm sashForm = new SashForm((Composite)this, 68096);
        Composite diffModelContainer = new Composite((Composite)sashForm, 0);
        diffModelContainer.setLayout((Layout)new GridLayout(1, false));
        DiffModelView diffModelView = new DiffModelView(diffModelContainer, 0, this.eventBus, this.guiUtil, this.iconProvider, this.config);
        GridData gd_diffModelView = new GridData(4, 4, true, true, 1, 1);
        gd_diffModelView.heightHint = 137;
        diffModelView.setLayoutData(gd_diffModelView);
        this.mergeAndMarkButtonContainer = new Composite(diffModelContainer, 0);
        this.mergeAndMarkButtonContainer.setBounds(0, 0, 64, 64);
        this.mergeAndMarkButtonContainer.setLayout((Layout)new FillLayout(256));
        Button btnNext = new Button(this.mergeAndMarkButtonContainer, 0);
        btnNext.setImage(this.guiUtil.getUiImage("next"));
        btnNext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiffMergeViewImpl.this.eventBus.post((Object)new SelectNextDiffElementEvent(true));
            }
        });
        Button btnPrev = new Button(this.mergeAndMarkButtonContainer, 0);
        btnPrev.setImage(this.guiUtil.getUiImage("prev"));
        btnPrev.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiffMergeViewImpl.this.eventBus.post((Object)new SelectNextDiffElementEvent(false));
            }
        });
        this.createMergeLeftButton();
        this.createMarkAsSolvedButton();
        Composite modelCompareContainer = new Composite((Composite)sashForm, 0);
        modelCompareContainer.setLayout((Layout)new GridLayout(1, false));
        ModelCompareView modelCompareView = new ModelCompareView(modelCompareContainer, 2048, this.eventBus, this.iconProvider, this.supporter);
        modelCompareView.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.actionButtonsContainer = new Composite(modelCompareContainer, 0);
        this.actionButtonsContainer.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        RowLayout rowLayout = new RowLayout();
        this.actionButtonsContainer.setLayout((Layout)rowLayout);
        this.createOkButton();
        this.createCancelButton();
        this.createCommitButton();
        this.createUpdateButton();
        this.eventHandlers.addAll(diffModelView.getAllEventHandlers());
        this.eventHandlers.addAll(modelCompareView.getAllEventHandlers());
    }

    private void initIconProviders() {
        Display display = this.getDisplay();
        this.iconProvider.addIconProivder(new DiffIconsImageProvider(display)).addIconProivder(new CommonIconProvider(display)).addIconProivder(new EcoreIconProvider(display));
    }

    private void createCommitButton() {
        if (this.actionButtonsContainer.isDisposed()) {
            return;
        }
        this.btnCommit = new Button(this.actionButtonsContainer, 0);
        this.btnCommit.setText("Commit");
        this.btnCommit.setImage(this.guiUtil.getUiImage("commit"));
        this.btnCommit.addSelectionListener((SelectionListener)this.commitButtinSelectionAdatper);
    }

    private void createUpdateButton() {
        if (this.actionButtonsContainer.isDisposed()) {
            return;
        }
        this.btnUpdate = new Button(this.actionButtonsContainer, 0);
        this.btnUpdate.setText("Update");
        this.btnUpdate.setImage(this.guiUtil.getUiImage("update"));
        this.btnUpdate.addSelectionListener((SelectionListener)this.updateButtonSelectionAdapter);
    }

    private void createCancelButton() {
        if (this.actionButtonsContainer.isDisposed()) {
            return;
        }
        this.btnCancel = new Button(this.actionButtonsContainer, 0);
        this.btnCancel.setText("Cancel");
        this.btnCancel.setImage(this.guiUtil.getUiImage("cancel"));
        this.btnCancel.addSelectionListener((SelectionListener)this.cancelButtonSelectionAdatper);
    }

    private void createOkButton() {
        if (this.actionButtonsContainer.isDisposed()) {
            return;
        }
        this.btnOk = new Button(this.actionButtonsContainer, 0);
        this.btnOk.setText("OK");
        this.btnOk.setImage(this.guiUtil.getUiImage("validate"));
        this.btnOk.addSelectionListener((SelectionListener)this.cancelButtonSelectionAdatper);
    }

    @Override
    @Deprecated
    public void addResources(Notifier left, Notifier right) {
        LOG.warn("Use of deprecated method 'addResources(...)' ");
        this.eventBus.post((Object)new LeftModelChangedEvent(left));
        this.eventBus.post((Object)new RightModelChangedEvent(right));
    }

    @Override
    @Deprecated
    public void addDiffModel(DiffModel model) {
        LOG.warn("Use of deprecated method 'addDiffModel(...) ");
        this.eventBus.post((Object)new DiffModelChangedEvent(model));
    }

    @Override
    public void open() {
        Display display;
        if (this.getParent() instanceof Shell) {
            display = this.getDisplay();
            Shell shell = (Shell)this.getParent();
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        } else {
            throw new DiffMergeViewException("Parent is not an instance of org.eclipse.swt.widgets.Shell. Please use the applications shell to open the DiffMergeView.");
        }
        display.dispose();
    }

    @Handler
    public void uiButtonUpdateEventHandler(UIButtonUpdateEvent event) {
        if (!this.config.getButtonConfig().getConfigID().equals(event.getConfigID())) {
            return;
        }
        this.handleMergeToLeftButton(event);
        this.handleMarkAsSolvedButton(event);
        this.handleOkButton(event);
        this.handleCancelButton(event);
        this.handleCommitButton(event);
        this.handleUpdateButton(event);
        this.actionButtonsContainer.layout();
    }

    private void handleMergeToLeftButton(UIButtonUpdateEvent event) {
        if (!event.isMerge()) {
            this.btnMergeLeft.dispose();
        } else if (this.buttonIsNullOrDisposed(this.btnMergeLeft)) {
            this.createMergeLeftButton();
        }
    }

    private void createMergeLeftButton() {
        this.btnMergeLeft = new Button(this.mergeAndMarkButtonContainer, 0);
        this.btnMergeLeft.setImage(this.guiUtil.getUiImage("copy_left"));
        this.btnMergeLeft.addSelectionListener((SelectionListener)this.copyLeftButtonSelectionAdapter);
    }

    private void handleMarkAsSolvedButton(UIButtonUpdateEvent event) {
        if (!event.isSolve()) {
            this.btnMarkSolved.dispose();
        } else if (this.buttonIsNullOrDisposed(this.btnMarkSolved)) {
            this.createMarkAsSolvedButton();
        }
    }

    private void createMarkAsSolvedButton() {
        this.btnMarkSolved = new Button(this.mergeAndMarkButtonContainer, 0);
        this.btnMarkSolved.setImage(this.guiUtil.getUiImage("warn"));
        this.btnMarkSolved.addSelectionListener((SelectionListener)this.resolveButtonSelectionAdapter);
        this.btnMarkSolved.setEnabled(false);
    }

    private void handleCommitButton(UIButtonUpdateEvent event) {
        if (!event.isCommit()) {
            this.btnCommit.dispose();
        } else if (this.buttonIsNullOrDisposed(this.btnCommit)) {
            this.createCommitButton();
        }
    }

    private void handleUpdateButton(UIButtonUpdateEvent event) {
        if (!event.isUpdate()) {
            this.btnUpdate.dispose();
        } else if (this.buttonIsNullOrDisposed(this.btnUpdate)) {
            this.createUpdateButton();
        }
    }

    private void handleCancelButton(UIButtonUpdateEvent event) {
        if (!event.isCancel()) {
            this.btnCancel.dispose();
        } else if (this.buttonIsNullOrDisposed(this.btnCancel)) {
            this.createCancelButton();
            this.actionButtonsContainer.layout();
        }
    }

    private void handleOkButton(UIButtonUpdateEvent event) {
        if (!event.isOk()) {
            this.btnOk.dispose();
        } else if (this.buttonIsNullOrDisposed(this.btnOk)) {
            this.createOkButton();
        }
    }

    private boolean buttonIsNullOrDisposed(Button button) {
        return button == null || button.isDisposed();
    }

    @Override
    public UIConfig getConfig() {
        return this.config;
    }

    public Collection<Object> getAllEventHandlers() {
        return this.eventHandlers;
    }

    public ModelBusEventBus getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(ModelBusEventBus eventBus) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public DiffMergeView addUIListener(UIListener listener) {
        this.uiEventHandler.addListener(listener);
        return this;
    }

    @Handler
    public void shutDownEventHandler(ShutDownEvent event) {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.eventBus.unregister(this.getAllEventHandlers());
        super.dispose();
    }

    @Override
    public DiffMergeView addIconProvider(IconProvider provider) {
        this.iconProvider.addIconProivder(provider);
        return this;
    }
}

