/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.ui.icon;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.modelbus.tools.diffmerge.ui.icon.IconProvider;
import org.modelbus.tools.modelbusexplorer.logging.Logger;
import org.modelbus.tools.modelbusexplorer.logging.LoggerFactory;

public abstract class AbstractIconProvider
implements IconProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIconProvider.class);
    private static final String DEFAULT_ICON_LOCATION = "/org/modelbus/tools/diffmerge/icons/default_icon.gif";
    private final Display display;
    private final HashMap<String, Image> iconCache = Maps.newHashMap();

    public AbstractIconProvider(Display display) {
        this.display = display;
    }

    protected Optional<InputStream> getImageAsStream(String imagePathAndName) {
        InputStream resource = this.getClass().getResourceAsStream(imagePathAndName);
        return Optional.fromNullable((Object)resource);
    }

    protected Image getDefaultImage() {
        Optional<Image> cachedIcon = this.getCachedIcon(DEFAULT_ICON_LOCATION);
        if (cachedIcon.isPresent()) {
            return (Image)cachedIcon.get();
        }
        return this.createNewDefaultIcon();
    }

    private Image createNewDefaultIcon() {
        Optional<InputStream> imageAsStream = this.getImageAsStream(DEFAULT_ICON_LOCATION);
        if (!imageAsStream.isPresent()) {
            LOG.error("Can not create default image from /org/modelbus/tools/diffmerge/icons/default_icon.gif");
            return null;
        }
        Image icon = this.createImage((InputStream)imageAsStream.get());
        this.cachIcon(DEFAULT_ICON_LOCATION, icon);
        return icon;
    }

    protected Image createImage(InputStream stream) {
        return new Image((Device)this.display, stream);
    }

    protected Image createIconForName(String iconName) {
        Optional<InputStream> stream = this.getImageAsStream(iconName);
        if (stream.isPresent()) {
            return this.createImage((InputStream)stream.get());
        }
        return this.getDefaultImage();
    }

    protected Optional<Image> getCachedIcon(String iconName) {
        if (!this.iconCache.containsKey(iconName)) {
            return Optional.absent();
        }
        Image image = this.iconCache.get(iconName);
        if (image.isDisposed()) {
            this.iconCache.remove(iconName);
            return Optional.absent();
        }
        return Optional.of((Object)image);
    }

    protected void cachIcon(String iconName, Image icon) {
        this.iconCache.put(iconName, icon);
    }
}

