/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.modelbusexplorer.properties.editing;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnViewer;
import org.modelbus.tools.modelbusexplorer.blackboard.EventBusProvider;
import org.modelbus.tools.modelbusexplorer.blackboard.ModelBusEventBus;
import org.modelbus.tools.modelbusexplorer.properties.PropertyElement;
import org.modelbus.tools.modelbusexplorer.properties.editing.EditingSupportUpdateObject;
import org.modelbus.tools.modelbusexplorer.properties.editing.IEditingSupport;
import org.modelbus.tools.modelbusexplorer.properties.editing.PropertyElementEditingSupport;
import org.modelbus.tools.modelbusexplorer.properties.editing.PropertyElementEditingSupportImpl;

public class PropertyElementEditingSupportBuilder {
    private static PropertyElementEditingSupportBuilder instance;
    private final Map<Class<? extends PropertyElement>, Class<? extends IEditingSupport>> cachedEditingSupports = new HashMap<Class<? extends PropertyElement>, Class<? extends IEditingSupport>>();
    private ModelBusEventBus eventBus;

    public static synchronized PropertyElementEditingSupportBuilder getInstance() {
        if (instance == null) {
            instance = new PropertyElementEditingSupportBuilder();
        }
        return instance;
    }

    private PropertyElementEditingSupportBuilder() {
    }

    public void setEventBus(ModelBusEventBus eventBus) {
        this.eventBus = eventBus;
    }

    public PropertyElementEditingSupport createNewEditingSupport(ColumnViewer viewer) {
        if (this.eventBus == null) {
            this.setEventBus(EventBusProvider.getRunningEventBusInstance());
        }
        PropertyElementEditingSupportImpl editingSupport = new PropertyElementEditingSupportImpl(viewer, this.eventBus);
        this.eventBus.register((Object)editingSupport);
        for (Class<? extends PropertyElement> key : this.cachedEditingSupports.keySet()) {
            Class<? extends IEditingSupport> clazz = this.cachedEditingSupports.get(key);
            this.eventBus.post((Object)new EditingSupportUpdateObject(key, clazz));
        }
        return editingSupport;
    }

    public void registerNewEditingSupport(Class<? extends PropertyElement> propertyElement, Class<? extends IEditingSupport> editingSupport) {
        if (this.eventBus == null) {
            this.setEventBus(EventBusProvider.getRunningEventBusInstance());
        }
        if (this.cachedEditingSupports.containsKey(propertyElement)) {
            return;
        }
        this.cachedEditingSupports.put(propertyElement, editingSupport);
        this.eventBus.post((Object)new EditingSupportUpdateObject(propertyElement, editingSupport));
    }

    public void unregisterEditingSupport(IEditingSupport support) {
        throw new RuntimeException("Not implemented");
    }

    public Map<Class<? extends PropertyElement>, Class<? extends IEditingSupport>> getRegisteredEditingSupports() {
        return this.cachedEditingSupports;
    }
}

