/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.controller.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelbus.tools.diffmerge.DiffMergeListener;
import org.modelbus.tools.diffmerge.IDiffMerge;
import org.modelbus.tools.diffmerge.IDiffMergeListener;
import org.modelbus.tools.diffmerge.config.IDiffMergeConfig;
import org.modelbus.tools.diffmerge.controller.IDiffMergeController;
import org.modelbus.tools.diffmerge.controller.impl.DiffMergeListenerWrapper;
import org.modelbus.tools.diffmerge.engine.DiffMergeChangeListener;
import org.modelbus.tools.diffmerge.engine.DiffMergeEngine;
import org.modelbus.tools.diffmerge.filter.IDiffModelFilter;
import org.modelbus.tools.diffmerge.model.DiffModel;
import org.modelbus.tools.diffmerge.resources.ResourceContainer;
import org.modelbus.tools.diffmerge.synchronize.SynchronizeMode;
import org.modelbus.tools.diffmerge.ui.DiffMergeView;
import org.modelbus.tools.modelbusexplorer.logging.Logger;
import org.modelbus.tools.modelbusexplorer.logging.LoggerFactory;

public class DiffMergeControllerImpl
implements IDiffMergeController,
DiffMergeChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(DiffMergeControllerImpl.class);
    private final IDiffMerge diffMerge;
    private final IDiffModelFilter filter;
    private final DiffMergeListenerWrapper listenerWrapper;
    private DiffModel model;
    private final DiffMergeEngine engine;
    private IDiffMergeController.DiffMergeControllerKind kind = IDiffMergeController.DiffMergeControllerKind.MATCH;
    private String localName;
    private String remoteName;
    private boolean containerAdded;
    private Notifier localInput;
    private Notifier remoteInput;
    private Notifier originInput;
    private final Set<DiffMergeView> views = Sets.newHashSet();
    private final IDiffMergeConfig config;

    public DiffMergeControllerImpl(IDiffMerge diffmerge, IDiffModelFilter filter, DiffMergeEngine engine, IDiffMergeConfig config) {
        this.diffMerge = diffmerge;
        this.filter = filter;
        this.engine = engine;
        this.listenerWrapper = this.initListenerWrapper(diffmerge);
        this.config = config;
    }

    private DiffMergeListenerWrapper initListenerWrapper(IDiffMerge diffmerge) {
        DiffMergeListenerWrapper diffMergeListenerWrapper = new DiffMergeListenerWrapper(this, diffmerge);
        diffmerge.addDiffMergeListener((DiffMergeListener)diffMergeListenerWrapper);
        return diffMergeListenerWrapper;
    }

    @Override
    public IDiffModelFilter getDiffModelFilter() {
        return this.filter;
    }

    @Override
    public void setLocalModelResource(Resource localResource) {
        this.setLocalModelResource(localResource, "Local model");
    }

    @Override
    public void setRemoteModelResource(Resource remoteResource) {
        this.setRemoteModelResource(remoteResource, "Remote model");
    }

    @Override
    public void setAncestorModelResource(Resource ancestorResource) {
        this.originInput = ancestorResource;
    }

    @Override
    public void addDiffMergeListener(IDiffMergeListener iDiffMergeListener) {
        this.listenerWrapper.addListener(iDiffMergeListener);
    }

    public DiffMergeListenerWrapper getListenerWrapper() {
        return this.listenerWrapper;
    }

    @Override
    public boolean compare() {
        this.model = this.originInput != null ? this.compareThreeResources(this.localInput, this.originInput, this.remoteInput) : this.compareTwoResources(this.localInput, this.remoteInput);
        return this.model.match();
    }

    private DiffModel compareTwoResources(Notifier left, Notifier right) {
        Preconditions.checkNotNull((Object)left);
        Preconditions.checkNotNull((Object)right);
        return this.diffMerge.compare(left, right);
    }

    private DiffModel compareThreeResources(Notifier left, Notifier origin, Notifier right) {
        Preconditions.checkNotNull((Object)left);
        Preconditions.checkNotNull((Object)origin);
        Preconditions.checkNotNull((Object)right);
        return this.diffMerge.compare(left, origin, right);
    }

    public IDiffMerge getDiffMerge() {
        return this.diffMerge;
    }

    @Override
    public DiffMergeEngine getEngine() {
        return this.engine;
    }

    @Override
    public IDiffMergeController.DiffMergeControllerKind getDiffMergeControllerKind() {
        return this.kind;
    }

    @Override
    public void setDiffMergeControllerKind(IDiffMergeController.DiffMergeControllerKind kind) {
        this.kind = kind;
    }

    @Override
    public void setLocalModelResource(Resource resource, String name) {
        this.localInput = resource;
        this.localName = name;
    }

    @Override
    public void setRemoteModelResource(Resource resource, String name) {
        this.remoteInput = resource;
        this.remoteName = name;
    }

    @Override
    public String getModelName() {
        String name = this.localName;
        if (name == null) {
            name = this.remoteName;
        }
        if (name == null) {
            name = "Model";
        }
        return name;
    }

    @Override
    public void setSynchronizeMode(SynchronizeMode mode) {
        switch (mode) {
            case Commit: {
                this.setCommitModeInViews();
                break;
            }
            case Update: {
                this.setUpdateModeInViews();
                break;
            }
            case Synchronize: {
                break;
            }
        }
    }

    private void setUpdateModeInViews() {
        for (DiffMergeView view : this.views) {
            view.getConfig().setUpdateMode().update();
        }
    }

    private void setCommitModeInViews() {
        for (DiffMergeView view : this.views) {
            view.getConfig().setCommitMode().update();
        }
    }

    @Override
    @Deprecated
    public Resource getLocalModelResource() {
        if (this.localInput instanceof Resource) {
            return (Resource)this.localInput;
        }
        return null;
    }

    @Override
    public ResourceContainer getResourceModelContainers() {
        throw new RuntimeException("ResourceContainers are no longer supported");
    }

    @Override
    public Notifier getLocalModelResourceSet() {
        return this.localInput;
    }

    @Override
    public Notifier getRemoteModelResourceSet() {
        return this.remoteInput;
    }

    @Override
    public void setModelName(String name) {
        this.localName = name;
    }

    @Override
    public void setResourceModelContainers(ResourceContainer ... container) {
        this.containerAdded = true;
        if (container.length != 1) {
            throw new RuntimeException("Please pass only 1 container which contains your local, ancestor and remote ResoruceSets");
        }
        this.localInput = container[0].getLeftInput();
        this.originInput = container[0].getAncestorInput();
        this.remoteInput = container[0].getRightInput();
    }

    @Override
    public boolean compareResourceContainer() {
        if (this.containerAdded) {
            this.model = this.originInput != null ? this.diffMerge.compare(this.localInput, this.originInput, this.originInput) : this.diffMerge.compare(this.localInput, this.remoteInput);
            return this.model.match();
        }
        throw new RuntimeException("ResourceContainer not set!");
    }

    @Override
    public DiffModel getDiffModel() {
        return this.model;
    }

    @Override
    public IDiffMerge getActiveDiffMerge() {
        return this.diffMerge;
    }

    @Override
    public void addDiffMergeView(DiffMergeView view) {
        this.views.add(view);
    }

    @Override
    public IDiffMergeConfig getConfig() {
        return this.config;
    }

    @Override
    public void ignoreXMIIDChanged(boolean value) {
        if (value) {
            this.diffMerge.getCompareConfig().compareElementByStructure().update();
        } else {
            this.diffMerge.getCompareConfig().compareElementsByID().update();
        }
    }

    @Override
    public Collection<DiffMergeView> getDiffMergeViews() {
        return ImmutableSet.copyOf(this.views);
    }
}

