/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.activemq.kaha.impl.DataManager;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.RedoStoreIndexItem;
import org.apache.activemq.util.DataByteArrayOutputStream;

class StoreIndexWriter {
    protected final DataByteArrayOutputStream dataOut = new DataByteArrayOutputStream();
    protected final RandomAccessFile file;
    protected final String name;
    protected final DataManager redoLog;

    StoreIndexWriter(RandomAccessFile file) {
        this(file, null, null);
    }

    public StoreIndexWriter(RandomAccessFile file, String indexName, DataManager redoLog) {
        this.file = file;
        this.name = indexName;
        this.redoLog = redoLog;
    }

    void storeItem(IndexItem indexItem) throws IOException {
        if (this.redoLog != null) {
            RedoStoreIndexItem redo = new RedoStoreIndexItem(this.name, indexItem.getOffset(), indexItem);
            this.redoLog.storeRedoItem(redo);
        }
        this.dataOut.reset();
        indexItem.write(this.dataOut);
        this.file.seek(indexItem.getOffset());
        this.file.write(this.dataOut.getData(), 0, 51);
    }

    void updateIndexes(IndexItem indexItem) throws IOException {
        if (this.redoLog != null) {
            RedoStoreIndexItem redo = new RedoStoreIndexItem(this.name, indexItem.getOffset(), indexItem);
            this.redoLog.storeRedoItem(redo);
        }
        this.dataOut.reset();
        indexItem.updateIndexes(this.dataOut);
        this.file.seek(indexItem.getOffset());
        this.file.write(this.dataOut.getData(), 0, 19);
    }

    public void redoStoreItem(RedoStoreIndexItem redo) throws IOException {
        this.dataOut.reset();
        redo.getIndexItem().write(this.dataOut);
        this.file.seek(redo.getOffset());
        this.file.write(this.dataOut.getData(), 0, 51);
    }
}

