/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.lifecycle.ContextUtil;
import org.eclipse.rap.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rap.rwt.internal.lifecycle.IPhase;
import org.eclipse.rap.rwt.internal.lifecycle.ISessionShutdownAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.IUIThreadHolder;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.lifecycle.PhaseExecutor;
import org.eclipse.rap.rwt.internal.lifecycle.PrepareUIRoot;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessAction;
import org.eclipse.rap.rwt.internal.lifecycle.ReadData;
import org.eclipse.rap.rwt.internal.lifecycle.Render;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.UISessionImpl;
import org.eclipse.rap.rwt.lifecycle.ILifeCycle;
import org.eclipse.rap.rwt.lifecycle.PhaseId;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;

public class SimpleLifeCycle
extends LifeCycle {
    private final IPhase[] phases;

    public SimpleLifeCycle(ApplicationContextImpl applicationContext) {
        super(applicationContext);
        this.phases = new IPhase[]{new PrepareUIRoot(applicationContext), new ReadData(), new ProcessAction(), new Render()};
    }

    public void execute() throws IOException {
        this.installSessionShutdownAdapter();
        UISession uiSession = ContextProvider.getUISession();
        SimpleLifeCycle.attachThread(LifeCycleUtil.getSessionDisplay(), uiSession);
        try {
            SessionDisplayPhaseExecutor phaseExecutor = new SessionDisplayPhaseExecutor(this.phases, (ILifeCycle)this);
            phaseExecutor.execute(PhaseId.PREPARE_UI_ROOT);
        }
        finally {
            SimpleLifeCycle.detachThread(LifeCycleUtil.getSessionDisplay(), uiSession);
        }
    }

    public void requestThreadExec(Runnable runnable) {
        runnable.run();
    }

    public void sleep() {
        String msg = "Display#sleep() not supported in current operation mode.";
        throw new UnsupportedOperationException(msg);
    }

    private void installSessionShutdownAdapter() {
        UISessionImpl uiSession = (UISessionImpl)ContextProvider.getUISession();
        if (uiSession.getShutdownAdapter() == null) {
            uiSession.setShutdownAdapter(new SimpleSessionShutdownAdapter(this.applicationContext));
        }
    }

    private static void attachThread(Display display, UISession uiSession) {
        if (display != null) {
            IDisplayAdapter displayAdapter = display.getAdapter(IDisplayAdapter.class);
            displayAdapter.attachThread();
        }
        SimpleUIThreadHolder uiThreadHolder = new SimpleUIThreadHolder(Thread.currentThread());
        LifeCycleUtil.setUIThread(uiSession, uiThreadHolder);
    }

    private static void detachThread(Display display, UISession uiSession) {
        if (display != null) {
            IDisplayAdapter displayAdapter = display.getAdapter(IDisplayAdapter.class);
            displayAdapter.detachThread();
        }
        LifeCycleUtil.setUIThread(uiSession, null);
    }

    private class SessionDisplayPhaseExecutor
    extends PhaseExecutor {
        SessionDisplayPhaseExecutor(IPhase[] phases, ILifeCycle lifecycle) {
            super(SimpleLifeCycle.this.phaseListenerManager, phases, lifecycle);
        }

        Display getDisplay() {
            return LifeCycleUtil.getSessionDisplay();
        }
    }

    private static class SimpleSessionShutdownAdapter
    implements ISessionShutdownAdapter {
        private final ApplicationContextImpl applicationContext;
        private Runnable shutdownCallback;
        private UISession uiSession;

        SimpleSessionShutdownAdapter(ApplicationContextImpl applicationContext) {
            this.applicationContext = applicationContext;
        }

        public void setShutdownCallback(Runnable shutdownCallback) {
            this.shutdownCallback = shutdownCallback;
        }

        public void setUISession(UISession uiSession) {
            this.uiSession = uiSession;
        }

        public void interceptShutdown() {
            final Display display = LifeCycleUtil.getSessionDisplay(this.uiSession);
            ContextUtil.runNonUIThreadWithFakeContext(this.uiSession, new Runnable(){

                public void run() {
                    if (SimpleSessionShutdownAdapter.isDisplayActive(display) && SimpleSessionShutdownAdapter.this.isApplicationContextActive()) {
                        SimpleLifeCycle.attachThread(display, SimpleSessionShutdownAdapter.this.uiSession);
                        CurrentPhase.set(PhaseId.PROCESS_ACTION);
                        display.dispose();
                    }
                    SimpleSessionShutdownAdapter.this.shutdownCallback.run();
                }
            });
        }

        public void processShutdown() {
            throw new UnsupportedOperationException();
        }

        private static boolean isDisplayActive(Display display) {
            return display != null && !display.isDisposed();
        }

        private boolean isApplicationContextActive() {
            return this.applicationContext != null && this.applicationContext.isActive();
        }
    }

    private static class SimpleUIThreadHolder
    implements IUIThreadHolder {
        private final Thread thread;

        public SimpleUIThreadHolder(Thread thread) {
            this.thread = thread;
        }

        public void updateServiceContext() {
            throw new UnsupportedOperationException();
        }

        public void terminateThread() {
            throw new UnsupportedOperationException();
        }

        public void switchThread() {
            throw new UnsupportedOperationException();
        }

        public void setServiceContext(ServiceContext serviceContext) {
            throw new UnsupportedOperationException();
        }

        public Thread getThread() {
            return this.thread;
        }

        public Object getLock() {
            throw new UnsupportedOperationException();
        }
    }
}

