/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.modelbus.services.repository.server.IRepositoryFactory;

public class RepositoryFactoryFactory {
    private static final String EXTENSION_POINT_ID = "org.modelbus.services.repository.server.repository.factory";
    private static RepositoryFactoryFactory _instance;
    private List<IRepositoryFactory> factories = null;

    private RepositoryFactoryFactory() {
    }

    public static RepositoryFactoryFactory getInstance() {
        if (_instance == null) {
            _instance = new RepositoryFactoryFactory();
            _instance.initialize();
        }
        return _instance;
    }

    private void initialize() {
        IExtension[] extensions;
        if (this.factories != null) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            return;
        }
        this.factories = new ArrayList<IRepositoryFactory>();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension element = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = element.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement c = iConfigurationElementArray[n4];
                try {
                    IRepositoryFactory factory = (IRepositoryFactory)c.createExecutableExtension("factoryClass");
                    this.factories.add(factory);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public List<IRepositoryFactory> getInstalledRepositoryFactories() {
        return this.factories;
    }
}

