/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.services.repository.server.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.activation.DataHandler;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.modelbus.dosgi.repository.descriptor.ConstraintViolationException;
import org.modelbus.dosgi.repository.descriptor.InvalidValueException;
import org.modelbus.dosgi.repository.descriptor.LockedException;
import org.modelbus.dosgi.repository.descriptor.NonExistingResourceException;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.RepositoryRuntimeException;
import org.modelbus.dosgi.repository.descriptor.UnresolvedReferencesException;
import org.modelbus.model.user.Rule;
import org.modelbus.model.user.User;
import org.modelbus.model.user.UserFactory;
import org.modelbus.model.user.UserGroup;
import org.modelbus.model.user.UserModel;
import org.modelbus.model.user.UserPackage;
import org.modelbus.services.repository.server.IModelBusRepository;
import org.modelbus.services.repository.server.IModelBusSession;
import org.modelbus.services.repository.server.ModelBusNodeKind;
import org.modelbus.services.repository.server.common.AbstractManager;
import org.modelbus.services.repository.server.common.AbstractModelBusRepository;
import org.modelbus.services.repository.server.common.ModelBusSystemSessionImpl;

public class AccessManager
extends AbstractManager {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int EXECUTE = 4;
    public static final int SETUID = 8;
    public static final int STICKY = 16;
    public static final IModelBusSession INTERNAL_MODEL_BUS_SESSION = new ModelBusSystemSessionImpl();
    private final UserFactory userFactory = UserFactory.eINSTANCE;
    private static UserModel userModel = null;

    public AccessManager(IModelBusRepository modelBusRepository) {
        super(modelBusRepository);
    }

    private UserModel createModel() {
        UserModel userModel = this.userFactory.createUserModel();
        User admin = this.userFactory.createUser();
        admin.setName("Admin");
        admin.setPassword("ModelBus");
        userModel.getOwnedUser().add((Object)admin);
        Rule allowAll = this.userFactory.createRule();
        allowAll.setMask(-1);
        allowAll.setRule(".*");
        admin.getOwnedRule().add((Object)allowAll);
        return userModel;
    }

    private UserModel loadUserModel() throws RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, NonExistingResourceException, LockedException {
        Resource resource;
        boolean userModelExists;
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        EPackage.Registry.INSTANCE.put((Object)UserPackage.eINSTANCE.getNsURI(), (Object)UserPackage.eINSTANCE);
        URI modelBusUserURI = URI.createURI((String)"http://www.modelbus.org/system/model/ModelBus.user");
        ModelBusNodeKind nodeKind = this.modelBusRepository.checkPathFileSystem(INTERNAL_MODEL_BUS_SESSION, modelBusUserURI, "-1");
        boolean bl = userModelExists = nodeKind != null;
        if (!userModelExists) {
            URI userMetamodelURI = URI.createURI((String)"http://www.modelbus.org/system/model/user.ecore");
            if (!this.modelBusRepository.exists(INTERNAL_MODEL_BUS_SESSION, userMetamodelURI, "-1")) {
                Resource userResource = this.modelBusRepository.createModel(INTERNAL_MODEL_BUS_SESSION, null, userMetamodelURI, ECLASS_URI, "internal model creation", AbstractModelBusRepository.getDefaultOptionsMap());
                userResource.getContents().clear();
                userResource.getContents().add((Object)UserPackage.eINSTANCE);
                this.modelBusRepository.checkInModel(INTERNAL_MODEL_BUS_SESSION, userResource, "internal model creation", AbstractModelBusRepository.getDefaultOptionsMap());
            }
            resource = this.modelBusRepository.createModel(INTERNAL_MODEL_BUS_SESSION, null, URI.createURI((String)"http://www.modelbus.org/system/model/ModelBus.user"), userMetamodelURI.appendFragment("//UserModel"), "internal model creation", AbstractModelBusRepository.getDefaultOptionsMap());
            resource.getContents().clear();
            resource.getContents().add((Object)this.createModel());
            this.modelBusRepository.checkInModel(INTERNAL_MODEL_BUS_SESSION, resource, "internal model creation", AbstractModelBusRepository.getDefaultOptionsMap());
        } else {
            resource = this.modelBusRepository.checkOutModel(INTERNAL_MODEL_BUS_SESSION, modelBusUserURI);
        }
        UserModel userModel = (UserModel)resource.getContents().get(0);
        return userModel;
    }

    private synchronized UserModel getUserModel() throws RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, NonExistingResourceException, LockedException {
        if (userModel == null) {
            userModel = this.loadUserModel();
        }
        return userModel;
    }

    public boolean validateUser(String userName, String password) throws RepositoryAuthentificationException {
        UserModel userModel;
        try {
            userModel = this.getUserModel();
        }
        catch (InvalidValueException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (ConstraintViolationException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (UnresolvedReferencesException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (NonExistingResourceException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (LockedException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
        EList users = userModel.getOwnedUser();
        for (User user : users) {
            if (!userName.equals(user.getName())) continue;
            return password.equals(user.getPassword());
        }
        return false;
    }

    private User getUserByName(String userName) throws RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, NonExistingResourceException, LockedException {
        UserModel userModel = this.getUserModel();
        EList users = userModel.getOwnedUser();
        for (User user : users) {
            if (!userName.equals(user.getName())) continue;
            return user;
        }
        return null;
    }

    private List<Rule> getUsersRules(User user) throws RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, NonExistingResourceException, LockedException {
        UserModel userModel = this.getUserModel();
        EList userGroups = userModel.getOwnedUserGroup();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.addAll((Collection<Rule>)user.getOwnedRule());
        for (UserGroup userGroup : userGroups) {
            if (!userGroup.getUser().contains((Object)user)) continue;
            rules.addAll((Collection<Rule>)userGroup.getOwnedRule());
        }
        return rules;
    }

    private int getAccessRights(String userName, URI uri) throws RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, NonExistingResourceException, LockedException {
        uri = uri.trimFragment();
        String path = uri.toString();
        User user = this.getUserByName(userName);
        List<Rule> rules = this.getUsersRules(user);
        int result = 0;
        for (Rule rule : rules) {
            if (!path.matches(rule.getRule())) continue;
            result |= rule.getMask();
        }
        return result;
    }

    public void checkAccessRights(IModelBusSession modelBusSession, URI uri, int rights) throws RepositoryAuthentificationException, NonExistingResourceException, LockedException {
        if (INTERNAL_MODEL_BUS_SESSION.equals(modelBusSession)) {
            return;
        }
        String username = modelBusSession.getValueForKey("username");
        String password = modelBusSession.getValueForKey("password");
        if (username == null || "".equals(username) || password == null || "".equals(password)) {
            throw new RepositoryAuthentificationException("User data missing.");
        }
        try {
            if (this.validateUser(username, password)) {
                int flags = this.getAccessRights(username, uri);
                if ((rights & flags) == rights) {
                    return;
                }
                throw new RepositoryAuthentificationException("Insufficent access rights of user '" + username + "' on path " + uri.toString() + " # " + rights);
            }
            throw new RepositoryAuthentificationException("No valid user and password combination.");
        }
        catch (InvalidValueException e) {
            throw new RepositoryAuthentificationException(e.getMessage(), (Throwable)e);
        }
        catch (ConstraintViolationException e) {
            throw new RepositoryAuthentificationException(e.getMessage(), (Throwable)e);
        }
        catch (UnresolvedReferencesException e) {
            throw new RepositoryAuthentificationException(e.getMessage(), (Throwable)e);
        }
    }

    public void checkAccessRights(IModelBusSession modelBusSession, URI[] uris, int rights) throws RepositoryAuthentificationException, NonExistingResourceException, LockedException {
        URI[] uRIArray = uris;
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            this.checkAccessRights(modelBusSession, uri, rights);
            ++n2;
        }
    }

    public boolean hasAccessRights(IModelBusSession modelBusSession, URI uri, int rights) throws RepositoryAuthentificationException, InvalidValueException, ConstraintViolationException, UnresolvedReferencesException, NonExistingResourceException, LockedException {
        if (INTERNAL_MODEL_BUS_SESSION.equals(modelBusSession)) {
            return true;
        }
        String username = modelBusSession.getValueForKey("username");
        if (username == null) {
            throw new RuntimeException("User data missing.");
        }
        int flags = this.getAccessRights(username, uri);
        return (rights & flags) == rights;
    }

    @Override
    public void createModel(URI modelUri, IModelBusSession session) {
    }

    @Override
    public void deleteModel(URI modelUri, IModelBusSession session) {
    }

    @Override
    public void updateModel(URI modelUri, IModelBusSession session) {
        if ("http://www.modelbus.org/system/model/ModelBus.user".equals(modelUri.toString())) {
            userModel = null;
        }
    }

    @Override
    public void commitChangeModelNotification(String messageID, URI modelUri, DataHandler changeModelContent) {
    }
}

