/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.merge;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.modelbus.tools.diffmerge.merge.BasicMerger;
import org.modelbus.tools.diffmerge.merge.MergeException;
import org.modelbus.tools.diffmerge.model.DiffElement;
import org.modelbus.tools.diffmerge.model.DiffModel;
import org.modelbus.tools.diffmerge.model.DiffModelElement;
import org.modelbus.tools.diffmerge.model.collections.DiffCollection;
import org.modelbus.tools.modelbusexplorer.logging.Logger;
import org.modelbus.tools.modelbusexplorer.logging.LoggerFactory;

class NonConflictMerger
extends BasicMerger {
    private static final Logger LOG = LoggerFactory.getLogger(NonConflictMerger.class);

    NonConflictMerger() {
    }

    @Override
    void mergeModelElementAndAllChildren(DiffModelElement modelElement, boolean leftToRight) {
        if (modelElement.getConflictingElements().isEmpty()) {
            super.mergeModelElementAndAllChildren(modelElement, leftToRight);
        } else {
            Set<DiffModelElement> elementsToMerge = this.removeNonConflictingElementsFromModel(modelElement);
            for (DiffModelElement element : elementsToMerge) {
                this.mergeDiffModelElement(element, leftToRight);
            }
            this.fixModelElementIfItIsTheModel(modelElement);
        }
    }

    private Set<DiffModelElement> removeNonConflictingElementsFromModel(DiffModelElement elementWithConflicts) {
        DiffModel model = this.getDiffModel(elementWithConflicts);
        Set<DiffModelElement> elementsToMerge = this.getElementsToRemove(model, elementWithConflicts);
        for (DiffModelElement child : elementsToMerge) {
            model.removeSubElement(child);
        }
        return elementsToMerge;
    }

    private Set<DiffModelElement> getElementsToRemove(DiffModel model, DiffModelElement elementWithConflicts) {
        HashSet result = Sets.newHashSet();
        DiffCollection conflicts = elementWithConflicts.getConflictingElements();
        List allSubElements = model.getAllSubElements();
        for (DiffModelElement node : allSubElements) {
            if (!node.getConflictingElements().isEmpty() && this.nodeContainesConflicts(node, (DiffCollection<DiffElement>)conflicts)) continue;
            result.add(node);
        }
        return result;
    }

    private boolean nodeContainesConflicts(DiffModelElement node, DiffCollection<DiffElement> conflicts) {
        DiffCollection nodesConflicts = node.getConflictingElements();
        if (nodesConflicts.isEmpty()) {
            return false;
        }
        for (DiffElement conflict : conflicts) {
            if (!nodesConflicts.contains((Object)conflict)) continue;
            return true;
        }
        return false;
    }

    private DiffModel getDiffModel(DiffModelElement elementWithConflicts) {
        if (elementWithConflicts instanceof DiffModel) {
            return (DiffModel)elementWithConflicts;
        }
        DiffModel model = null;
        DiffModelElement parent = elementWithConflicts;
        while (parent != null) {
            if (parent instanceof DiffModel) {
                model = (DiffModel)parent;
                break;
            }
            Optional parentElement = parent.getParentElement();
            if (!parentElement.isPresent()) break;
            parent = (DiffModelElement)parentElement.get();
        }
        if (model == null) {
            throw new MergeException(String.format("DiffModelElement '%s' is not contained in a DiffModel", elementWithConflicts.toString()));
        }
        return model;
    }

    private void removeConflictsFromModel(DiffModel model, DiffCollection<DiffElement> conflicts) {
        LinkedList removedElements = Lists.newLinkedList();
        List allSubElements = model.getAllSubElements();
        for (DiffModelElement node : allSubElements) {
            DiffCollection conflictingElements = node.getConflictingElements();
            if (conflictingElements.isEmpty()) continue;
            for (DiffElement conflict : conflicts) {
                if (!conflictingElements.contains((Object)conflict)) continue;
                if (removedElements.contains(conflict)) {
                    LOG.warn(String.format("Conflicting element '%s' was already added to collection", conflict.toString()));
                }
                removedElements.add(conflict);
                node.removeConflictingSubElement((DiffModelElement)conflict);
            }
        }
    }

    @Override
    void mergeDiffElement(DiffElement diffElement, boolean leftToRight) {
        if (diffElement.isConflict()) {
            return;
        }
        super.mergeDiffElement(diffElement, leftToRight);
    }
}

