/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.model;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.AttributeChangeMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.ReferenceChangeMerger;
import org.eclipse.emf.compare.merge.ResourceAttachmentChangeMerger;
import org.eclipse.emf.ecore.EObject;
import org.modelbus.tools.diffmerge.model.AbstractDiffElement;
import org.modelbus.tools.diffmerge.model.AttachmentChangeLeaf;
import org.modelbus.tools.diffmerge.model.AttributeDiffElement;
import org.modelbus.tools.diffmerge.model.AttributeLeaf;
import org.modelbus.tools.diffmerge.model.ConflictLeaf;
import org.modelbus.tools.diffmerge.model.DiffElementLeaf;
import org.modelbus.tools.diffmerge.model.DiffModel;
import org.modelbus.tools.diffmerge.model.DiffModelElement;
import org.modelbus.tools.diffmerge.model.DiffModelElementImpl;
import org.modelbus.tools.diffmerge.model.DiffModelException;
import org.modelbus.tools.diffmerge.model.DiffModelImpl;
import org.modelbus.tools.diffmerge.model.ReferenceDiffElement;
import org.modelbus.tools.diffmerge.model.ReferenceLeaf;
import org.modelbus.tools.diffmerge.model.ResourceAttachmentChangeDiffElement;
import org.modelbus.tools.diffmerge.model.identifier.DefaultIdentifier;
import org.modelbus.tools.diffmerge.model.identifier.ModelIdentifier;

public class DiffModelBuilder {
    private final AttributeChangeMerger attributeMerger = new AttributeChangeMerger();
    private final ReferenceChangeMerger referenceMerger = new ReferenceChangeMerger();
    private final AbstractMerger attachmentChangeMerger = new ResourceAttachmentChangeMerger();
    private final Monitor monitor = new BasicMonitor();
    private final Map<Match, DiffModelElementImpl> matchCache = Maps.newHashMap();
    private DiffModelImpl model;
    private ModelIdentifier identifier;
    private Set<Conflict> cachedConflicts = Sets.newHashSet();

    public static DiffModelBuilder createNewBuilder() {
        return new DiffModelBuilder();
    }

    private DiffModelBuilder() {
        IMerger.Registry registry = IMerger.RegistryImpl.createStandaloneInstance();
        this.attributeMerger.setRegistry(registry);
        this.referenceMerger.setRegistry(registry);
        this.attachmentChangeMerger.setRegistry(registry);
    }

    public DiffModelBuilder setModelIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public DiffModel createEmptyDiffModel(boolean isThreeWay, Notifier left, Notifier right) {
        return new DiffModelImpl(isThreeWay, left, right);
    }

    public DiffModel createNewDiffModel(Comparison comparison, Notifier left, Notifier right) {
        if (this.identifier == null) {
            this.identifier = new DefaultIdentifier();
        }
        this.model = new DiffModelImpl(comparison.isThreeWay(), left, right);
        for (Diff diff : comparison.getDifferences()) {
            AbstractDiffElement diffElement;
            Match match = diff.getMatch();
            DiffModelElementImpl parent = this.createParent(match);
            if (diff.getConflict() != null) {
                Conflict conflict = diff.getConflict();
                if (this.cachedConflicts.contains(conflict)) continue;
                this.cachedConflicts.add(conflict);
                diffElement = this.createDiffElement(parent, diff);
            } else {
                diffElement = this.createDiffElement(parent, diff);
            }
            parent.addDiff(diffElement);
            this.addParentNodes(parent);
        }
        this.cachedConflicts.clear();
        return this.model;
    }

    private DiffModelElementImpl createParent(Match match) {
        DiffModelElementImpl parent = this.matchCache.get(match);
        if (parent == null) {
            parent = new DiffModelElementImpl(match, this.identifier);
            if (this.matchCache.containsKey(match)) {
                throw new DiffModelException("Match allready chached!");
            }
            this.matchCache.put(match, parent);
        }
        return parent;
    }

    private AbstractDiffElement createDiffElement(DiffModelElement parent, Diff diff) {
        DiffElementLeaf leaf;
        AbstractDiffElement diffElement;
        if (diff instanceof AttributeChange) {
            diffElement = new AttributeDiffElement(parent, diff, (AbstractMerger)this.attributeMerger, this.monitor);
            leaf = new AttributeLeaf(diffElement);
        } else if (diff instanceof ReferenceChange) {
            diffElement = new ReferenceDiffElement(parent, diff, (AbstractMerger)this.referenceMerger, this.monitor);
            leaf = new ReferenceLeaf(diffElement);
        } else if (diff instanceof ResourceAttachmentChange) {
            diffElement = new ResourceAttachmentChangeDiffElement(parent, diff, this.attachmentChangeMerger, this.monitor);
            leaf = new AttachmentChangeLeaf(diffElement);
        } else {
            throw new DiffModelException("Unsupported type: " + diff.getClass().getName());
        }
        if (diff.getConflict() != null) {
            leaf = new ConflictLeaf(diffElement);
        }
        diffElement.addLeaf(leaf);
        return diffElement;
    }

    private void addParentNodes(DiffModelElementImpl childNode) {
        Match childMatch = childNode.getMatch();
        EObject eContainer = childMatch.eContainer();
        if (eContainer instanceof Comparison) {
            this.model.addNode(childNode);
            return;
        }
        if (!(eContainer instanceof Match)) {
            return;
        }
        Match parentMatch = (Match)childMatch.eContainer();
        DiffModelElementImpl parentNode = null;
        while (parentMatch != null) {
            parentNode = this.matchCache.get(parentMatch);
            if (parentNode != null) {
                this.addNodeToExistingParent(childNode, parentNode);
                return;
            }
            parentNode = this.createNewParentNode(childNode, parentMatch);
            EObject container = parentMatch.eContainer();
            if (container instanceof Match) {
                parentMatch = (Match)parentMatch.eContainer();
                childNode = parentNode;
                continue;
            }
            parentMatch = null;
            parentNode.setParent((DiffModelElement)this.model);
        }
        this.model.addNode(parentNode);
    }

    private void addNodeToExistingParent(DiffModelElementImpl childNode, DiffModelElementImpl parentNode) {
        parentNode.addNode(childNode);
        Optional<DiffModelElement> parentElement = childNode.getParentElement();
        if (!parentElement.isPresent()) {
            childNode.setParent(parentNode);
        }
    }

    private DiffModelElementImpl createNewParentNode(DiffModelElementImpl childNode, Match parentMatch) {
        DiffModelElementImpl parentNode = new DiffModelElementImpl(parentMatch, this.identifier);
        this.matchCache.put(parentMatch, parentNode);
        this.addNodeToExistingParent(childNode, parentNode);
        return parentNode;
    }
}

