/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericFileProcessStrategySupport<T>
implements GenericFileProcessStrategy<T> {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    protected GenericFileExclusiveReadLockStrategy<T> exclusiveReadLockStrategy;

    @Override
    public void prepareOnStartup(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint) throws Exception {
        if (this.exclusiveReadLockStrategy != null) {
            this.exclusiveReadLockStrategy.prepareOnStartup(operations, endpoint);
        }
    }

    @Override
    public boolean begin(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        boolean lock;
        return this.exclusiveReadLockStrategy == null || (lock = this.exclusiveReadLockStrategy.acquireExclusiveReadLock(operations, file, exchange));
    }

    @Override
    public void commit(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        if (this.exclusiveReadLockStrategy != null) {
            this.exclusiveReadLockStrategy.releaseExclusiveReadLock(operations, file, exchange);
        }
        this.deleteLocalWorkFile(exchange);
    }

    @Override
    public void rollback(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        if (this.exclusiveReadLockStrategy != null) {
            this.exclusiveReadLockStrategy.releaseExclusiveReadLock(operations, file, exchange);
        }
        this.deleteLocalWorkFile(exchange);
    }

    public GenericFileExclusiveReadLockStrategy<T> getExclusiveReadLockStrategy() {
        return this.exclusiveReadLockStrategy;
    }

    public void setExclusiveReadLockStrategy(GenericFileExclusiveReadLockStrategy<T> exclusiveReadLockStrategy) {
        this.exclusiveReadLockStrategy = exclusiveReadLockStrategy;
    }

    protected GenericFile<T> renameFile(GenericFileOperations<T> operations, GenericFile<T> from, GenericFile<T> to) throws IOException {
        try {
            operations.deleteFile(to.getAbsoluteFilePath());
        }
        catch (GenericFileOperationFailedException e) {
            // empty catch block
        }
        boolean mkdir = operations.buildDirectory(to.getParent(), to.isAbsolute());
        if (!mkdir) {
            throw new GenericFileOperationFailedException("Cannot create directory: " + to.getParent() + " (could be because of denied permissions)");
        }
        this.log.debug("Renaming file: {} to: {}", from, to);
        boolean renamed = operations.renameFile(from.getAbsoluteFilePath(), to.getAbsoluteFilePath());
        if (!renamed) {
            throw new GenericFileOperationFailedException("Cannot rename file: " + from + " to: " + to);
        }
        return to;
    }

    private void deleteLocalWorkFile(Exchange exchange) {
        File local = exchange.getIn().getHeader("CamelFileLocalWorkPath", File.class);
        if (local != null && local.exists()) {
            boolean deleted = FileUtil.deleteFile(local);
            this.log.trace("Local work file: {} was deleted: {}", (Object)local, (Object)deleted);
        }
    }
}

