/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RouteContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OsgiServiceRegistry
implements Registry,
LifecycleStrategy {
    private final BundleContext bundleContext;
    private final Map<String, Object> serviceCacheMap = new ConcurrentHashMap<String, Object>();
    private final ConcurrentLinkedQueue<ServiceReference> serviceReferenceQueue = new ConcurrentLinkedQueue();

    public OsgiServiceRegistry(BundleContext bc) {
        this.bundleContext = bc;
    }

    @Override
    public <T> T lookup(String name, Class<T> type) {
        Object service = this.lookup(name);
        return type.cast(service);
    }

    @Override
    public Object lookup(String name) {
        ServiceReference sr;
        Object service = this.serviceCacheMap.get(name);
        if (service == null && (sr = this.bundleContext.getServiceReference(name)) != null) {
            this.serviceReferenceQueue.add(sr);
            service = this.bundleContext.getService(sr);
            if (service != null) {
                this.serviceCacheMap.put(name, service);
            }
        }
        return service;
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        return Collections.EMPTY_MAP;
    }

    @Override
    public void onComponentAdd(String name, Component component) {
    }

    @Override
    public void onComponentRemove(String name, Component component) {
    }

    @Override
    public void onContextStart(CamelContext context) {
    }

    @Override
    public void onContextStop(CamelContext context) {
        ServiceReference sr = this.serviceReferenceQueue.poll();
        while (sr != null) {
            this.bundleContext.ungetService(sr);
            sr = this.serviceReferenceQueue.poll();
        }
        this.serviceCacheMap.clear();
    }

    @Override
    public void onEndpointAdd(Endpoint endpoint) {
    }

    @Override
    public void onEndpointRemove(Endpoint endpoint) {
    }

    @Override
    public void onRouteContextCreate(RouteContext routeContext) {
    }

    @Override
    public void onRoutesAdd(Collection<Route> routes) {
    }

    @Override
    public void onRoutesRemove(Collection<Route> routes) {
    }

    @Override
    public void onServiceAdd(CamelContext context, Service service, Route route) {
    }

    @Override
    public void onServiceRemove(CamelContext context, Service service, Route route) {
    }

    @Override
    public void onErrorHandlerAdd(RouteContext routeContext, Processor processor, ErrorHandlerFactory errorHandlerBuilder) {
    }

    @Override
    public void onThreadPoolAdd(CamelContext camelContext, ThreadPoolExecutor threadPoolExecutor, String id, String sourceId, String routeId, String threadPoolProfileId) {
    }
}

