/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.handler;

import org.apache.camel.spring.CamelRedeliveryPolicyFactoryBean;
import org.apache.camel.spring.ErrorHandlerType;
import org.apache.camel.spring.handler.BeanDefinitionParser;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ErrorHandlerDefinitionParser
extends BeanDefinitionParser {
    protected BeanDefinitionParser redeliveryPolicyParser = new RedeliveryPolicyDefinitionParser(CamelRedeliveryPolicyFactoryBean.class);

    public ErrorHandlerDefinitionParser() {
        super(null, false);
    }

    @Override
    protected Class getBeanClass(Element element) {
        ErrorHandlerType type = ErrorHandlerType.DefaultErrorHandler;
        if (ObjectHelper.isNotEmpty(element.getAttribute("type"))) {
            type = ErrorHandlerType.valueOf(element.getAttribute("type"));
        }
        return type.getTypeAsClass();
    }

    @Override
    protected boolean isEligibleAttribute(String attributeName) {
        if (attributeName == null || "id".equals(attributeName)) {
            return false;
        }
        if (attributeName.equals("xmlns") || attributeName.startsWith("xmlns:")) {
            return false;
        }
        return !attributeName.equals("type") && !attributeName.equals("onRedeliveryRef") && !attributeName.equals("onRetryWhileRef") && !attributeName.equals("redeliveryPolicyRef") && !attributeName.equals("transactionTemplateRef") && !attributeName.equals("transactionManagerRef");
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String deadLetterUri;
        super.doParse(element, parserContext, builder);
        String id = element.getAttribute("id");
        ErrorHandlerType type = ErrorHandlerType.DefaultErrorHandler;
        if (ObjectHelper.isNotEmpty(element.getAttribute("type"))) {
            type = ErrorHandlerType.valueOf(element.getAttribute("type"));
        }
        if (type.equals((Object)ErrorHandlerType.DefaultErrorHandler) || type.equals((Object)ErrorHandlerType.DeadLetterChannel) || type.equals((Object)ErrorHandlerType.TransactionErrorHandler)) {
            NodeList list = element.getChildNodes();
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                Node child = list.item(i);
                if (!(child instanceof Element)) continue;
                Element childElement = (Element)child;
                String localName = child.getLocalName();
                if (!localName.equals("redeliveryPolicy")) continue;
                if (ObjectHelper.isNotEmpty(element.getAttribute("redeliveryPolicyRef"))) {
                    throw new IllegalArgumentException("Cannot set both redeliveryPolicyRef and redeliveryPolicy, only one allowed, in error handler with id: " + id);
                }
                BeanDefinition redeliveryPolicyDefinition = this.redeliveryPolicyParser.parse(childElement, parserContext);
                builder.addPropertyValue(localName, (Object)redeliveryPolicyDefinition);
            }
            this.parserRefAttribute(element, "onRedeliveryRef", "onRedelivery", builder);
            this.parserRefAttribute(element, "onRetryWhileRef", "onRetryWhile", builder);
            this.parserRefAttribute(element, "redeliveryPolicyRef", "redeliveryPolicy", builder);
            if (type.equals((Object)ErrorHandlerType.TransactionErrorHandler)) {
                this.parserRefAttribute(element, "transactionTemplateRef", "transactionTemplate", builder);
                this.parserRefAttribute(element, "transactionManagerRef", "transactionManager", builder);
            }
        }
        if (ObjectHelper.isNotEmpty(deadLetterUri = element.getAttribute("deadLetterUri")) && !type.equals((Object)ErrorHandlerType.DeadLetterChannel)) {
            throw new IllegalArgumentException("Attribute deadLetterUri can only be used if type is " + ErrorHandlerType.DeadLetterChannel.name() + ", in error handler with id: " + id);
        }
        String transactionTemplateRef = element.getAttribute("transactionTemplateRef");
        if (ObjectHelper.isNotEmpty(transactionTemplateRef) && !type.equals((Object)ErrorHandlerType.TransactionErrorHandler)) {
            throw new IllegalArgumentException("Attribute transactionTemplateRef can only be used if type is " + ErrorHandlerType.TransactionErrorHandler.name() + ", in error handler with id: " + id);
        }
        String transactionManagerRef = element.getAttribute("transactionManagerRef");
        if (ObjectHelper.isNotEmpty(transactionManagerRef) && !type.equals((Object)ErrorHandlerType.TransactionErrorHandler)) {
            throw new IllegalArgumentException("Attribute transactionManagerRef can only be used if type is " + ErrorHandlerType.TransactionErrorHandler.name() + ", in error handler with id: " + id);
        }
        String rollbackLoggingLevel = element.getAttribute("rollbackLoggingLevel");
        if (ObjectHelper.isNotEmpty(rollbackLoggingLevel) && !type.equals((Object)ErrorHandlerType.TransactionErrorHandler)) {
            throw new IllegalArgumentException("Attribute rollbackLoggingLevel can only be used if type is " + ErrorHandlerType.TransactionErrorHandler.name() + ", in error handler with id: " + id);
        }
        String useOriginalMessage = element.getAttribute("useOriginalMessage");
        if (ObjectHelper.isNotEmpty(useOriginalMessage) && (type.equals((Object)ErrorHandlerType.LoggingErrorHandler) || type.equals((Object)ErrorHandlerType.NoErrorHandler))) {
            throw new IllegalArgumentException("Attribute useOriginalMessage is not supported by error handler type: " + type.name() + ", in error handler with id: " + id);
        }
        String onRedeliveryRef = element.getAttribute("onRedeliveryRef");
        if (ObjectHelper.isNotEmpty(onRedeliveryRef) && (type.equals((Object)ErrorHandlerType.LoggingErrorHandler) || type.equals((Object)ErrorHandlerType.NoErrorHandler))) {
            throw new IllegalArgumentException("Attribute onRedeliveryRef is not supported by error handler type: " + type.name() + ", in error handler with id: " + id);
        }
        String retryWhileRef = element.getAttribute("retryWhileRef");
        if (ObjectHelper.isNotEmpty(retryWhileRef) && (type.equals((Object)ErrorHandlerType.LoggingErrorHandler) || type.equals((Object)ErrorHandlerType.NoErrorHandler))) {
            throw new IllegalArgumentException("Attribute retryWhileRef is not supported by error handler type: " + type.name() + ", in error handler with id: " + id);
        }
        String redeliveryPolicyRef = element.getAttribute("redeliveryPolicyRef");
        if (ObjectHelper.isNotEmpty(redeliveryPolicyRef) && (type.equals((Object)ErrorHandlerType.LoggingErrorHandler) || type.equals((Object)ErrorHandlerType.NoErrorHandler))) {
            throw new IllegalArgumentException("Attribute redeliveryPolicyRef is not supported by error handler type: " + type.name() + ", in error handler with id: " + id);
        }
        String executorServiceRef = element.getAttribute("executorServiceRef");
        if (ObjectHelper.isNotEmpty(executorServiceRef) && (type.equals((Object)ErrorHandlerType.LoggingErrorHandler) || type.equals((Object)ErrorHandlerType.NoErrorHandler))) {
            throw new IllegalArgumentException("Attribute executorServiceRef is not supported by error handler type: " + type.name() + ", in error handler with id: " + id);
        }
        String logName = element.getAttribute("logName");
        if (ObjectHelper.isNotEmpty(logName) && !type.equals((Object)ErrorHandlerType.LoggingErrorHandler)) {
            throw new IllegalArgumentException("Attribute logName is not supported by error handler type: " + type.name() + ", in error handler with id: " + id);
        }
        String level = element.getAttribute("level");
        if (ObjectHelper.isNotEmpty(level) && !type.equals((Object)ErrorHandlerType.LoggingErrorHandler)) {
            throw new IllegalArgumentException("Attribute level is not supported by error handler type: " + type.name() + ", in error handler with id: " + id);
        }
    }

    private void parserRefAttribute(Element element, String attributeName, String propertyName, BeanDefinitionBuilder builder) {
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attribute = (Attr)attributes.item(x);
            String name = attribute.getLocalName();
            if (!name.equals(attributeName)) continue;
            Assert.state((boolean)StringUtils.hasText((String)propertyName), (String)"Illegal property name returned from 'extractPropertyName(String)': cannot be null or empty.");
            builder.addPropertyReference(propertyName, attribute.getValue());
        }
    }

    protected class RedeliveryPolicyDefinitionParser
    extends BeanDefinitionParser {
        public RedeliveryPolicyDefinitionParser(Class type) {
            super(type, false);
        }

        protected boolean shouldGenerateId() {
            return true;
        }
    }
}

