/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.core.lib.dosgi;

import org.eclipse.ecf.provider.jaxws.util.ClientUtil;
import org.eclipse.ecf.provider.jaxws.util.JaxWsParams;
import org.modelbus.core.lib.IModelBusHelper;
import org.modelbus.core.lib.configuration.ModelBusException;
import org.modelbus.core.lib.configuration.ModelBusServiceException;
import org.modelbus.core.lib.dosgi.api.Activator;
import org.modelbus.core.lib.util.AbstractLocationsUtil;
import org.modelbus.core.lib.util.LocationsUtilFactory;
import org.modelbus.dosgi.repository.descriptor.RepositoryService;

public abstract class AbstractModelBusHelper
implements IModelBusHelper {
    protected static final String DATASOURCE_TYPE_OCTETSTREAM = "application/octet-stream";
    private RepositoryService service;
    private int mode = 2;
    private boolean forceSecureConnection = false;

    public RepositoryService getService() {
        if (this.service == null) {
            switch (this.mode) {
                case 2: {
                    String serviceLocation = this.getRepositoryServiceLocation();
                    if (serviceLocation == null) {
                        if (this.forcesSecureConnection()) {
                            throw new RuntimeException("Option repository secure location has to be set for ModelBus repository service.");
                        }
                        throw new RuntimeException("Option repository location has to be set for ModelBus repository service.");
                    }
                    JaxWsParams params = new JaxWsParams().setWsdlLocation(String.valueOf(serviceLocation) + "?wsdl").setConnectTimeout(0).setRequestTimeout(0).setMtomEnabled(true);
                    this.service = (RepositoryService)ClientUtil.getEndpointReference(RepositoryService.class, (JaxWsParams)params);
                    break;
                }
                case 1: {
                    try {
                        this.service = (RepositoryService)Activator.getInstance().getService();
                        break;
                    }
                    catch (ModelBusServiceException exc) {
                        throw new RuntimeException(exc);
                    }
                }
                default: {
                    throw new RuntimeException("Invalid mode for repository connection.");
                }
            }
        }
        return this.service;
    }

    public String getRepositoryServiceLocation() {
        String serviceLocation = null;
        try {
            if (this.forcesSecureConnection()) {
                serviceLocation = this.getSecureRepositoryLocation();
                AbstractLocationsUtil.setupSSLConnection();
            } else {
                serviceLocation = this.getRepositoryLocation();
            }
        }
        catch (ModelBusException e) {
            throw new RuntimeException(e);
        }
        if (serviceLocation != null) {
            serviceLocation = AbstractLocationsUtil.getExternalLocation((String)serviceLocation);
        }
        return serviceLocation;
    }

    protected String getRepositoryLocation() {
        return LocationsUtilFactory.getInstance().getLocationsUtil().getRepositoryLocation(true);
    }

    protected String getSecureRepositoryLocation() {
        return LocationsUtilFactory.getInstance().getLocationsUtil().getSecureRepositoryLocation();
    }

    public final Integer getMode() {
        return this.mode;
    }

    public final void setMode(Integer mode) {
        this.mode = mode;
        this.service = null;
    }

    public final boolean forcesSecureConnection() {
        return this.forceSecureConnection;
    }

    public void setForceSecureConnection(boolean value) {
        this.forceSecureConnection = value;
    }
}

