/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.ui.properties;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;
import org.modelbus.tools.diffmerge.ui.properties.EStructuralFeaturePropertyElement;
import org.modelbus.tools.modelbusexplorer.properties.PropertyElement;
import org.modelbus.tools.modelbusexplorer.properties.cache.PropertiesCach;
import org.modelbus.tools.modelbusexplorer.properties.editing.IEditingSupport;

public class AttributeEditingSupport
extends IEditingSupport {
    private final TableViewer tableViewer;

    public AttributeEditingSupport(ColumnViewer viewer) {
        super(viewer);
        this.tableViewer = (TableViewer)viewer;
    }

    public AttributeEditingSupport(TableViewer viewer) {
        super(viewer);
        this.tableViewer = viewer;
    }

    public CellEditor getCellEditor(Object element) {
        EStructuralFeaturePropertyElement prop = (EStructuralFeaturePropertyElement)((Object)element);
        EStructuralFeature second = prop.getFeature();
        if (second instanceof EAttribute) {
            EAttribute eAttribute = (EAttribute)second;
            EDataType eAttributeType = eAttribute.getEAttributeType();
            return new PropertyDescriptor.EDataTypeCellEditor(eAttributeType, (Composite)this.tableViewer.getTable());
        }
        return null;
    }

    public boolean canEdit(Object element) {
        return ((PropertyElement)element).isEditingSupportEnabled();
    }

    public Object getValue(Object element) {
        Object[] value = ((PropertyElement)element).getValue();
        if (value.length > 0) {
            return value[0];
        }
        return null;
    }

    public void setValue(Object element, Object value) {
        Object[] tmp;
        EStructuralFeaturePropertyElement prop = (EStructuralFeaturePropertyElement)((Object)element);
        EObject container = prop.getPropertyContainer();
        EStructuralFeature feature = prop.getFeature();
        if (PropertiesCach.isPropertyCached((PropertyElement)prop)) {
            PropertiesCach.update((PropertyElement)prop);
        }
        Object oldValue = tmp = prop.getValue();
        if (tmp.length == 1) {
            oldValue = tmp[0];
        }
        if ("".equals(value) && oldValue == null) {
            return;
        }
        if (value.equals(oldValue)) {
            return;
        }
        try {
            container.eSet(feature, value);
            prop.setValue(new Object[]{value});
            prop.setPropertyHasChanged(true);
            PropertiesCach.add((PropertyElement)prop);
            this.colorCell();
        }
        catch (Exception exception) {
            prop.setValue(new Object[]{oldValue});
        }
    }

    private void colorCell() {
        TableItem[] selection = this.tableViewer.getTable().getSelection();
        if (selection.length > 0) {
            Color red = Display.getDefault().getSystemColor(3);
            selection[0].setForeground(red);
        }
    }
}

