/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.tools.diffmerge.ui.util;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.modelbus.tools.diffmerge.ui.config.UIConfig;
import org.modelbus.tools.diffmerge.ui.util.GuiHelperUtil;
import org.modelbus.tools.modelbusexplorer.logging.Logger;
import org.modelbus.tools.modelbusexplorer.logging.LoggerFactory;

class ImageUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)GuiHelperUtil.class.getSimpleName());
    private final Map<String, Image> cachedImages = Maps.newHashMap();
    private Image conflictImg;
    private Image folderImg;
    private Image diffModelImg;
    private Image diffGroupImg;
    private Image outChangeImg;
    private Image inChangeImg;
    private Image occOverlayImage;
    private final Display display;
    private final UIConfig config;

    ImageUtil(Display display, UIConfig config) {
        this.display = display;
        this.config = config;
        this.loadImagesByClassLoader();
    }

    void loadImagesByClassLoader() {
        this.conflictImg = new Image((Device)this.display, this.getImageAsStream("/org/modelbus/tools/diffmerge/icons/overlay/conflict.gif"));
        this.outChangeImg = new Image((Device)this.display, this.getImageAsStream("/org/modelbus/tools/diffmerge/icons/overlay/outchg.gif"));
        this.inChangeImg = new Image((Device)this.display, this.getImageAsStream("/org/modelbus/tools/diffmerge/icons/overlay/inchg.gif"));
        this.folderImg = new Image((Device)this.display, this.getImageAsStream("/org/modelbus/tools/diffmerge/icons/DiffGroup.gif"));
        this.diffModelImg = new Image((Device)this.display, this.getImageAsStream("/org/modelbus/tools/diffmerge/icons/DiffModel.gif"));
        this.diffGroupImg = new Image((Device)this.display, this.getImageAsStream("/org/modelbus/tools/diffmerge/icons/DiffGroup.gif"));
        this.occOverlayImage = new Image((Device)this.display, this.getImageAsStream("/org/modelbus/tools/diffmerge/icons/overlay/occurrence.gif"));
    }

    private InputStream getImageAsStream(String imagePathAndName) {
        InputStream resource = this.getClass().getResourceAsStream(imagePathAndName);
        if (resource == null) {
            LOG.info("No image found at : " + imagePathAndName);
        }
        return resource;
    }

    void loadImagesByPath(String imagePath) {
        if (!imagePath.endsWith("/")) {
            imagePath = String.valueOf(imagePath) + "/";
        }
        this.diffModelImg = new Image((Device)this.display, String.valueOf(imagePath) + "DiffModel.gif");
        this.diffGroupImg = new Image((Device)this.display, String.valueOf(imagePath) + "DiffModel.gif");
        this.folderImg = new Image((Device)this.display, String.valueOf(imagePath) + "DiffGroup.gif");
        this.conflictImg = new Image((Device)this.display, String.valueOf(imagePath) + "Overlay/conflict.gif");
        this.outChangeImg = new Image((Device)this.display, String.valueOf(imagePath) + "Overlay/outchg.gif");
        this.inChangeImg = new Image((Device)this.display, String.valueOf(imagePath) + "Overlay/inchg.gif");
        this.occOverlayImage = new Image((Device)this.display, String.valueOf(imagePath) + "Overlay/occurrence.gif");
    }

    Image getOccurenceOverlayImage() {
        return this.occOverlayImage;
    }

    Image getEcoreImage(String className) {
        InputStream stream = this.getImageAsStream("/org/modelbus/tools/diffmerge/icons/ecore/" + className + ".gif");
        if (stream != null) {
            return new Image((Device)this.display, stream);
        }
        return null;
    }

    Image getModelImage(EObject modelElement) {
        String className = modelElement.eClass().getName();
        String modelResourceIconPath = this.config.getIconPath();
        Image classImage = null;
        try {
            URL imagePathURL = null;
            InputStream imageStream = null;
            if (modelResourceIconPath != null) {
                File modelResourceIcons = new File(modelResourceIconPath);
                if (modelResourceIcons.exists()) {
                    URL modelResourceIconsURL = modelResourceIcons.toURI().toURL();
                    imagePathURL = new URL(modelResourceIconsURL + className + ".gif");
                    imageStream = imagePathURL.openStream();
                } else if (modelResourceIconPath.startsWith("jar:file:/")) {
                    imagePathURL = new URL(String.valueOf(modelResourceIconPath) + className + ".gif");
                    imageStream = imagePathURL.openStream();
                } else {
                    imageStream = this.getImageAsStream("/org/modelbus/tools/diffmerge/icons/uml/" + className + ".gif");
                }
            } else {
                imageStream = this.getClass().getResourceAsStream("/UML/" + className + ".gif");
            }
            if (imageStream == null) {
                imageStream = this.getImageAsStream("/org/modelbus/tools/diffmerge/icons/default_icon.gif");
            }
            classImage = new Image((Device)this.display, imageStream);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classImage;
    }

    Image getFolderImage() {
        return this.folderImg;
    }

    Image getDiffModelImage() {
        return this.diffModelImg;
    }

    Image getDiffGroupImage() {
        return this.diffGroupImg;
    }

    Image getUIIcon(String iconName) {
        if (this.cachedImages.containsKey(iconName)) {
            return this.cachedImages.get(iconName);
        }
        InputStream stream = this.getImageAsStream("/org/modelbus/tools/diffmerge/icons/" + iconName + ".gif");
        if (stream == null) {
            LOG.warn(String.format("No image with name %s found", iconName));
        }
        Image image = new Image((Device)this.display, stream);
        this.cachedImages.put(iconName, image);
        return image;
    }

    Image getOutChangeImage() {
        return this.outChangeImg;
    }

    Image getIncomeChangeImage() {
        return this.inChangeImg;
    }

    Image getConflictImage() {
        return this.conflictImg;
    }
}

