/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.export;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.emf.common.util.URI;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.modelbus.core.lib.IRepositoryHelper;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.core.lib.configuration.ModelBusConfiguration;
import org.modelbus.core.lib.configuration.ModelBusException;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.desktop.export.JobDescriptor;
import org.modelbus.desktop.export.JobRegistry;
import org.modelbus.dosgi.repository.descriptor.RepositoryDirEntry;
import org.modelbus.dosgi.repository.descriptor.RepositoryNodeKind;
import org.modelbus.dosgi.repository.descriptor.Session;

public class ExportRepositoryItemServiceHandler
implements ServiceHandler {
    private String revision;
    private List<RepositoryDirEntry> nonExistingEntries;

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int len;
        File tempBaseDir;
        Integer jobID = Integer.valueOf(RWT.getRequest().getParameter("jobID"));
        if (this.nonExistingEntries == null) {
            this.nonExistingEntries = new ArrayList<RepositoryDirEntry>();
        } else {
            this.nonExistingEntries.clear();
        }
        JobDescriptor job = JobRegistry.getInstance().getJob(jobID);
        if (job == null) {
            return;
        }
        Set<RepositoryDirEntry> entries = job.getEntries();
        this.revision = job.getRevision();
        try {
            tempBaseDir = ModelBusConfiguration.getTempFolder();
        }
        catch (ModelBusException e1) {
            throw new RuntimeException(e1);
        }
        File tempDir = new File(String.valueOf(tempBaseDir.getAbsolutePath()) + File.separator + "job_" + jobID + "_r" + this.revision);
        if (!tempDir.exists() && !tempDir.mkdir()) {
            throw new IOException("Can't create temp folder in: " + tempDir.getPath());
        }
        for (RepositoryDirEntry entry : entries) {
            this.checkoutRepositoryItemToTempFolder(entry, tempDir);
        }
        File logFile = new File(String.valueOf(tempDir.getAbsolutePath()) + File.separator + "export.log");
        StringBuilder builder = new StringBuilder();
        builder.append("ModelBus Repository Export (Revision " + this.revision + ")\n\n");
        for (RepositoryDirEntry entry : this.nonExistingEntries) {
            builder.append("Item \"" + entry.getUri() + "\" does not exist in rev " + this.revision + ".\n");
        }
        ByteArrayInputStream iStream = new ByteArrayInputStream(builder.toString().getBytes());
        FileOutputStream out = new FileOutputStream(logFile);
        byte[] buf = new byte[1024];
        while ((len = iStream.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        out.flush();
        ((OutputStream)out).close();
        File zipFile = new File(String.valueOf(tempBaseDir.getAbsolutePath()) + File.separator + "modelbus_export_" + jobID + "_r" + this.revision + "_" + new Date().getTime() + ".zip");
        ArrayList<File> fileList = new ArrayList<File>();
        this.getAllFiles(tempDir, fileList);
        this.writeZipFile(tempDir, zipFile, fileList);
        if (tempDir.exists()) {
            this.deleteDirectory(tempDir);
        }
        byte[] download = this.getBytesFromFile(zipFile);
        response.setContentType("application/octet-stream");
        response.setContentLength(download.length);
        String contentDisposition = "attachment; filename=\"" + zipFile.getName() + "\"";
        response.setHeader("Content-Disposition", contentDisposition);
        try {
            try {
                response.getOutputStream().write(download);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (zipFile.exists()) {
                zipFile.delete();
            }
        }
    }

    private void deleteDirectory(File dir) throws IOException {
        if (dir.exists()) {
            File[] files;
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                } else {
                    file.delete();
                }
                ++n2;
            }
            dir.delete();
        }
    }

    private void getAllFiles(File dir, List<File> fileList) {
        File[] files;
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            fileList.add(file);
            if (file.isDirectory()) {
                this.getAllFiles(file, fileList);
            }
            ++n2;
        }
    }

    private void writeZipFile(File directoryToZip, File zipFile, List<File> fileList) {
        try {
            FileOutputStream fos = new FileOutputStream(zipFile.getAbsolutePath());
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (File file : fileList) {
                if (file.isDirectory()) continue;
                this.addToZip(directoryToZip, file, zos);
            }
            zos.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addToZip(File directoryToZip, File file, ZipOutputStream zos) throws FileNotFoundException, IOException {
        int length;
        FileInputStream fis = new FileInputStream(file);
        String zipFilePath = file.getCanonicalPath().substring(directoryToZip.getCanonicalPath().length() + 1, file.getCanonicalPath().length());
        ZipEntry zipEntry = new ZipEntry(zipFilePath);
        zos.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zos.write(bytes, 0, length);
        }
        zos.closeEntry();
        fis.close();
    }

    private byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("File to large");
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    private void checkoutRepositoryItemToTempFolder(RepositoryDirEntry item, File dir) throws IOException {
        IRepositoryHelper repoHelper = ModelBusCoreLib.getRepositoryHelper();
        Session session = UserSessionHelper.getInstance().getSession();
        if (session == null) {
            throw new RuntimeException("Login required");
        }
        URI itemURI = URI.createURI((String)item.getUri());
        if (item.getKind() == RepositoryNodeKind.DIR) {
            RepositoryDirEntry[] subEntries;
            File tempDir = new File(String.valueOf(dir.getAbsolutePath()) + File.separator + item.getName());
            if (!tempDir.exists() && !tempDir.mkdir()) {
                throw new IOException("Could not create temp directory: " + tempDir.getAbsolutePath());
            }
            try {
                subEntries = repoHelper.getDirEntries(session, itemURI, "-1");
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (subEntries != null) {
                RepositoryDirEntry[] repositoryDirEntryArray = subEntries;
                int n = subEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    RepositoryDirEntry subEntry = repositoryDirEntryArray[n2];
                    this.checkoutRepositoryItemToTempFolder(subEntry, tempDir);
                    ++n2;
                }
            }
        } else {
            int len;
            InputStream iStream;
            try {
                iStream = repoHelper.checkOutFile(session, itemURI, this.revision);
            }
            catch (Exception exception) {
                this.nonExistingEntries.add(item);
                return;
            }
            File f = new File(String.valueOf(dir.getAbsolutePath()) + File.separator + item.getName());
            FileOutputStream out = new FileOutputStream(f);
            byte[] buf = new byte[1024];
            while ((len = iStream.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            out.flush();
            ((OutputStream)out).close();
            iStream.close();
        }
    }
}

