/*
 * Decompiled with CFR 0.152.
 */
package org.modelbus.desktop.model;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.modelbus.core.lib.ModelBusCoreLib;
import org.modelbus.desktop.auth.api.UserSessionHelper;
import org.modelbus.desktop.model.ModelViewComposite;
import org.modelbus.desktop.model.RemoteFileDescriptor;
import org.modelbus.desktop.model.RemoteFileEditorInput;
import org.modelbus.desktop.util.RepositoryItemHelper;
import org.modelbus.dosgi.repository.descriptor.RepositoryAuthentificationException;
import org.modelbus.dosgi.repository.descriptor.RepositoryLogEntry;

public class ModelEditor
extends EditorPart {
    public static final String ID = "org.modelbus.desktop.ModelEditor";
    private Text editorTextField;
    private Composite revisionComposite;
    private Font revFontPas;
    private Font revFontAct;
    private Link selectedLink;
    private Map<String, Link> links;
    private ModelViewComposite compositeModel;
    private CTabFolder tabFolder;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        if (input == null || !(input instanceof RemoteFileEditorInput)) {
            throw new IllegalArgumentException("ModelEditor requires editor input of type " + RemoteFileEditorInput.class.getName());
        }
        this.setInput(input);
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.firePropertyChange(258);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void updateUI() {
        IEditorInput input = this.getEditorInput();
        this.setTitle(input.getName());
        RemoteFileEditorInput remoteInput = (RemoteFileEditorInput)input;
        this.editorTextField.setText(remoteInput.getFileContent());
        this.editorTextField.setEditable(false);
        this.refreshModelTreeView();
        String currentRevision = remoteInput.getRevision();
        if (this.selectedLink != null) {
            this.selectedLink.setFont(this.revFontPas);
        }
        this.selectedLink = this.links.get(currentRevision);
        if (this.selectedLink != null) {
            this.selectedLink.setFont(this.revFontAct);
        }
    }

    private void refreshModelTreeView() {
        Resource resource;
        if (this.tabFolder.getSelectionIndex() != 1) {
            this.compositeModel.setModel(null);
            return;
        }
        RemoteFileEditorInput remoteInput = (RemoteFileEditorInput)this.getEditorInput();
        ResourceSet resourceSet = UserSessionHelper.getInstance().getResourceSet();
        URI uri = remoteInput.getURI();
        boolean resourceLoaded = false;
        for (Resource r : resourceSet.getResources()) {
            if (!r.getURI().equals(uri)) continue;
            resourceLoaded = true;
            break;
        }
        if (resourceLoaded) {
            resource = resourceSet.getResource(uri, true);
            resource.unload();
            resourceSet.getResources().remove((Object)resource);
        }
        resource = resourceSet.createResource(uri);
        String currentRevision = remoteInput.getRevision();
        try {
            ModelBusCoreLib.getRepositoryHelper().checkoutModelWithDependencies(UserSessionHelper.getInstance().getSession(), resource, currentRevision, Collections.EMPTY_MAP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.compositeModel.setModel(resource);
    }

    public void createPartControl(Composite parent) {
        this.links = new HashMap<String, Link>();
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout(256));
        SashForm sashForm = new SashForm(container, 68096);
        sashForm.setSashWidth(0);
        Composite contentComposite = new Composite((Composite)sashForm, 0);
        contentComposite.setLayout((Layout)new FillLayout(256));
        this.tabFolder = new CTabFolder(contentComposite, 3072);
        this.tabFolder.addSelectionListener(new SelectionListener(){
            private static final long serialVersionUID = 8125626789476756279L;

            public void widgetSelected(SelectionEvent e) {
                if (ModelEditor.this.tabFolder.getSelectionIndex() == 1) {
                    ModelEditor.this.refreshModelTreeView();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        CTabItem tabItemSource = new CTabItem(this.tabFolder, 0);
        tabItemSource.setText("Source");
        Composite compositeSource = new Composite((Composite)this.tabFolder, 0);
        tabItemSource.setControl((Control)compositeSource);
        compositeSource.setLayout((Layout)new FillLayout(256));
        CTabItem tabItemModel = new CTabItem(this.tabFolder, 0);
        tabItemModel.setText("Tree");
        this.compositeModel = new ModelViewComposite((Composite)this.tabFolder, 0);
        tabItemModel.setControl((Control)this.compositeModel);
        this.tabFolder.setSelection(tabItemSource);
        this.editorTextField = new Text(compositeSource, 2);
        this.editorTextField.setBackground(compositeSource.getDisplay().getSystemColor(1));
        Composite outerContainer = new Composite((Composite)sashForm, 0);
        outerContainer.setLayout((Layout)new FillLayout(256));
        final ScrolledComposite revisionScrolledComposite = new ScrolledComposite(outerContainer, 768);
        revisionScrolledComposite.setLayout((Layout)new FillLayout(256));
        revisionScrolledComposite.setExpandHorizontal(true);
        revisionScrolledComposite.setExpandVertical(true);
        this.revisionComposite = new Composite((Composite)revisionScrolledComposite, 0);
        revisionScrolledComposite.setContent((Control)this.revisionComposite);
        revisionScrolledComposite.addControlListener((ControlListener)new ControlAdapter(){
            private static final long serialVersionUID = -8068283860454878971L;

            public void controlResized(ControlEvent e) {
                Rectangle r = revisionScrolledComposite.getClientArea();
                revisionScrolledComposite.setMinSize(ModelEditor.this.revisionComposite.computeSize(r.width, -1));
            }
        });
        RowLayout revisionCompositeLayout = new RowLayout(256);
        revisionCompositeLayout.marginRight = 10;
        revisionCompositeLayout.spacing = 20;
        revisionCompositeLayout.marginTop = 10;
        revisionCompositeLayout.marginBottom = 10;
        revisionCompositeLayout.marginLeft = 10;
        this.revisionComposite.setLayout((Layout)revisionCompositeLayout);
        this.revisionComposite.setBackground(new Color((Device)this.revisionComposite.getDisplay(), 241, 241, 241));
        sashForm.setWeights(new int[]{5, 1});
        final RemoteFileEditorInput remoteInput = (RemoteFileEditorInput)this.getEditorInput();
        RepositoryLogEntry[] logEntries = null;
        try {
            logEntries = RepositoryItemHelper.getLogEntries(remoteInput.getURI(), true, "1", "-1");
        }
        catch (RepositoryAuthentificationException e) {
            throw new RuntimeException(e);
        }
        if (logEntries != null) {
            int digitCount = 3;
            String maxRev = logEntries[logEntries.length - 1].getRevision();
            if (maxRev.length() > 2) {
                digitCount = String.valueOf(maxRev).length();
            }
            String revFormat = "";
            int i = 0;
            while (i < digitCount) {
                revFormat = String.valueOf(revFormat) + "0";
                ++i;
            }
            RepositoryLogEntry[] repositoryLogEntryArray = logEntries;
            int n = logEntries.length;
            int n2 = 0;
            while (n2 < n) {
                final RepositoryLogEntry logEntry = repositoryLogEntryArray[n2];
                Link viewRevLink = new Link(this.revisionComposite, 0);
                if (this.revFontPas == null) {
                    this.revFontPas = viewRevLink.getFont();
                    FontData[] fD = this.revFontPas.getFontData();
                    fD[0].setStyle(1);
                    this.revFontAct = new Font((Device)this.revisionComposite.getDisplay(), fD[0]);
                }
                String revision = logEntry.getRevision();
                String revisionFormatted = null;
                try {
                    Long revisionLong = Long.parseLong(revision);
                    DecimalFormat df = new DecimalFormat(revFormat);
                    revisionFormatted = df.format(revisionLong);
                }
                catch (NumberFormatException numberFormatException) {
                    revisionFormatted = revision;
                }
                this.links.put(revision, viewRevLink);
                viewRevLink.setText("<a>" + revisionFormatted + "</a>");
                viewRevLink.setToolTipText("Revision " + revision + " (Log message: \"" + logEntry.getMessage() + "\")");
                viewRevLink.addMouseListener((MouseListener)new MouseAdapter(){
                    private static final long serialVersionUID = -5142354695044417658L;

                    public void mouseUp(MouseEvent e) {
                        RemoteFileDescriptor descr = new RemoteFileDescriptor(remoteInput.getURI(), logEntry.getRevision());
                        ModelEditor.this.setInput(new RemoteFileEditorInput(descr));
                        ModelEditor.this.updateUI();
                    }
                });
                ++n2;
            }
        }
        revisionScrolledComposite.setMinSize(this.revisionComposite.computeSize(-1, -1));
        this.updateUI();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void setFocus() {
        if (this.editorTextField != null) {
            this.editorTextField.setFocus();
        }
    }
}

